/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.rdf.wrapping.commons;

import com.inrupt.rdf.wrapping.commons.ValueMapping;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDFTerm;

public final class ValueMappings {
    private static final String TERM_REQUIRED = "Term must not be null";
    private static final String GRAPH_REQUIRED = "Graph must not be null";
    private static final String TERM_IS_NOT_LITERAL = "Term is not literal";

    public static String literalAsString(RDFTerm term, Graph graph) {
        Objects.requireNonNull(term, TERM_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        if (!(term instanceof Literal)) {
            throw new IllegalStateException(TERM_IS_NOT_LITERAL);
        }
        return ((Literal)term).getLexicalForm();
    }

    public static URI iriAsUri(RDFTerm term, Graph graph) {
        Objects.requireNonNull(term, TERM_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        if (!(term instanceof IRI)) {
            throw new IllegalStateException("Term is not IRI");
        }
        return URI.create(((IRI)term).getIRIString());
    }

    public static String iriAsString(RDFTerm term, Graph graph) {
        Objects.requireNonNull(term, TERM_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        if (!(term instanceof IRI)) {
            throw new IllegalStateException("Term is not IRI");
        }
        return ((IRI)term).getIRIString();
    }

    public static Instant literalAsInstant(RDFTerm term, Graph graph) {
        Objects.requireNonNull(term, TERM_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        if (!(term instanceof Literal)) {
            throw new IllegalStateException(TERM_IS_NOT_LITERAL);
        }
        return Instant.parse(((Literal)term).getLexicalForm());
    }

    public static Boolean literalAsBoolean(RDFTerm term, Graph graph) {
        Objects.requireNonNull(term, TERM_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        if (!(term instanceof Literal)) {
            throw new IllegalStateException(TERM_IS_NOT_LITERAL);
        }
        return Boolean.parseBoolean(((Literal)term).getLexicalForm());
    }

    public static Integer literalAsIntegerOrNull(RDFTerm term, Graph graph) {
        Objects.requireNonNull(term, TERM_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        if (!(term instanceof Literal)) {
            throw new IllegalStateException("Node is not literal");
        }
        try {
            return Integer.parseInt(((Literal)term).getLexicalForm());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static <T extends RDFTerm> ValueMapping<T> as(Class<T> view) {
        Objects.requireNonNull(view, "View must not be null");
        return (term, graph) -> ValueMappings.as(term, graph, view);
    }

    private static <T extends RDFTerm> T as(RDFTerm term, Graph graph, Class<T> view) {
        Objects.requireNonNull(term, TERM_REQUIRED);
        Constructor<T> termAndGraphConstructor = ValueMappings.findConstructor(view, RDFTerm.class, Graph.class);
        if (termAndGraphConstructor != null) {
            return (T)((RDFTerm)ValueMappings.instantiate(termAndGraphConstructor, term, graph));
        }
        Constructor<T> justTermConstructor = ValueMappings.findConstructor(view, RDFTerm.class);
        if (justTermConstructor != null) {
            return (T)((RDFTerm)ValueMappings.instantiate(justTermConstructor, term));
        }
        throw new IllegalStateException("No constructor found with parameter types (RDFTerm, Graph) or (RDFTerm)");
    }

    private static <T> Constructor<T> findConstructor(Class<T> view, Class<?> ... parameterTypes) {
        try {
            return view.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static <T> T instantiate(Constructor<T> constructor, Object ... initArgs) {
        try {
            return constructor.newInstance(initArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Could not instantiate wrapping class", e);
        }
    }

    private ValueMappings() {
    }
}

