/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.rdf.wrapping.commons;

import com.inrupt.rdf.wrapping.commons.RDFFactory;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;

public final class TermMappings {
    private static final String VALUE_REQUIRED = "Value must not be null";
    private static final String GRAPH_REQUIRED = "Graph must not be null";
    private static final RDF FACTORY = RDFFactory.getInstance();

    public static Literal asStringLiteral(String value, Graph graph) {
        Objects.requireNonNull(value, VALUE_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        return FACTORY.createLiteral(value);
    }

    public static IRI asIri(String value, Graph graph) {
        Objects.requireNonNull(value, VALUE_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        return FACTORY.createIRI(value);
    }

    public static IRI asIri(URI value, Graph graph) {
        Objects.requireNonNull(value, VALUE_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        return FACTORY.createIRI(value.toString());
    }

    public static Literal asTypedLiteral(Instant value, Graph graph) {
        Objects.requireNonNull(value, VALUE_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        return FACTORY.createLiteral(value.toString(), FACTORY.createIRI("http://www.w3.org/2001/XMLSchema#dateTime"));
    }

    public static Literal asTypedLiteral(Boolean value, Graph graph) {
        Objects.requireNonNull(value, VALUE_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        return FACTORY.createLiteral(value.toString(), FACTORY.createIRI("http://www.w3.org/2001/XMLSchema#boolean"));
    }

    public static RDFTerm identity(RDFTerm value, Graph graph) {
        Objects.requireNonNull(value, VALUE_REQUIRED);
        Objects.requireNonNull(graph, GRAPH_REQUIRED);
        return value;
    }

    private TermMappings() {
    }
}

