/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.rdf.wrapping.commons;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;

public class WrapperDataset
implements Dataset {
    private final Dataset original;

    protected WrapperDataset(Dataset original) {
        Objects.requireNonNull(original, "Dataset is required");
        this.original = original;
    }

    public void add(Quad quad) {
        this.original.add(quad);
    }

    public void add(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.original.add(graphName, subject, predicate, object);
    }

    public boolean contains(Quad quad) {
        return this.original.contains(quad);
    }

    public boolean contains(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.original.contains(graphName, subject, predicate, object);
    }

    public Graph getGraph() {
        return this.original.getGraph();
    }

    public Optional<Graph> getGraph(BlankNodeOrIRI graphName) {
        return this.original.getGraph(graphName);
    }

    public Stream<BlankNodeOrIRI> getGraphNames() {
        return this.original.getGraphNames();
    }

    public void remove(Quad quad) {
        this.original.remove(quad);
    }

    public void remove(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.original.remove(graphName, subject, predicate, object);
    }

    public void clear() {
        this.original.clear();
    }

    public long size() {
        return this.original.size();
    }

    public Stream<? extends Quad> stream() {
        return this.original.stream();
    }

    public Stream<? extends Quad> stream(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.original.stream(graphName, subject, predicate, object);
    }
}

