/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.rdf.wrapping.commons;

import com.inrupt.rdf.wrapping.commons.ObjectSet;
import com.inrupt.rdf.wrapping.commons.TermMapping;
import com.inrupt.rdf.wrapping.commons.ValueMapping;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public abstract class WrapperBlankNodeOrIRI
implements BlankNodeOrIRI {
    protected final Graph graph;

    protected WrapperBlankNodeOrIRI(Graph graph) {
        Objects.requireNonNull(graph, "Graph is required");
        this.graph = graph;
    }

    protected <T> T anyOrNull(IRI p, ValueMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        try (Stream<T> stream = this.objectStream(p, m);){
            T t = stream.findAny().orElse(null);
            return t;
        }
    }

    protected <T> T anyOrThrow(IRI p, ValueMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        return this.atLeastOne(p, m).next();
    }

    protected <T> T singleOrNull(IRI p, ValueMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        Iterator<T> objects = this.objectIterator(p, m);
        if (!objects.hasNext()) {
            return null;
        }
        T any = objects.next();
        this.atMostOne(objects, p);
        return any;
    }

    protected <T> T singleOrThrow(IRI p, ValueMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        Iterator<T> objects = this.atLeastOne(p, m);
        T any = objects.next();
        this.atMostOne(objects, p);
        return any;
    }

    protected <T> Iterator<T> objectIterator(IRI p, ValueMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        try (Stream stream = this.objectStream(p, m);){
            Iterator iterator = stream.collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList)).iterator();
            return iterator;
        }
    }

    protected <T> Set<T> objectsReadOnly(IRI p, ValueMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        try (Stream stream = this.objectStream(p, m);){
            Set set = stream.collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
            return set;
        }
    }

    protected <T> Set<T> objects(IRI p, TermMapping<T> tm, ValueMapping<T> vm) {
        return new ObjectSet<T>(this, p, this.graph, tm, vm);
    }

    protected <T> Stream<T> objectStream(IRI p, ValueMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        return this.graph.stream((BlankNodeOrIRI)this, p, null).map(Triple::getObject).map(term -> m.apply((RDFTerm)term, this.graph));
    }

    protected <T> void overwrite(IRI p, T v, TermMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(v);
        Objects.requireNonNull(m);
        this.remove(p);
        this.add(p, v, m);
    }

    protected <T> void overwrite(IRI p, Iterable<T> v, TermMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(v);
        Objects.requireNonNull(m);
        v.forEach(Objects::requireNonNull);
        this.remove(p);
        v.forEach(value -> this.add(p, value, m));
    }

    protected <T> void overwriteNullable(IRI p, Iterable<T> v, TermMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        if (v != null) {
            v.forEach(Objects::requireNonNull);
        }
        this.remove(p);
        if (v == null) {
            return;
        }
        v.forEach(value -> this.add(p, value, m));
    }

    protected <T> void overwriteNullable(IRI p, T v, TermMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(m);
        this.remove(p);
        if (v == null) {
            return;
        }
        this.add(p, v, m);
    }

    protected <T> void add(IRI p, T v, TermMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(v);
        Objects.requireNonNull(m);
        this.graph.add((BlankNodeOrIRI)this, p, m.apply(v, this.graph));
    }

    protected <T> void add(IRI p, Iterable<T> v, TermMapping<T> m) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(v);
        Objects.requireNonNull(m);
        v.forEach(Objects::requireNonNull);
        v.forEach(value -> this.add(p, value, m));
    }

    private void remove(IRI p) {
        this.graph.remove((BlankNodeOrIRI)this, p, null);
    }

    private <T> void atMostOne(Iterator<T> objects, IRI p) {
        if (objects.hasNext()) {
            String message = String.format("Multiple statements with subject [%s] and predicate [%s]", this, p);
            throw new IllegalStateException(message);
        }
    }

    private <T> Iterator<T> atLeastOne(IRI p, ValueMapping<T> m) {
        Iterator<T> objects = this.objectIterator(p, m);
        if (!objects.hasNext()) {
            String message = String.format("No statements with subject [%s] and predicate [%s]", this, p);
            throw new IllegalStateException(message);
        }
        return objects;
    }
}

