/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.rdf.wrapping.commons;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class WrapperGraph
implements Graph {
    private final Graph original;

    protected WrapperGraph(Graph original) {
        Objects.requireNonNull(original, "Graph is required");
        this.original = original;
    }

    public void add(Triple triple) {
        this.original.add(triple);
    }

    public void add(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.original.add(subject, predicate, object);
    }

    public boolean contains(Triple triple) {
        return this.original.contains(triple);
    }

    public boolean contains(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.original.contains(subject, predicate, object);
    }

    public void remove(Triple triple) {
        this.original.remove(triple);
    }

    public void remove(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.original.remove(subject, predicate, object);
    }

    public void clear() {
        this.original.clear();
    }

    public long size() {
        return this.original.size();
    }

    public Stream<? extends Triple> stream() {
        return this.original.stream();
    }

    public Stream<? extends Triple> stream(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.original.stream(subject, predicate, object);
    }
}

