/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave;

import com.insightfullogic.lambdabehave.BehaveRunner;
import com.insightfullogic.lambdabehave.ConcreteRunner;
import com.insightfullogic.lambdabehave.SpecificationDeclarationException;
import com.insightfullogic.lambdabehave.impl.CompleteBehaviour;
import com.insightfullogic.lambdabehave.impl.Specifier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public final class JunitSuiteRunner
extends ParentRunner<Runner> {
    private final List<Runner> fRunners;

    public JunitSuiteRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.fRunners = JunitSuiteRunner.createRunners(testClass);
    }

    private static List<Runner> createRunners(Class<?> testClass) throws InitializationError {
        Map<String, List<CompleteBehaviour>> suites = JunitSuiteRunner.findSuitesInClass(testClass);
        return suites.entrySet().stream().map(e -> JunitSuiteRunner.tryCreateRunner(testClass, (String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
    }

    private static Map<String, List<CompleteBehaviour>> findSuitesInClass(Class<?> testClass) {
        List<Specifier> specifiers = BehaveRunner.declareOnly(testClass);
        return specifiers.stream().flatMap(Specifier::completeBehaviours).collect(Collectors.groupingBy(b -> b.getSuiteName(), Collectors.toList()));
    }

    private static ConcreteRunner tryCreateRunner(Class<?> testClass, String name, List<CompleteBehaviour> children) {
        try {
            return new ConcreteRunner(testClass, name, children);
        }
        catch (InitializationError e) {
            throw new SpecificationDeclarationException("Unable to create specification from: " + testClass, e);
        }
    }

    protected List<Runner> getChildren() {
        return this.fRunners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }
}

