/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.expectations;

import com.insightfullogic.lambdabehave.expectations.CollectionExpectation;
import com.insightfullogic.lambdabehave.expectations.StringExpectation;
import com.insightfullogic.lambdabehave.impl.HasTypesafeProperty;
import java.util.Collection;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class BoundExpectation<T> {
    protected final boolean positive;
    protected final T objectUnderTest;

    BoundExpectation(T value, boolean positive) {
        this.objectUnderTest = value;
        this.positive = positive;
    }

    public <O> BoundExpectation<O> and(O value) {
        return new BoundExpectation<O>(value, true);
    }

    public <O> CollectionExpectation<O> and(Collection<O> collection) {
        return new CollectionExpectation<O>(collection, true);
    }

    public StringExpectation and(String str) {
        return new StringExpectation(str, true);
    }

    public BoundExpectation<T> isEqualTo(T expected) {
        return this.matches(Matchers.equalTo(expected));
    }

    public BoundExpectation<T> hasToString(Matcher<? super String> str) {
        return this.matches(Matchers.hasToString(str));
    }

    public BoundExpectation<T> hasToString(String str) {
        return this.matches(Matchers.hasToString((String)str));
    }

    public BoundExpectation<T> instanceOf(Class<?> type) {
        return this.matches(Matchers.instanceOf(type));
    }

    public BoundExpectation<T> isNotNull() {
        return this.matches(Matchers.notNullValue());
    }

    public BoundExpectation<T> toBeNull() {
        return this.matches(Matchers.nullValue());
    }

    public BoundExpectation<T> sameInstance(T target) {
        return this.matches(Matchers.sameInstance(target));
    }

    public BoundExpectation<T> any() {
        return this.matches(Matchers.any(this.getWrappedClass()));
    }

    public BoundExpectation<T> hasProperty(String propertyName, Matcher<?> propertyValue) {
        return this.matches(Matchers.hasProperty((String)propertyName, propertyValue));
    }

    public BoundExpectation<T> is(Matcher<? super T> matcher) {
        return this.matches(matcher);
    }

    public BoundExpectation<T> has(Matcher<? super T> matcher) {
        return this.is((T)matcher);
    }

    public BoundExpectation<T> is(T value) {
        return this.matches(Matchers.is(value));
    }

    public BoundExpectation<T> isIn(Collection<T> values) {
        return this.matches(Matchers.isIn(values));
    }

    public BoundExpectation<T> isIn(T ... values) {
        return this.matches(Matchers.isIn((Object[])values));
    }

    public BoundExpectation<T> never() {
        return new BoundExpectation<T>(this.objectUnderTest, !this.positive);
    }

    public <P> BoundExpectation<T> hasPropertyOf(Function<T, P> getter, Matcher<P> propertymatcher) {
        return this.matches((Matcher<? super T>)new HasTypesafeProperty<T, P>(getter, propertymatcher));
    }

    public <P> BoundExpectation<T> hasProperty(Function<T, P> getter, P property) {
        return this.hasPropertyOf(getter, Matchers.is(property));
    }

    private BoundExpectation<T> matches(Matcher<? super T> matcher) {
        Assert.assertThat(this.objectUnderTest, this.negatedIfNeeded(matcher));
        return this;
    }

    protected Matcher<? super T> negatedIfNeeded(Matcher<? super T> matcher) {
        return this.positive ? matcher : Matchers.not(matcher);
    }

    protected Class<T> getWrappedClass() {
        return this.objectUnderTest.getClass();
    }
}

