/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.expectations;

import com.insightfullogic.lambdabehave.Block;
import com.insightfullogic.lambdabehave.expectations.ArrayExpectation;
import com.insightfullogic.lambdabehave.expectations.BoundExpectation;
import com.insightfullogic.lambdabehave.expectations.CollectionExpectation;
import com.insightfullogic.lambdabehave.expectations.ComparableExpectation;
import com.insightfullogic.lambdabehave.expectations.DoubleExpectation;
import com.insightfullogic.lambdabehave.expectations.StringExpectation;
import com.insightfullogic.lambdabehave.expectations.TriConsumer;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;

public final class Expect {
    public <T> BoundExpectation<T> that(T value) {
        return new BoundExpectation<T>(value, true);
    }

    public <T> CollectionExpectation<T> that(Collection<T> collection) {
        return new CollectionExpectation<T>(collection, true);
    }

    public <T extends Comparable<T>> ComparableExpectation<T> that(T comparable) {
        return new ComparableExpectation<T>(comparable, true);
    }

    public StringExpectation that(String str) {
        return new StringExpectation(str, true);
    }

    public DoubleExpectation that(Double value) {
        return new DoubleExpectation(value, true);
    }

    public <T> ArrayExpectation<T> that(T[] array) {
        return new ArrayExpectation<T>(array, true);
    }

    public <T extends Throwable> BoundExpectation<T> exception(Class<T> expectedException, Block block) throws Exception {
        String expectedName = expectedException.getName();
        try {
            block.run();
        }
        catch (Throwable throwable) {
            if (!expectedException.isInstance(throwable)) {
                String name = throwable.getClass().getName();
                this.failure("Expected exception: " + expectedName + ", but " + name + " was thrown");
            }
            return new BoundExpectation<Throwable>(throwable, true);
        }
        this.failure("Expected exception: " + expectedName + ", but no exception was thrown");
        return null;
    }

    public void failure(String message) {
        Assert.fail((String)message);
    }

    public <T> Stubber toAnswer(Runnable method) {
        return Mockito.doAnswer(invocation -> {
            Object[] arguments = invocation.getArguments();
            method.run();
            return null;
        });
    }

    public <T> Stubber toAnswer(Consumer<T> method) {
        return this.doAnswer(arguments -> method.accept(arguments[0]), 1);
    }

    public <F, S> Stubber toAnswer(BiConsumer<F, S> method) {
        return this.doAnswer(arguments -> method.accept(arguments[0], arguments[1]), 2);
    }

    public <F, S, T> Stubber toAnswer(TriConsumer<F, S, T> method) {
        return this.doAnswer(arguments -> method.accept(arguments[0], arguments[1], arguments[2]), 3);
    }

    private Stubber doAnswer(Consumer<Object[]> method, int argumentCount) {
        return Mockito.doAnswer(invocation -> {
            Object[] arguments = invocation.getArguments();
            if (arguments.length >= argumentCount) {
                method.accept(arguments);
            } else {
                this.failure("Invocation requires at least " + argumentCount + " argument");
            }
            return null;
        });
    }
}

