/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.generators;

import com.insightfullogic.lambdabehave.generators.SourceGenerator;
import com.insightfullogic.lambdabehave.generators.TriFunction;
import com.insightfullogic.lambdabehave.impl.generators.Generators;
import com.insightfullogic.lambdabehave.impl.generators.StringGenerator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;

@FunctionalInterface
public interface Generator<T> {
    public static final int MAX_TRIES = 100000;

    public static Generator<String> strings() {
        return new StringGenerator(32, 65535);
    }

    public static Generator<String> asciiStrings() {
        return new StringGenerator(32, 126);
    }

    public static Generator<Character> asciiCharacters() {
        return source -> {
            int index = source.generateInt(94);
            return Character.valueOf((char)(32 + index));
        };
    }

    public static Generator<Integer> integersUpTo(int maxValue) {
        return source -> source.generateInt(maxValue);
    }

    public static <V, F> Generator<V> of(Function<F, V> constructor, Generator<F> firstArgumentGenerator) {
        return source -> {
            Object argument = firstArgumentGenerator.generate(source);
            return constructor.apply(argument);
        };
    }

    public static <V, F, S> Generator<V> of(BiFunction<F, S, V> constructor, Generator<F> firstArgumentGenerator, Generator<S> secondArgumentGenerator) {
        return source -> {
            Object first = firstArgumentGenerator.generate(source);
            Object second = secondArgumentGenerator.generate(source);
            return constructor.apply(first, second);
        };
    }

    public static <V, F, S, T> Generator<V> of(TriFunction<F, S, T, V> constructor, Generator<F> firstArgumentGenerator, Generator<S> secondArgumentGenerator, Generator<T> thirdArgumentGenerator) {
        return source -> {
            Object first = firstArgumentGenerator.generate(source);
            Object second = secondArgumentGenerator.generate(source);
            Object third = thirdArgumentGenerator.generate(source);
            return constructor.apply(first, second, third);
        };
    }

    public static Generator<Long> longs() {
        return Generators::longs;
    }

    public static Generator<Double> doubles() {
        return ng -> Double.longBitsToDouble(Generators.longs(ng));
    }

    public static Generator<Float> floats() {
        return ng -> Float.valueOf(Float.intBitsToFloat(ng.generateInt(Integer.MAX_VALUE)));
    }

    public T generate(SourceGenerator var1);

    default public Generator<T> matching(Predicate<T> predicate) {
        return rng -> {
            Optional<Object> candidate = IntStream.range(0, 100000).mapToObj(i -> this.generate(rng)).filter(predicate).findFirst();
            return candidate.orElseThrow(Generators::exceededMaxTries);
        };
    }
}

