/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.specifications;

import com.insightfullogic.lambdabehave.impl.Specifier;
import com.insightfullogic.lambdabehave.impl.specifications.TripletRow;
import com.insightfullogic.lambdabehave.specifications.ThreeColumnDataSpecification;
import com.insightfullogic.lambdabehave.specifications.ThreeColumns;
import java.util.ArrayList;
import java.util.List;

public final class TripletRecorder<F, S, T>
implements ThreeColumns<F, S, T> {
    private final List<TripletRow<F, S, T>> values;
    private final Specifier specifier;

    public TripletRecorder(F first, S second, T third, Specifier specifier) {
        this.specifier = specifier;
        this.values = new ArrayList<TripletRow<F, S, T>>();
        this.and((Object)first, (Object)second, (Object)third);
    }

    public TripletRecorder(List<F> first, List<S> second, List<T> third, Specifier specifier) {
        this.specifier = specifier;
        int size = first.size();
        if (size != second.size() || size != third.size()) {
            throw new IllegalArgumentException("Lengths not identical: " + size + ", " + second.size() + ", " + third.size());
        }
        this.values = new ArrayList<TripletRow<F, S, T>>(size);
        for (int i = 0; i < size; ++i) {
            this.and((Object)first.get(i), (Object)second.get(i), (Object)third.get(i));
        }
    }

    @Override
    public TripletRecorder<F, S, T> and(F first, S second, T third) {
        this.values.add(new TripletRow<F, S, T>(first, second, third));
        return this;
    }

    @Override
    public ThreeColumns<F, S, T> toShow(String descriptionFormat, ThreeColumnDataSpecification<F, S, T> specification) {
        this.specifier.recordDataDrivenSpecification3(descriptionFormat, this.values);
        return this;
    }
}

