/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave;

import com.insightfullogic.lambdabehave.SpecificationDeclarationException;
import com.insightfullogic.lambdabehave.generators.SourceGenerator;
import com.insightfullogic.lambdabehave.impl.Specifier;
import com.insightfullogic.lambdabehave.impl.generators.NumberGenerators;
import com.insightfullogic.lambdabehave.impl.generators.RandomNumberGenerator;
import com.insightfullogic.lambdabehave.impl.output.ConsoleFormatter;
import com.insightfullogic.lambdabehave.impl.reports.Report;
import com.insightfullogic.lambdabehave.impl.reports.Specifiers;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class BehaveRunner {
    private final List<Class<?>> specifications;
    private final SourceGenerator generator;
    private final Report report = new Report();

    public static void main(String[] args) {
        new BehaveRunner(args).runAll().printReport();
    }

    public static Report runOnly(Class<?> specClass) {
        return new BehaveRunner().run(specClass).getReport();
    }

    public static Report runOnly(long seed, Class<?> specClass) {
        return new BehaveRunner(SourceGenerator.deterministicNumbers(seed)).run(specClass).getReport();
    }

    public static List<Specifier> declareOnly(Class<?> specClass) {
        return new BehaveRunner().declare(specClass);
    }

    private static Stream<Class<?>> loadClassOrPackage(String name) {
        try {
            return Stream.of(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            throw new SpecificationDeclarationException("Unable to create suite from: " + name, e);
        }
    }

    public BehaveRunner() {
        this(new RandomNumberGenerator());
    }

    public BehaveRunner(SourceGenerator generator) {
        this(Collections.emptyList(), generator);
    }

    public BehaveRunner(String ... specifications) {
        this(Stream.of(specifications).flatMap(BehaveRunner::loadClassOrPackage).collect(Collectors.toList()));
    }

    public BehaveRunner(List<Class<?>> specifications) {
        this(specifications, new RandomNumberGenerator());
    }

    public BehaveRunner(List<Class<?>> specifications, SourceGenerator generator) {
        this.specifications = specifications;
        this.generator = generator;
    }

    public BehaveRunner runAll() {
        this.specifications.forEach(this::run);
        return this;
    }

    private BehaveRunner run(Class<?> suiteClass) {
        this.declare(suiteClass).forEach(suite -> suite.playbackSpecifications(this.report));
        return this;
    }

    private List<Specifier> declare(Class<?> specification) {
        NumberGenerators.push(this.generator);
        int mark = Specifiers.startSpecifying(specification);
        try {
            specification.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Unable to create specification from: " + specification.getSimpleName();
            throw new SpecificationDeclarationException(message, e);
        }
        NumberGenerators.pop();
        return Specifiers.finishSpecifying(mark);
    }

    public BehaveRunner printReport() {
        ConsoleFormatter formatter = new ConsoleFormatter();
        formatter.format(this.report);
        return this;
    }

    public Report getReport() {
        return this.report;
    }
}

