/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.expectations;

import com.insightfullogic.lambdabehave.expectations.BoundExpectation;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class ArrayExpectation<T>
extends BoundExpectation<T[]> {
    ArrayExpectation(T[] array, boolean positive) {
        super(array, positive);
    }

    public ArrayExpectation<T> isArrayWithSize(int size) {
        return this.matches((Matcher<T[]>)Matchers.arrayWithSize((int)size));
    }

    public ArrayExpectation<T> isArrayWithSize(Matcher<? super Integer> matcher) {
        return this.matches((Matcher<T[]>)Matchers.arrayWithSize(matcher));
    }

    public ArrayExpectation<T> isArray(Matcher<? super T> ... elementMatchers) {
        return this.matches((Matcher<T[]>)Matchers.array(elementMatchers));
    }

    public ArrayExpectation<T> isArrayContaining(T ... items) {
        return this.matches((Matcher<T[]>)Matchers.arrayContaining((Object[])items));
    }

    public ArrayExpectation<T> isArrayContaining(Matcher<? super T> ... elements) {
        return this.matches((Matcher<T[]>)Matchers.arrayContaining(elements));
    }

    public ArrayExpectation<T> isArrayContaining(List<Matcher<? super T>> elements) {
        return this.matches((Matcher<T[]>)Matchers.arrayContaining(elements));
    }

    public ArrayExpectation<T> isArrayContainingInAnyOrder(T ... items) {
        return this.matches((Matcher<T[]>)Matchers.arrayContainingInAnyOrder((Object[])items));
    }

    public ArrayExpectation<T> isArrayContainingInAnyOrder(Matcher<? super T> ... elements) {
        return this.matches((Matcher<T[]>)Matchers.arrayContainingInAnyOrder(elements));
    }

    public ArrayExpectation<T> isArrayContainingInAnyOrder(Collection<Matcher<? super T>> elements) {
        return this.matches((Matcher<T[]>)Matchers.arrayContainingInAnyOrder(elements));
    }

    public ArrayExpectation<T> isEmptyArray() {
        return this.matches((Matcher<T[]>)Matchers.emptyArray());
    }

    public ArrayExpectation<T> isArrayWithItem(T item) {
        return this.matches((Matcher<T[]>)Matchers.hasItemInArray(item));
    }

    public ArrayExpectation<T> isArrayWithItem(Matcher<? super T> itemMatcher) {
        return this.matches((Matcher<T[]>)Matchers.hasItemInArray(itemMatcher));
    }

    @Override
    public ArrayExpectation<T> isEqualTo(T[] expected) {
        super.isEqualTo(expected);
        return this;
    }

    @Override
    public ArrayExpectation<T> hasToString(Matcher<? super String> str) {
        super.hasToString(str);
        return this;
    }

    @Override
    public ArrayExpectation<T> hasToString(String arg) {
        super.hasToString(arg);
        return this;
    }

    @Override
    public ArrayExpectation<T> instanceOf(Class<?> arg) {
        super.instanceOf(arg);
        return this;
    }

    @Override
    public ArrayExpectation<T> isNotNull() {
        super.isNotNull();
        return this;
    }

    @Override
    public ArrayExpectation<T> toBeNull() {
        super.toBeNull();
        return this;
    }

    @Override
    public ArrayExpectation<T> sameInstance(T[] target) {
        super.sameInstance(target);
        return this;
    }

    @Override
    public ArrayExpectation<T> any() {
        super.any();
        return this;
    }

    @Override
    public ArrayExpectation<T> hasProperty(String propertyName, Matcher<?> propertyValue) {
        super.hasProperty(propertyName, propertyValue);
        return this;
    }

    @Override
    public ArrayExpectation<T> is(T[] value) {
        super.is(value);
        return this;
    }

    @Override
    public ArrayExpectation<T> is(Matcher<? super T[]> matcher) {
        super.is(matcher);
        return this;
    }

    @Override
    public ArrayExpectation<T> isIn(Collection<T[]> values) {
        super.isIn(values);
        return this;
    }

    public ArrayExpectation<T> isIn(T[] ... values) {
        super.isIn((T[])values);
        return this;
    }

    @Override
    public ArrayExpectation<T> never() {
        super.never();
        return this;
    }

    private ArrayExpectation<T> matches(Matcher<? super T[]> matcher) {
        Assert.assertThat((Object)this.objectUnderTest, matcher);
        return this;
    }
}

