/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl;

import com.insightfullogic.lambdabehave.expectations.Expect;
import com.insightfullogic.lambdabehave.impl.Blocks;
import com.insightfullogic.lambdabehave.impl.CompleteBehaviour;
import com.insightfullogic.lambdabehave.impl.reports.SpecificationReport;
import com.insightfullogic.lambdabehave.specifications.Specification;
import java.util.Optional;

final class CompleteSpecification
implements CompleteBehaviour {
    private final Blocks prefixes;
    private final Specification specification;
    private final String description;
    private final Blocks postfixes;
    private final String suiteName;

    public CompleteSpecification(Specification specification, String description, String suiteName) {
        this(new Blocks(suiteName), specification, description, new Blocks(suiteName), suiteName);
    }

    public CompleteSpecification(Blocks prefixes, Specification specification, String description, Blocks postfixes, String suiteName) {
        this.prefixes = prefixes;
        this.specification = specification;
        this.description = description;
        this.postfixes = postfixes;
        this.suiteName = suiteName;
    }

    @Override
    public SpecificationReport playbackBehaviour() {
        SpecificationReport report = this.prefixes.runAll(this.getDescription()).orElseGet(this::checkBehaviour);
        Optional<SpecificationReport> suffixReport = this.postfixes.runAll(this.getDescription());
        if (report.isSuccess() && suffixReport.isPresent()) {
            return suffixReport.get();
        }
        return report;
    }

    private SpecificationReport checkBehaviour() {
        try {
            Expect expect = new Expect();
            this.specification.specifyBehaviour(expect);
            return SpecificationReport.success(this.description);
        }
        catch (AssertionError cause) {
            return SpecificationReport.failure(this.description, cause);
        }
        catch (Throwable cause) {
            return SpecificationReport.error(this.description, cause);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSuiteName() {
        return this.suiteName;
    }
}

