/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl;

import com.insightfullogic.lambdabehave.Block;
import com.insightfullogic.lambdabehave.Description;
import com.insightfullogic.lambdabehave.generators.GeneratedDescription;
import com.insightfullogic.lambdabehave.generators.SourceGenerator;
import com.insightfullogic.lambdabehave.impl.Blocks;
import com.insightfullogic.lambdabehave.impl.generators.GeneratedDescriptionSpecBuilder;
import com.insightfullogic.lambdabehave.impl.specifications.PairSpecRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.TripletSpecRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.ValueSpecRecorder;
import com.insightfullogic.lambdabehave.specifications.Column;
import com.insightfullogic.lambdabehave.specifications.ColumnDataSpecification;
import com.insightfullogic.lambdabehave.specifications.Specification;
import com.insightfullogic.lambdabehave.specifications.ThreeColumnDataSpecification;
import com.insightfullogic.lambdabehave.specifications.ThreeColumns;
import com.insightfullogic.lambdabehave.specifications.TwoColumnDataSpecification;
import com.insightfullogic.lambdabehave.specifications.TwoColumns;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DescriptionRecorder
implements Description {
    private final SourceGenerator sourceGenerator;
    private final String description;
    private final Blocks prefixes;
    private final Blocks postfixes;
    private Specification specification;
    private ColumnDataSpecification<?> columnDataSpecification;
    private TwoColumnDataSpecification<?, ?> twoColumnDataSpecification;
    private ThreeColumnDataSpecification<?, ?, ?> threeColumnDataSpecification;

    public DescriptionRecorder(SourceGenerator sourceGenerator, String suiteName, String description) {
        this.sourceGenerator = sourceGenerator;
        this.description = description;
        this.prefixes = new Blocks(suiteName);
        this.postfixes = new Blocks(suiteName);
    }

    @Override
    public void should(String description, Specification specification) {
        if (description.equals(this.description)) {
            this.specification = specification;
        }
    }

    @Override
    public <T> Column<T> uses(T value) {
        return new ValueSpecRecorder(this);
    }

    @Override
    public <T> Column<T> uses(List<T> values) {
        return new ValueSpecRecorder(this);
    }

    @Override
    public <T> Column<T> uses(Stream<T> values) {
        return this.uses(values.collect(Collectors.toList()));
    }

    @Override
    public <F, S> TwoColumns<F, S> uses(F first, S second) {
        return new PairSpecRecorder(this);
    }

    @Override
    public <F, S> TwoColumns<F, S> uses(List<F> first, List<S> second) {
        return new PairSpecRecorder(this);
    }

    @Override
    public <F, S> TwoColumns<F, S> uses(Stream<F> first, Stream<S> second) {
        return new PairSpecRecorder(this);
    }

    @Override
    public <F, S, T> ThreeColumns<F, S, T> uses(F first, S second, T third) {
        return new TripletSpecRecorder(this);
    }

    @Override
    public <F, S, T> ThreeColumns<F, S, T> uses(List<F> first, List<S> second, List<T> third) {
        return new TripletSpecRecorder(this);
    }

    @Override
    public <F, S, T> ThreeColumns<F, S, T> uses(Stream<F> first, Stream<S> second, Stream<T> third) {
        return new TripletSpecRecorder(this);
    }

    @Override
    public GeneratedDescription requires(int exampleCount) {
        return new GeneratedDescriptionSpecBuilder(this.sourceGenerator, exampleCount, this);
    }

    @Override
    public long getSeed() {
        return this.sourceGenerator.getSeed();
    }

    @Override
    public void isSetupWith(Block block) {
        this.prefixes.add(block);
    }

    @Override
    public void isConcludedWith(Block block) {
        this.postfixes.add(block);
    }

    public Blocks getPrefixes() {
        return this.prefixes;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public ColumnDataSpecification<?> getColumnDataSpecification() {
        return this.columnDataSpecification;
    }

    public TwoColumnDataSpecification<?, ?> getTwoColumnDataSpecification() {
        return this.twoColumnDataSpecification;
    }

    public ThreeColumnDataSpecification<?, ?, ?> getThreeColumnDataSpecification() {
        return this.threeColumnDataSpecification;
    }

    public Blocks getPostfixes() {
        return this.postfixes;
    }

    public void toShow(String description, ColumnDataSpecification<?> specification) {
        if (description.equals(this.description)) {
            this.columnDataSpecification = specification;
        }
    }

    public void toShow(String description, TwoColumnDataSpecification<?, ?> specification) {
        if (description.equals(this.description)) {
            this.twoColumnDataSpecification = specification;
        }
    }

    public void toShow(String description, ThreeColumnDataSpecification<?, ?, ?> specification) {
        if (description.equals(this.description)) {
            this.threeColumnDataSpecification = specification;
        }
    }

    @Override
    public void initializesWith(Block block) {
    }

    @Override
    public void completesWith(Block block) {
    }
}

