/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl;

import com.insightfullogic.lambdabehave.Block;
import com.insightfullogic.lambdabehave.Description;
import com.insightfullogic.lambdabehave.SpecificationDeclarationException;
import com.insightfullogic.lambdabehave.generators.GeneratedDescription;
import com.insightfullogic.lambdabehave.generators.SourceGenerator;
import com.insightfullogic.lambdabehave.impl.Blocks;
import com.insightfullogic.lambdabehave.impl.CompleteBehaviour;
import com.insightfullogic.lambdabehave.impl.CompleteSpecification;
import com.insightfullogic.lambdabehave.impl.DescriptionRecorder;
import com.insightfullogic.lambdabehave.impl.generators.GeneratedDescriptionBuilder;
import com.insightfullogic.lambdabehave.impl.reports.Report;
import com.insightfullogic.lambdabehave.impl.reports.Specifiers;
import com.insightfullogic.lambdabehave.impl.specifications.PairRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.PairRow;
import com.insightfullogic.lambdabehave.impl.specifications.TitledTable;
import com.insightfullogic.lambdabehave.impl.specifications.TripletRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.TripletRow;
import com.insightfullogic.lambdabehave.impl.specifications.ValueRecorder;
import com.insightfullogic.lambdabehave.specifications.Column;
import com.insightfullogic.lambdabehave.specifications.ColumnDataSpecification;
import com.insightfullogic.lambdabehave.specifications.Specification;
import com.insightfullogic.lambdabehave.specifications.ThreeColumnDataSpecification;
import com.insightfullogic.lambdabehave.specifications.ThreeColumns;
import com.insightfullogic.lambdabehave.specifications.TwoColumnDataSpecification;
import com.insightfullogic.lambdabehave.specifications.TwoColumns;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public class Specifier
implements Description {
    private final String suiteName;
    private final Blocks initializers;
    private final List<CompleteBehaviour> behaviours;
    private final Blocks completers;
    private final SourceGenerator sourceGenerator;

    public Specifier(String suite, SourceGenerator sourceGenerator) {
        this.suiteName = suite;
        this.sourceGenerator = sourceGenerator;
        this.initializers = new Blocks(this.suiteName);
        this.behaviours = new ArrayList<CompleteBehaviour>();
        this.completers = new Blocks(this.suiteName);
    }

    public <T> void recordDataDrivenSpecification(String descriptionFormat, List<T> values) {
        DescriptionRecorder recorder = Specifiers.recordCode(this.sourceGenerator, this.suiteName, descriptionFormat);
        ColumnDataSpecification<?> specification = recorder.getColumnDataSpecification();
        Objects.requireNonNull(specification);
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            String description = this.makeDescription(descriptionFormat, i, "(%s)", value);
            this.newBehaviour(description, recorder, expect -> specification.specifyBehaviour(expect, value));
        }
    }

    public <F, S> void recordDataDrivenSpecification2(String descriptionFormat, List<PairRow<F, S>> values) {
        DescriptionRecorder recorder = Specifiers.recordCode(this.sourceGenerator, this.suiteName, descriptionFormat);
        TwoColumnDataSpecification<?, ?> specification = recorder.getTwoColumnDataSpecification();
        Objects.requireNonNull(specification);
        for (int i = 0; i < values.size(); ++i) {
            PairRow<F, S> pairRow = values.get(i);
            String description = this.makeDescription(descriptionFormat, i, "(%s, %s)", pairRow.first, pairRow.second);
            this.newBehaviour(description, recorder, expect -> specification.specifyBehaviour(expect, pairRow.first, pairRow.second));
        }
    }

    public <F, S, T> void recordDataDrivenSpecification3(String descriptionFormat, List<TripletRow<F, S, T>> values) {
        DescriptionRecorder recorder = Specifiers.recordCode(this.sourceGenerator, this.suiteName, descriptionFormat);
        ThreeColumnDataSpecification<?, ?, ?> specification = recorder.getThreeColumnDataSpecification();
        Objects.requireNonNull(specification);
        for (int i = 0; i < values.size(); ++i) {
            TripletRow<F, S, T> tripletRow = values.get(i);
            String description = this.makeDescription(descriptionFormat, i, "(%s, %s, %s)", tripletRow.first, tripletRow.second, tripletRow.third);
            this.newBehaviour(description, recorder, expect -> specification.specifyBehaviour(expect, tripletRow.first, tripletRow.second, tripletRow.third));
        }
    }

    private <F, S> String makeDescription(String descriptionFormat, int i, String format, Object ... args) {
        String description = String.format(descriptionFormat, args);
        if (description.equals(descriptionFormat)) {
            description = description + String.format(format, args);
        }
        description = String.valueOf(i) + ": " + description + " (seed: " + this.getSeed() + ")";
        return description;
    }

    @Override
    public void should(String description, Specification unused) {
        Objects.nonNull(description);
        if (this.behaviours.removeIf(behaviour -> behaviour.hasDescription(description))) {
            this.behaviours.add(new CompleteSpecification(expect -> {
                throw new SpecificationDeclarationException("You can't declare multiple specifications with the same name. Name: '" + description + "'");
            }, description, this.suiteName));
        } else {
            DescriptionRecorder recorder = Specifiers.recordCode(this.sourceGenerator, this.suiteName, description);
            Specification specification = recorder.getSpecification();
            Objects.requireNonNull(specification);
            this.newBehaviour(description, recorder, specification);
        }
    }

    private void newBehaviour(String description, DescriptionRecorder recorder, Specification specification) {
        this.behaviours.add(new CompleteSpecification(recorder.getPrefixes(), specification, description, recorder.getPostfixes(), this.suiteName));
    }

    @Override
    public <T> Column<T> uses(T value) {
        return new ValueRecorder<T>(value, this);
    }

    @Override
    public <T> Column<T> uses(List<T> values) {
        return new ValueRecorder<T>(new ArrayList<T>(values), this);
    }

    @Override
    public <T> Column<T> uses(Stream<T> values) {
        return this.uses(values.collect(Collectors.toList()));
    }

    @Override
    public <F, S> TwoColumns<F, S> uses(F first, S second) {
        return new PairRecorder<F, S>(first, second, this);
    }

    @Override
    public <F, S> TwoColumns<F, S> uses(List<F> first, List<S> second) {
        return new PairRecorder<F, S>(new ArrayList<F>(first), new ArrayList<S>(second), this);
    }

    @Override
    public <F, S> TwoColumns<F, S> uses(Stream<F> first, Stream<S> second) {
        return new PairRecorder(first.collect(Collectors.toList()), second.collect(Collectors.toList()), this);
    }

    @Override
    public <F, S, T> ThreeColumns<F, S, T> uses(F first, S second, T third) {
        return new TripletRecorder<F, S, T>(first, second, third, this);
    }

    @Override
    public <F, S, T> ThreeColumns<F, S, T> uses(List<F> first, List<S> second, List<T> third) {
        return new TripletRecorder<F, S, T>(new ArrayList<F>(first), new ArrayList<S>(second), new ArrayList<T>(third), this);
    }

    @Override
    public <F, S, T> ThreeColumns<F, S, T> uses(Stream<F> first, Stream<S> second, Stream<T> third) {
        return new TripletRecorder(first.collect(Collectors.toList()), second.collect(Collectors.toList()), third.collect(Collectors.toList()), this);
    }

    @Override
    public GeneratedDescription requires(int exampleCount) {
        return new GeneratedDescriptionBuilder(this.sourceGenerator, exampleCount, this);
    }

    public <T, F, S> TitledTable<T, F, S> usesTable(Class<T> clazz, Function<T, F> first, Function<T, S> second) {
        ArrayList<Method> m = new ArrayList<Method>();
        Object mock = Enhancer.create(clazz, (Callback)((MethodInterceptor)(o, method, objects, methodProxy) -> {
            m.add(method);
            return null;
        }));
        first.apply(mock);
        second.apply(mock);
        return new TitledTable(m, this, clazz);
    }

    @Override
    public void initializesWith(Block block) {
        this.initializers.add(block);
    }

    @Override
    public void completesWith(Block block) {
        this.completers.add(block);
    }

    public void playbackSpecifications(Report report) {
        report.onSuiteName(this.suiteName);
        this.completeBehaviours().forEach(behaviour -> report.recordSpecification(this.suiteName, behaviour.playbackBehaviour()));
    }

    public Stream<CompleteBehaviour> completeBehaviours() {
        if (this.behaviours.isEmpty()) {
            return Stream.empty();
        }
        return Stream.concat(Stream.concat(this.initializers.completeFixtures("initializer"), this.behaviours.stream()), this.completers.completeFixtures("completer"));
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    @Override
    public long getSeed() {
        return this.sourceGenerator.getSeed();
    }

    @Override
    public void isSetupWith(Block block) {
    }

    @Override
    public void isConcludedWith(Block block) {
    }
}

