/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.generators;

import com.insightfullogic.lambdabehave.generators.GeneratedDescription;
import com.insightfullogic.lambdabehave.generators.Generator;
import com.insightfullogic.lambdabehave.generators.SourceGenerator;
import com.insightfullogic.lambdabehave.impl.Specifier;
import com.insightfullogic.lambdabehave.impl.specifications.PairRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.TripletRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.ValueRecorder;
import com.insightfullogic.lambdabehave.specifications.Column;
import com.insightfullogic.lambdabehave.specifications.ThreeColumns;
import com.insightfullogic.lambdabehave.specifications.TwoColumns;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GeneratedDescriptionBuilder
implements GeneratedDescription {
    private final int numberOfInstances;
    private final Specifier specifier;
    private SourceGenerator sourceGenerator;

    public GeneratedDescriptionBuilder(SourceGenerator sourceGenerator, int numberOfInstances, Specifier specifier) {
        this.sourceGenerator = sourceGenerator;
        this.numberOfInstances = numberOfInstances;
        this.specifier = specifier;
    }

    @Override
    public GeneratedDescription withSource(SourceGenerator sourceGenerator) {
        this.sourceGenerator = sourceGenerator;
        return this;
    }

    @Override
    public <T> Column<T> example(Generator<T> generator) {
        return new ValueRecorder<T>(this.generateValues(generator), this.specifier);
    }

    @Override
    public <F, S> TwoColumns<F, S> example(Generator<F> firstGenerator, Generator<S> secondGenerator) {
        return new PairRecorder<F, S>(this.generateValues(firstGenerator), this.generateValues(secondGenerator), this.specifier);
    }

    @Override
    public <F, S, T> ThreeColumns<F, S, T> example(Generator<F> firstGenerator, Generator<S> secondGenerator, Generator<T> thirdGenerator) {
        return new TripletRecorder<F, S, T>(this.generateValues(firstGenerator), this.generateValues(secondGenerator), this.generateValues(thirdGenerator), this.specifier);
    }

    private <T> List<T> generateValues(Generator<T> generator) {
        return Stream.generate(() -> generator.generate(this.sourceGenerator)).limit(this.numberOfInstances).collect(Collectors.toList());
    }
}

