/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.generators;

import com.insightfullogic.lambdabehave.generators.GeneratedDescription;
import com.insightfullogic.lambdabehave.generators.Generator;
import com.insightfullogic.lambdabehave.generators.SourceGenerator;
import com.insightfullogic.lambdabehave.impl.DescriptionRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.PairSpecRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.TripletSpecRecorder;
import com.insightfullogic.lambdabehave.impl.specifications.ValueSpecRecorder;
import com.insightfullogic.lambdabehave.specifications.Column;
import com.insightfullogic.lambdabehave.specifications.ThreeColumns;
import com.insightfullogic.lambdabehave.specifications.TwoColumns;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GeneratedDescriptionSpecBuilder
implements GeneratedDescription {
    private final int numberOfInstances;
    private final DescriptionRecorder description;
    private SourceGenerator sourceGenerator;

    public GeneratedDescriptionSpecBuilder(SourceGenerator sourceGenerator, int numberOfInstances, DescriptionRecorder description) {
        this.sourceGenerator = sourceGenerator;
        this.numberOfInstances = numberOfInstances;
        this.description = description;
    }

    @Override
    public GeneratedDescription withSource(SourceGenerator sourceGenerator) {
        this.sourceGenerator = sourceGenerator;
        return this;
    }

    @Override
    public <T> Column<T> example(Generator<T> generator) {
        return new ValueSpecRecorder(this.description);
    }

    @Override
    public <F, S> TwoColumns<F, S> example(Generator<F> firstGenerator, Generator<S> secondGenerator) {
        return new PairSpecRecorder(this.description);
    }

    @Override
    public <F, S, T> ThreeColumns<F, S, T> example(Generator<F> firstGenerator, Generator<S> secondGenerator, Generator<T> thirdGenerator) {
        return new TripletSpecRecorder(this.description);
    }

    private <T> List<T> generateValues(Generator<T> generator) {
        return Stream.generate(() -> generator.generate(this.sourceGenerator)).limit(this.numberOfInstances).collect(Collectors.toList());
    }
}

