/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.generators;

import com.insightfullogic.lambdabehave.generators.Generator;
import com.insightfullogic.lambdabehave.generators.SourceGenerator;
import com.insightfullogic.lambdabehave.impl.generators.Generators;
import java.util.stream.IntStream;

public class StringGenerator
implements Generator<String> {
    private static final int MAX_STRING_LENGTH = 10;
    private final int minValue;
    private final int range;

    public StringGenerator(int minCharacter, int maxCharacter) {
        this.minValue = minCharacter;
        this.range = maxCharacter - minCharacter;
    }

    @Override
    public String generate(SourceGenerator source) {
        int length = source.generateInt(10);
        int[] characters = new int[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = this.nextCodePoint(source);
        }
        return new String(characters, 0, length);
    }

    private int nextCodePoint(SourceGenerator source) {
        return IntStream.range(0, 100000).map(i -> this.minValue + source.generateInt(this.range)).filter(Character::isDefined).findFirst().orElseThrow(Generators::exceededMaxTries);
    }
}

