/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.reports;

import com.insightfullogic.lambdabehave.impl.reports.SpecificationReport;
import com.insightfullogic.lambdabehave.impl.reports.SuiteReport;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public final class Report {
    private final List<SuiteReport> suites = new ArrayList<SuiteReport>();
    private SuiteReport currentSuite;

    private void newSuite(String name) {
        this.currentSuite = new SuiteReport(name);
        this.suites.add(this.currentSuite);
    }

    public void recordSpecification(String suiteName, SpecificationReport report) {
        this.onSuiteName(suiteName);
        this.currentSuite.with(report);
    }

    public void onSuiteName(String suiteName) {
        if (this.noSuite() || this.seenNewSuite(suiteName)) {
            this.newSuite(suiteName);
        }
    }

    private boolean seenNewSuite(String suite) {
        return !this.currentSuite.getName().equals(suite);
    }

    private boolean noSuite() {
        return this.currentSuite == null;
    }

    public Stream<SuiteReport> suites() {
        return this.suites.stream();
    }

    public List<SuiteReport> getSuites() {
        return this.suites;
    }

    public SuiteReport getSuite() {
        int size = this.suites.size();
        if (size != 1) {
            throw new IllegalStateException("Assumed there was only suite, but there were: " + size);
        }
        return this.suites.get(0);
    }
}

