/*
 * Decompiled with CFR 0.152.
 */
package com.insightfullogic.lambdabehave.impl.reports;

import com.insightfullogic.lambdabehave.SpecificationDeclarationException;
import com.insightfullogic.lambdabehave.Suite;
import com.insightfullogic.lambdabehave.generators.SourceGenerator;
import com.insightfullogic.lambdabehave.impl.DescriptionRecorder;
import com.insightfullogic.lambdabehave.impl.Specifier;
import com.insightfullogic.lambdabehave.impl.generators.NumberGenerators;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Specifiers {
    private static final Deque<Specifier> specifiers = new ArrayDeque<Specifier>();
    private static DescriptionRecorder descriptionRecorder;
    private static Class<?> classBeingSpecified;

    public static int startSpecifying(Class<?> classBeingSpecified) {
        Specifiers.classBeingSpecified = classBeingSpecified;
        return specifiers.size();
    }

    public static void push(Specifier specifier) {
        specifiers.push(specifier);
    }

    public static List<Specifier> finishSpecifying(int mark) {
        classBeingSpecified = null;
        return IntStream.range(mark, specifiers.size()).mapToObj(i -> specifiers.pop()).collect(Collectors.toList());
    }

    public static void describe(String name, Suite behaviours) {
        if (Specifiers.isCurrentlyPlaying()) {
            behaviours.specifySuite(descriptionRecorder);
            return;
        }
        SourceGenerator generator = NumberGenerators.peek();
        Specifier specifier = new Specifier(name, generator);
        behaviours.specifySuite(specifier);
        Specifiers.push(specifier);
    }

    private static boolean isCurrentlyPlaying() {
        return descriptionRecorder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptionRecorder recordCode(SourceGenerator sourceGenerator, String suiteName, String description) {
        descriptionRecorder = new DescriptionRecorder(sourceGenerator, suiteName, description);
        try {
            classBeingSpecified.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Unable to create specification from: " + suiteName;
            throw new SpecificationDeclarationException(message, e);
        }
        try {
            DescriptionRecorder descriptionRecorder = Specifiers.descriptionRecorder;
            return descriptionRecorder;
        }
        finally {
            descriptionRecorder = null;
        }
    }
}

