/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apmgrpclogger;

import com.instabug.apm.di.InterceptorsServiceLocator;
import com.instabug.apm.networkinterception.APMNetworkLogWrapper;
import com.instabug.library.apmgrpclogger.ErrorCodeTrigger;
import com.instabug.library.apmgrpclogger.ExtensionsKt;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.util.InstabugSDKLogger;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 **\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001*B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\"\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015J\u001c\u0010\u001f\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010 \u001a\u00020\u000eH\u0002J\u001a\u0010!\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\"\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u0015J\u0010\u0010$\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u0015J\u0010\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010'J\b\u0010(\u001a\u00020\u000eH\u0002J\b\u0010)\u001a\u00020\u000eH\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/instabug/library/apmgrpclogger/ApmGrpcNetworkLogger;", "ReqT", "RespT", "", "networkLogWrapper", "Lcom/instabug/apm/networkinterception/APMNetworkLogWrapper;", "method", "Lio/grpc/MethodDescriptor;", "(Lcom/instabug/apm/networkinterception/APMNetworkLogWrapper;Lio/grpc/MethodDescriptor;)V", "responseHeadersReceived", "", "startTimeMillis", "", "addRequest", "", "request", "(Ljava/lang/Object;)V", "addResponse", "response", "didNotReceiveFromServer", "trailers", "Lio/grpc/Metadata;", "didRequestSucceed", "status", "Lio/grpc/Status;", "getNewHeadersWithExternalTraceId", "originalRequestHeaders", "key", "", "value", "injectExternalTraceIdIfPossible", "isClientSideError", "markRequestEndTimeHereIfPossible", "onClose", "setRequestHeaders", "headers", "setResponseHeaders", "start", "channel", "Lio/grpc/Channel;", "updateMissingRequestContentType", "updateMissingResponseContentType", "Companion", "instabug-apm-grpc-interceptor_defaultUiRelease"})
public final class ApmGrpcNetworkLogger<ReqT, RespT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final APMNetworkLogWrapper networkLogWrapper;
    @Nullable
    private final MethodDescriptor<ReqT, RespT> method;
    private boolean responseHeadersReceived;
    private long startTimeMillis;
    @NotNull
    private static final String TAG = "ApmGrpcNetworkLogger";
    @NotNull
    private static final String CONTENT_TYPE_FALLBACK = "application/grpc";

    public ApmGrpcNetworkLogger(@NotNull APMNetworkLogWrapper networkLogWrapper, @Nullable MethodDescriptor<ReqT, RespT> method) {
        Intrinsics.checkNotNullParameter((Object)networkLogWrapper, (String)"networkLogWrapper");
        this.networkLogWrapper = networkLogWrapper;
        this.method = method;
        this.networkLogWrapper.setMethod(null);
    }

    public final void start(@Nullable Channel channel) {
        if (this.startTimeMillis == 0L) {
            try {
                this.startTimeMillis = System.currentTimeMillis();
                this.networkLogWrapper.setStartTime(Long.valueOf(this.startTimeMillis * (long)1000));
                Channel channel2 = channel;
                MethodDescriptor<ReqT, RespT> methodDescriptor = this.method;
                this.networkLogWrapper.setUrl("grpc://" + (channel2 != null ? channel2.authority() : null) + '/' + (methodDescriptor != null ? methodDescriptor.getServiceName() : null));
                MethodDescriptor<ReqT, RespT> methodDescriptor2 = this.method;
                this.networkLogWrapper.setGrpcMethodName(methodDescriptor2 != null ? methodDescriptor2.getBareMethodName() : null);
            }
            catch (Exception exc) {
                InstabugSDKLogger.e((String)TAG, (String)"Failed to generate URL or method name", (Throwable)exc);
            }
        }
    }

    public final void setRequestHeaders(@Nullable io.grpc.Metadata headers) {
        try {
            String string = this.networkLogWrapper.getRequestContentType();
            if (string == null) {
                io.grpc.Metadata metadata = headers;
                string = metadata != null ? ExtensionsKt.getContentType(metadata) : null;
            }
            this.networkLogWrapper.setRequestContentType(string);
        }
        catch (Exception exc) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to fetch request header content-type", (Throwable)exc);
        }
    }

    public final void setResponseHeaders(@Nullable io.grpc.Metadata headers) {
        this.responseHeadersReceived = true;
        try {
            String string = this.networkLogWrapper.getResponseContentType();
            if (string == null) {
                io.grpc.Metadata metadata = headers;
                string = metadata != null ? ExtensionsKt.getContentType(metadata) : null;
            }
            this.networkLogWrapper.setResponseContentType(string);
        }
        catch (Exception exc) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to fetch response header content-type", (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRequest(ReqT request) {
        try {
            long l;
            InputStream inputStream;
            MethodDescriptor.Marshaller marshaller;
            APMNetworkLogWrapper aPMNetworkLogWrapper;
            APMNetworkLogWrapper aPMNetworkLogWrapper2 = aPMNetworkLogWrapper = this.networkLogWrapper;
            long l2 = aPMNetworkLogWrapper.getRequestBodySize();
            MethodDescriptor<ReqT, RespT> methodDescriptor = this.method;
            if (methodDescriptor != null && (marshaller = methodDescriptor.getRequestMarshaller()) != null && (inputStream = marshaller.stream(request)) != null) {
                long l3;
                Closeable closeable = inputStream;
                long l4 = l2;
                APMNetworkLogWrapper aPMNetworkLogWrapper3 = aPMNetworkLogWrapper2;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    l3 = ByteStreamsKt.readBytes((InputStream)it).length;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                long l5 = l3;
                aPMNetworkLogWrapper2 = aPMNetworkLogWrapper3;
                l2 = l4;
                l = l5;
            } else {
                l = 0L;
            }
            aPMNetworkLogWrapper2.setRequestBodySize(l2 + l);
        }
        catch (OutOfMemoryError outOfMemory) {
            InstabugCore.reportError((Throwable)outOfMemory, (String)"Not enough memory to calculate request body size");
            InstabugSDKLogger.e((String)TAG, (String)"Not enough memory to calculate request body size", (Throwable)outOfMemory);
        }
        catch (Exception e) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to calculate request body size", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResponse(RespT response) {
        try {
            long l;
            InputStream inputStream;
            MethodDescriptor.Marshaller marshaller;
            APMNetworkLogWrapper aPMNetworkLogWrapper;
            APMNetworkLogWrapper aPMNetworkLogWrapper2 = aPMNetworkLogWrapper = this.networkLogWrapper;
            long l2 = aPMNetworkLogWrapper.getResponseBodySize();
            MethodDescriptor<ReqT, RespT> methodDescriptor = this.method;
            if (methodDescriptor != null && (marshaller = methodDescriptor.getResponseMarshaller()) != null && (inputStream = marshaller.stream(response)) != null) {
                long l3;
                Closeable closeable = inputStream;
                long l4 = l2;
                APMNetworkLogWrapper aPMNetworkLogWrapper3 = aPMNetworkLogWrapper2;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    l3 = ByteStreamsKt.readBytes((InputStream)it).length;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                long l5 = l3;
                aPMNetworkLogWrapper2 = aPMNetworkLogWrapper3;
                l2 = l4;
                l = l5;
            } else {
                l = 0L;
            }
            aPMNetworkLogWrapper2.setResponseBodySize(l2 + l);
        }
        catch (OutOfMemoryError outOfMemory) {
            InstabugCore.reportError((Throwable)outOfMemory, (String)"Not enough memory to calculate response body size");
            InstabugSDKLogger.e((String)TAG, (String)"Not enough memory to calculate response body size", (Throwable)outOfMemory);
        }
        catch (Exception e) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to calculate response body size", (Throwable)e);
        }
    }

    public final void onClose(@Nullable Status status, @Nullable io.grpc.Metadata trailers) {
        try {
            boolean requestFailed;
            this.markRequestEndTimeHereIfPossible();
            Status status2 = status;
            int statusCode = status2 != null && (status2 = status2.getCode()) != null ? status2.value() : -1;
            Status status3 = status;
            String statusName = status3 != null && (status3 = status3.getCode()) != null ? status3.name() : null;
            boolean bl = requestFailed = !this.didRequestSucceed(status);
            if (requestFailed && this.isClientSideError(status, trailers)) {
                APMNetworkLogWrapper $this$onClose_u24lambda_u2d2 = this.networkLogWrapper;
                boolean bl2 = false;
                $this$onClose_u24lambda_u2d2.setClientErrorCode(statusCode);
                $this$onClose_u24lambda_u2d2.setResponseCode(-1);
                $this$onClose_u24lambda_u2d2.setErrorMessage(statusName);
            } else {
                APMNetworkLogWrapper $this$onClose_u24lambda_u2d3 = this.networkLogWrapper;
                boolean bl3 = false;
                if (requestFailed) {
                    String string = $this$onClose_u24lambda_u2d3.getResponseContentType();
                    if (string == null) {
                        io.grpc.Metadata metadata = trailers;
                        string = metadata != null ? ExtensionsKt.getContentType(metadata) : null;
                    }
                    $this$onClose_u24lambda_u2d3.setResponseContentType(string);
                    $this$onClose_u24lambda_u2d3.setServerSideErrorMessage(statusName);
                }
                $this$onClose_u24lambda_u2d3.setResponseCode(statusCode);
                $this$onClose_u24lambda_u2d3.setClientErrorCode(-1);
                this.updateMissingResponseContentType();
            }
            this.updateMissingRequestContentType();
            this.networkLogWrapper.insert(null, InterceptorsServiceLocator.getGrpcSanitizer());
        }
        catch (OutOfMemoryError outOfMemory) {
            InstabugCore.reportError((Throwable)outOfMemory, (String)"Not enough memory to intercept request close");
            InstabugSDKLogger.e((String)TAG, (String)"Not enough memory to intercept request close", (Throwable)outOfMemory);
        }
        catch (Exception exc) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to intercept request close", (Throwable)exc);
        }
    }

    private final void updateMissingResponseContentType() {
        APMNetworkLogWrapper $this$updateMissingResponseContentType_u24lambda_u2d4 = this.networkLogWrapper;
        boolean bl = false;
        if ($this$updateMissingResponseContentType_u24lambda_u2d4.getResponseContentType() == null) {
            $this$updateMissingResponseContentType_u24lambda_u2d4.setResponseContentType(CONTENT_TYPE_FALLBACK);
        }
    }

    private final void updateMissingRequestContentType() {
        APMNetworkLogWrapper $this$updateMissingRequestContentType_u24lambda_u2d5 = this.networkLogWrapper;
        boolean bl = false;
        if ($this$updateMissingRequestContentType_u24lambda_u2d5.getRequestContentType() == null) {
            String string = $this$updateMissingRequestContentType_u24lambda_u2d5.getResponseContentType();
            if (string == null) {
                string = CONTENT_TYPE_FALLBACK;
            }
            $this$updateMissingRequestContentType_u24lambda_u2d5.setRequestContentType(string);
        }
    }

    private final void markRequestEndTimeHereIfPossible() {
        long endTimeMillis = System.currentTimeMillis();
        if (this.networkLogWrapper.getTotalDuration() == 0L) {
            long totalTimeMillis = endTimeMillis - this.startTimeMillis;
            this.networkLogWrapper.setTotalDuration(totalTimeMillis);
        }
    }

    private final boolean isClientSideError(Status status, io.grpc.Metadata trailers) {
        boolean bl;
        Status status2 = status;
        ErrorCodeTrigger errorCodeTrigger = status2 != null ? ExtensionsKt.getErrorSource(status2) : null;
        switch (errorCodeTrigger == null ? -1 : WhenMappings.$EnumSwitchMapping$0[errorCodeTrigger.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = this.didNotReceiveFromServer(trailers);
                break;
            }
            case -1: {
                bl = this.didNotReceiveFromServer(trailers);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean didRequestSucceed(Status status) {
        Status status2 = status;
        return status2 != null ? status2.isOk() : false;
    }

    private final boolean didNotReceiveFromServer(io.grpc.Metadata trailers) {
        return !this.responseHeadersReceived && ExtensionsKt.isEmpty(trailers);
    }

    @Nullable
    public final io.grpc.Metadata injectExternalTraceIdIfPossible(@Nullable io.grpc.Metadata originalRequestHeaders) {
        APMNetworkLogWrapper aPMNetworkLogWrapper;
        Object $this$injectExternalTraceIdIfPossible_u24lambda_u2d7;
        APMNetworkLogWrapper aPMNetworkLogWrapper2 = this.networkLogWrapper;
        try {
            Pair pair;
            block9: {
                block8: {
                    $this$injectExternalTraceIdIfPossible_u24lambda_u2d7 = aPMNetworkLogWrapper2;
                    boolean bl = false;
                    pair = $this$injectExternalTraceIdIfPossible_u24lambda_u2d7.getInjectableHeader();
                    if (pair == null) break block8;
                    Pair pair2 = pair;
                    boolean bl2 = false;
                    String key = (String)pair2.component1();
                    String value = (String)pair2.component2();
                    io.grpc.Metadata metadata = this.getNewHeadersWithExternalTraceId(originalRequestHeaders, key, value);
                    pair = metadata;
                    if (metadata != null) break block9;
                }
                pair = originalRequestHeaders;
            }
            $this$injectExternalTraceIdIfPossible_u24lambda_u2d7 = Result.constructor-impl((Object)pair);
        }
        catch (Throwable bl) {
            $this$injectExternalTraceIdIfPossible_u24lambda_u2d7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        aPMNetworkLogWrapper2 = $this$injectExternalTraceIdIfPossible_u24lambda_u2d7;
        Throwable throwable = Result.exceptionOrNull-impl((Object)aPMNetworkLogWrapper2);
        if (throwable != null) {
            Object it = $this$injectExternalTraceIdIfPossible_u24lambda_u2d7 = throwable;
            boolean bl = false;
            IBGDiagnostics.reportNonFatal((Throwable)it, (String)"InstabugAPMGrpcInterceptor Error occurred while injecting \"IBG-TRACE-ID\"");
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)aPMNetworkLogWrapper2);
        if (throwable2 == null) {
            aPMNetworkLogWrapper = aPMNetworkLogWrapper2;
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            aPMNetworkLogWrapper = originalRequestHeaders;
        }
        return (io.grpc.Metadata)aPMNetworkLogWrapper;
    }

    private final io.grpc.Metadata getNewHeadersWithExternalTraceId(io.grpc.Metadata originalRequestHeaders, String key, String value) {
        io.grpc.Metadata metadata;
        io.grpc.Metadata $this$getNewHeadersWithExternalTraceId_u24lambda_u2d10 = metadata = new io.grpc.Metadata();
        boolean bl = false;
        io.grpc.Metadata metadata2 = originalRequestHeaders;
        if (metadata2 != null) {
            io.grpc.Metadata p0 = metadata2;
            boolean bl2 = false;
            $this$getNewHeadersWithExternalTraceId_u24lambda_u2d10.merge(p0);
        }
        $this$getNewHeadersWithExternalTraceId_u24lambda_u2d10.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)io.grpc.Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        return metadata;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/instabug/library/apmgrpclogger/ApmGrpcNetworkLogger$Companion;", "", "()V", "CONTENT_TYPE_FALLBACK", "", "TAG", "instabug-apm-grpc-interceptor_defaultUiRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ErrorCodeTrigger.values().length];
            nArray[ErrorCodeTrigger.SERVER.ordinal()] = 1;
            nArray[ErrorCodeTrigger.CLIENT.ordinal()] = 2;
            nArray[ErrorCodeTrigger.BOTH.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

