/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.plugin.transform.asm;

import com.instana.android.plugin.transform.InstrumentationConfig;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005JG\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J?\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/instana/android/plugin/transform/asm/OkHttp3BuilderVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "classVisitor", "config", "Lcom/instana/android/plugin/transform/InstrumentationConfig;", "(Lorg/objectweb/asm/ClassVisitor;Lcom/instana/android/plugin/transform/InstrumentationConfig;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "visit", "", "version", "", "access", "className", "", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "name", "descriptor", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "Companion", "InitVisitor", "plugin"})
public final class OkHttp3BuilderVisitor
extends ClassVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassVisitor classVisitor;
    @NotNull
    private final InstrumentationConfig config;
    private final Logger logger;
    private static final int ASM_API_VERSION = 458752;

    public OkHttp3BuilderVisitor(@NotNull ClassVisitor classVisitor, @NotNull InstrumentationConfig config) {
        Intrinsics.checkNotNullParameter((Object)classVisitor, (String)"classVisitor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(458752, classVisitor);
        this.classVisitor = classVisitor;
        this.config = config;
        this.logger = Logging.getLogger(OkHttp3BuilderVisitor.class);
    }

    public void visit(int version, int access, @NotNull String className, @Nullable String signature, @NotNull String superName, @Nullable String[] interfaces) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)superName, (String)"superName");
        if (this.config.getLogVisits()) {
            this.logger.debug(Intrinsics.stringPlus((String)"Visiting Class ", (Object)className));
            this.logger.debug("  signature: " + signature + " superName: " + superName + " interfaces: " + (interfaces == null ? null : ArraysKt.joinToString$default((Object[])interfaces, null, null, null, (int)0, null, null, (int)63, null)));
        }
        super.visit(version, access, className, signature, superName, interfaces);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        MethodVisitor methodVisitor;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.config.getLogVisits()) {
            this.logger.debug("Visit method: " + name + " desc: " + descriptor + " signature: " + signature + " exceptions: " + (exceptions == null ? null : ArraysKt.joinToString$default((Object[])exceptions, null, null, null, (int)0, null, null, (int)63, null)));
        }
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (Intrinsics.areEqual((Object)name, (Object)"<init>") && Intrinsics.areEqual((Object)descriptor, (Object)"()V")) {
            Intrinsics.checkNotNullExpressionValue((Object)mv, (String)"mv");
            methodVisitor = (MethodVisitor)new InitVisitor(458752, mv, access, name, descriptor);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)mv, (String)"mv");
            methodVisitor = mv;
        }
        return methodVisitor;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/instana/android/plugin/transform/asm/OkHttp3BuilderVisitor$Companion;", "", "()V", "ASM_API_VERSION", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/instana/android/plugin/transform/asm/OkHttp3BuilderVisitor$InitVisitor;", "Lorg/objectweb/asm/commons/AdviceAdapter;", "api", "", "mv", "Lorg/objectweb/asm/MethodVisitor;", "access", "methodName", "", "methodDesc", "(Lcom/instana/android/plugin/transform/asm/OkHttp3BuilderVisitor;ILorg/objectweb/asm/MethodVisitor;ILjava/lang/String;Ljava/lang/String;)V", "visitInsn", "", "opcode", "plugin"})
    private final class InitVisitor
    extends AdviceAdapter {
        public InitVisitor(@NotNull int api, MethodVisitor mv, @NotNull int access, @NotNull String methodName, String methodDesc) {
            Intrinsics.checkNotNullParameter((Object)((Object)OkHttp3BuilderVisitor.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)methodDesc, (String)"methodDesc");
            super(api, mv, access, methodName, methodDesc);
        }

        public void visitInsn(int opcode) {
            boolean bl = 172 <= opcode ? opcode < 178 : false;
            if (bl || opcode == 191) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, "com/instana/android/instrumentation/okhttp3/OkHttp3Instrumentation", "clientBuilderInterceptor", "(Lokhttp3/OkHttpClient$Builder;)V", false);
                if (OkHttp3BuilderVisitor.this.config.getLogInstrumentation()) {
                    OkHttp3BuilderVisitor.this.logger.debug("Instrumented opcode:" + opcode + " for OkHttpClient.Builder <init>");
                    OkHttp3BuilderVisitor.this.logger.debug("  Instrumented a call to the okhttp3.OkHttpClient.Builder() initializer");
                }
            }
            super.visitInsn(opcode);
        }
    }
}

