/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.plugin.transform.asm;

import com.instana.android.plugin.transform.InstrumentationConfig;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005JI\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J?\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/instana/android/plugin/transform/asm/InstrumentationVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "classVisitor", "config", "Lcom/instana/android/plugin/transform/InstrumentationConfig;", "(Lorg/objectweb/asm/ClassVisitor;Lcom/instana/android/plugin/transform/InstrumentationConfig;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "visit", "", "version", "", "access", "className", "", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "name", "descriptor", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "Companion", "InstanaMethodVisitor", "plugin"})
public final class InstrumentationVisitor
extends ClassVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassVisitor classVisitor;
    @NotNull
    private final InstrumentationConfig config;
    private final Logger logger;
    private static final int ASM_API_VERSION = 458752;

    public InstrumentationVisitor(@NotNull ClassVisitor classVisitor, @NotNull InstrumentationConfig config) {
        Intrinsics.checkNotNullParameter((Object)classVisitor, (String)"classVisitor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(458752, classVisitor);
        this.classVisitor = classVisitor;
        this.config = config;
        this.logger = Logging.getLogger(InstrumentationVisitor.class);
    }

    public void visit(int version, int access, @NotNull String className, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (this.config.getLogVisits()) {
            this.logger.debug(Intrinsics.stringPlus((String)"Visiting Class ", (Object)className));
            this.logger.debug("  signature: " + signature + " superName: " + superName + " interfaces: " + (interfaces == null ? null : ArraysKt.joinToString$default((Object[])interfaces, null, null, null, (int)0, null, null, (int)63, null)));
        }
        super.visit(version, access, className, signature, superName, interfaces);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.config.getLogVisits()) {
            this.logger.debug("Visit method: " + name + " descriptor: " + descriptor + " signature: " + signature + " exceptions: " + (exceptions == null ? null : ArraysKt.joinToString$default((Object[])exceptions, null, null, null, (int)0, null, null, (int)63, null)));
        }
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        Intrinsics.checkNotNullExpressionValue((Object)mv, (String)"mv");
        return (MethodVisitor)new InstanaMethodVisitor(458752, mv, access, name, descriptor);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/instana/android/plugin/transform/asm/InstrumentationVisitor$Companion;", "", "()V", "ASM_API_VERSION", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/instana/android/plugin/transform/asm/InstrumentationVisitor$InstanaMethodVisitor;", "Lorg/objectweb/asm/commons/AdviceAdapter;", "api", "", "mv", "Lorg/objectweb/asm/MethodVisitor;", "access", "methodName", "", "methodDesc", "(Lcom/instana/android/plugin/transform/asm/InstrumentationVisitor;ILorg/objectweb/asm/MethodVisitor;ILjava/lang/String;Ljava/lang/String;)V", "visitMethodInsn", "", "opcode", "owner", "name", "descriptor", "isInterface", "", "plugin"})
    private final class InstanaMethodVisitor
    extends AdviceAdapter {
        public InstanaMethodVisitor(@NotNull int api, MethodVisitor mv, @NotNull int access, @NotNull String methodName, String methodDesc) {
            Intrinsics.checkNotNullParameter((Object)((Object)InstrumentationVisitor.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)methodDesc, (String)"methodDesc");
            super(api, mv, access, methodName, methodDesc);
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (InstrumentationVisitor.this.config.getLogVisits()) {
                InstrumentationVisitor.this.logger.debug("visitMethodInsn opcode: " + opcode + " owner: " + owner + " name: " + name + " descriptor: " + descriptor);
            }
            if (Intrinsics.areEqual((Object)owner, (Object)"java/net/URL") && Intrinsics.areEqual((Object)name, (Object)"openConnection") && Intrinsics.areEqual((Object)descriptor, (Object)"()Ljava/net/URLConnection;")) {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                this.dup();
                this.mv.visitMethodInsn(184, "com/instana/android/instrumentation/urlConnection/UrlConnectionInstrumentation", "openConnection", "(Ljava/net/URLConnection;)V", false);
                if (InstrumentationVisitor.this.config.getLogInstrumentation()) {
                    InstrumentationVisitor.this.logger.debug("Instrumented opcode: " + opcode + " owner: " + owner + " name: " + name + " desc: " + descriptor);
                    InstrumentationVisitor.this.logger.debug("  Instrumented a call to URL.openConnection");
                }
            } else if (Intrinsics.areEqual((Object)owner, (Object)"java/net/HttpURLConnection") && Intrinsics.areEqual((Object)name, (Object)"disconnect") && Intrinsics.areEqual((Object)descriptor, (Object)"()V")) {
                this.dup();
                this.mv.visitMethodInsn(184, "com/instana/android/instrumentation/urlConnection/UrlConnectionInstrumentation", "disconnect", "(Ljava/net/HttpURLConnection;)V", false);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                if (InstrumentationVisitor.this.config.getLogInstrumentation()) {
                    InstrumentationVisitor.this.logger.debug("Instrumented opcode: " + opcode + " owner: " + owner + " name: " + name + " desc: " + descriptor);
                    InstrumentationVisitor.this.logger.debug("  Instrumented a call to HttpURLConnection.disconnect");
                }
            } else if (Intrinsics.areEqual((Object)owner, (Object)"java/net/HttpURLConnection") && Intrinsics.areEqual((Object)name, (Object)"getOutputStream") && Intrinsics.areEqual((Object)descriptor, (Object)"()Ljava/io/OutputStream;") || Intrinsics.areEqual((Object)owner, (Object)"java/net/HttpURLConnection") && Intrinsics.areEqual((Object)name, (Object)"getInputStream") && Intrinsics.areEqual((Object)descriptor, (Object)"()Ljava/io/InputStream;") || Intrinsics.areEqual((Object)owner, (Object)"java/net/HttpURLConnection") && Intrinsics.areEqual((Object)name, (Object)"setRequestMethod") && Intrinsics.areEqual((Object)descriptor, (Object)"(Ljava/lang/String;)Ljava/io/OutputStream;") || Intrinsics.areEqual((Object)owner, (Object)"java/net/HttpURLConnection") && Intrinsics.areEqual((Object)name, (Object)"connect") && Intrinsics.areEqual((Object)descriptor, (Object)"()V")) {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                if (opcode == 191) {
                    this.dup();
                    this.loadThis();
                    this.mv.visitMethodInsn(184, "com/instana/android/instrumentation/urlConnection/UrlConnectionInstrumentation", "handleException", "(Ljava/net/HttpURLConnection;Ljava/io/IOException;)V", false);
                }
                if (InstrumentationVisitor.this.config.getLogInstrumentation()) {
                    InstrumentationVisitor.this.logger.debug("Instrumented opcode: " + opcode + " owner: " + owner + " name: " + name + " desc: " + descriptor);
                    InstrumentationVisitor.this.logger.debug("  Instrumented exceptions related to HttpURLConnection");
                }
            } else if (Intrinsics.areEqual((Object)owner, (Object)"okhttp3/Call") && Intrinsics.areEqual((Object)name, (Object)"cancel") && Intrinsics.areEqual((Object)descriptor, (Object)"()V")) {
                this.dup();
                this.mv.visitMethodInsn(184, "com/instana/android/instrumentation/okhttp3/OkHttp3Instrumentation", "cancelCall", "(Lokhttp3/Call;)V", false);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                if (InstrumentationVisitor.this.config.getLogInstrumentation()) {
                    InstrumentationVisitor.this.logger.debug("Instrumented opcode: " + opcode + " owner: " + owner + " name: " + name + " desc: " + descriptor);
                    InstrumentationVisitor.this.logger.debug("  Instrumented a call to okhttp3.Call.cancel");
                }
            } else if (Intrinsics.areEqual((Object)owner, (Object)"okhttp3/Dispatcher") && Intrinsics.areEqual((Object)name, (Object)"cancelAll") && Intrinsics.areEqual((Object)descriptor, (Object)"()V")) {
                this.dup();
                this.mv.visitMethodInsn(184, "com/instana/android/instrumentation/okhttp3/OkHttp3Instrumentation", "cancelAllCall", "(Lokhttp3/Dispatcher;)V", false);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                if (InstrumentationVisitor.this.config.getLogInstrumentation()) {
                    InstrumentationVisitor.this.logger.debug("Instrumented opcode: " + opcode + " owner: " + owner + " name: " + name + " desc: " + descriptor);
                    InstrumentationVisitor.this.logger.debug("  Instrumented a call to okhttp3.Dispatcher.cancelAll");
                }
            } else {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }
        }
    }
}

