/*
 * Decompiled with CFR 0.152.
 */
package com.instana.sdk.support;

import com.instana.sdk.annotation.Span;
import java.util.Map;
import java.util.concurrent.Callable;

public class SpanSupport {
    public static final String TRACE_ID = "X-INSTANA-T";
    public static final String SPAN_ID = "X-INSTANA-S";
    public static final String LEVEL = "X-INSTANA-L";
    public static final String SUPPRESS = "0";
    @Deprecated
    public static final long VOID_ID = 0L;

    private SpanSupport() {
        throw new UnsupportedOperationException();
    }

    public static boolean isTracing() {
        return false;
    }

    @Deprecated
    public static boolean isTracing(Span.Type type) {
        return SpanSupport.isTracing(type, null);
    }

    public static boolean isTracing(Span.Type type, String name) {
        return false;
    }

    @Deprecated
    public static long currentTraceId(Span.Type type) {
        return SpanSupport.currentTraceId(type, null);
    }

    @Deprecated
    public static long currentTraceId(Span.Type type, String name) {
        return 0L;
    }

    public static String traceId() {
        return null;
    }

    public static String traceId(Span.Type type, String name) {
        return null;
    }

    @Deprecated
    public static long currentSpanId(Span.Type type) {
        return SpanSupport.currentSpanId(type, null);
    }

    @Deprecated
    public static long currentSpanId(Span.Type type, String name) {
        return 0L;
    }

    public static String spanId() {
        return null;
    }

    public static String spanId(Span.Type type, String name) {
        return null;
    }

    public static void annotate(String key, String value) {
    }

    public static void annotate(String key, Callable<? extends String> value) {
        if (SpanSupport.isTracing()) {
            try {
                SpanSupport.annotate(key, value.call());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public static void annotate(Span.Type type, String key, String value) {
        SpanSupport.annotate(type, null, key, value);
    }

    public static void annotate(Span.Type type, String name, String key, String value) {
    }

    @Deprecated
    public static void annotate(Span.Type type, String key, Callable<? extends String> value) {
        SpanSupport.annotate(type, null, key, value);
    }

    public static void annotate(Span.Type type, String name, String key, Callable<? extends String> value) {
        if (SpanSupport.isTracing(type, name)) {
            try {
                SpanSupport.annotate(type, name, key, value.call());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void suppressNext() {
    }

    @Deprecated
    public static void inheritNext(long traceId, long spanId) {
    }

    public static void inheritNext(String traceId, String spanId) {
    }

    public static boolean clearCurrent() {
        return false;
    }

    public static boolean clearCurrent(Span.Type type) {
        return false;
    }

    public static boolean clearCurrent(Span.Type type, String name) {
        return false;
    }

    @Deprecated
    public static String idAsString(long id) {
        return Long.toHexString(id);
    }

    @Deprecated
    public static long stringAsId(String stringId) {
        int len = stringId.length();
        if (len <= 12) {
            return Long.parseLong(stringId, 16);
        }
        long first = Long.parseLong(stringId.substring(0, len - 1), 16);
        int second = Character.digit(stringId.charAt(len - 1), 16);
        return first * 16L + (long)second;
    }

    public static void addTraceHeadersIfTracing(Map<? super String, ? super String> map) {
        if (SpanSupport.isTracing()) {
            map.put(TRACE_ID, SpanSupport.traceId());
            map.put(SPAN_ID, SpanSupport.spanId());
            map.put(LEVEL, "1");
        }
    }

    @Deprecated
    public static void addTraceHeadersIfTracing(Span.Type type, Map<? super String, ? super String> map) {
        SpanSupport.addTraceHeadersIfTracing(type, null, map);
    }

    public static void addTraceHeadersIfTracing(Span.Type type, String name, Map<? super String, ? super String> map) {
        if (SpanSupport.isTracing(type, name)) {
            map.put(TRACE_ID, SpanSupport.traceId(type, name));
            map.put(SPAN_ID, SpanSupport.spanId(type, name));
            map.put(LEVEL, "1");
        }
    }

    public static boolean continueTraceIfTracing(Map<? super String, ? super String> map) {
        if (map != null) {
            String traceId = map.get(TRACE_ID);
            String spanId = map.get(SPAN_ID);
            if (traceId != null && spanId != null) {
                SpanSupport.inheritNext(traceId.toString(), spanId.toString());
                return true;
            }
        }
        return false;
    }
}

