/*
 * Decompiled with CFR 0.152.
 */
package com.intapp.vertx.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import io.vertx.core.Verticle;
import io.vertx.core.impl.verticle.CompilingClassLoader;
import io.vertx.core.spi.VerticleFactory;

public class GuiceVerticleFactory
implements VerticleFactory {
    public static final String PREFIX = "java-guice";
    private final Injector injector;

    public GuiceVerticleFactory(Injector injector) {
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector);
    }

    public String prefix() {
        return PREFIX;
    }

    public Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
        Class clazz;
        if ((verticleName = VerticleFactory.removePrefix((String)verticleName)).endsWith(".java")) {
            CompilingClassLoader compilingLoader = new CompilingClassLoader(classLoader, verticleName);
            String className = compilingLoader.resolveMainClassName();
            clazz = compilingLoader.loadClass(className);
        } else {
            clazz = classLoader.loadClass(verticleName);
        }
        return (Verticle)this.injector.getInstance(clazz);
    }
}

