/*
 * Decompiled with CFR 0.152.
 */
package com.intapp.vertx.guice;

import com.google.common.base.Preconditions;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;

public class GuiceVertxDeploymentManager {
    private final Vertx vertx;

    public GuiceVertxDeploymentManager(Vertx vertx) {
        this.vertx = (Vertx)Preconditions.checkNotNull((Object)vertx);
    }

    public void deployVerticle(Class verticleClazz) {
        Preconditions.checkNotNull((Object)verticleClazz);
        this.deployVerticle(verticleClazz, new DeploymentOptions());
    }

    public void deployVerticle(Class verticleClazz, DeploymentOptions options) {
        Preconditions.checkNotNull((Object)verticleClazz);
        Preconditions.checkNotNull((Object)options);
        this.vertx.deployVerticle(GuiceVertxDeploymentManager.getFullVerticleName(verticleClazz), options);
    }

    public void deployVerticle(Class verticleClazz, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        Preconditions.checkNotNull((Object)verticleClazz);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull(completionHandler);
        this.vertx.deployVerticle(GuiceVertxDeploymentManager.getFullVerticleName(verticleClazz), options, completionHandler);
    }

    private static String getFullVerticleName(Class verticleClazz) {
        return "java-guice:" + verticleClazz.getCanonicalName();
    }
}

