/*
 * Decompiled with CFR 0.152.
 */
package com.intapp.vertx.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.intapp.vertx.guice.GuiceVerticleFactory;
import com.intapp.vertx.guice.VertxModule;
import io.vertx.core.Launcher;
import io.vertx.core.Vertx;
import io.vertx.core.spi.VerticleFactory;
import java.util.LinkedList;
import java.util.List;

public class GuiceVertxLauncher
extends Launcher {
    public static void main(String[] args) {
        new GuiceVertxLauncher().dispatch(args);
    }

    public void afterStartingVertx(Vertx vertx) {
        super.afterStartingVertx(vertx);
        GuiceVerticleFactory guiceVerticleFactory = new GuiceVerticleFactory(this.createInjector(vertx));
        vertx.registerVerticleFactory((VerticleFactory)guiceVerticleFactory);
    }

    protected Injector createInjector(Vertx vertx) {
        return Guice.createInjector(this.getModules(vertx));
    }

    protected List<Module> getModules(Vertx vertx) {
        LinkedList<Module> modules = new LinkedList<Module>();
        modules.add((Module)new VertxModule(vertx));
        return modules;
    }
}

