/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.serving.benchmark;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.orca.inference.InferenceModel;
import com.intel.analytics.bigdl.serving.benchmark.Operations;
import com.intel.analytics.bigdl.serving.benchmark.Operations$Config$;
import com.intel.analytics.bigdl.serving.benchmark.TestUtils$;
import com.intel.analytics.bigdl.serving.http.JsonUtil$;
import com.intel.analytics.bigdl.serving.http.ServingTimerMetrics$;
import com.intel.analytics.bigdl.serving.http.Supportive;
import com.intel.analytics.bigdl.serving.serialization.JsonInputDeserializer$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.parallel.package$;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scopt.OptionParser;
import scopt.Read$;

public final class Operations$
implements Supportive {
    public static Operations$ MODULE$;
    private final OptionParser<Operations.Config> parser;
    private final MetricRegistry metrics;
    private final Logger logger;

    static {
        new Operations$();
    }

    @Override
    public <T> T timing(String name, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.timing$(this, name, timers, f);
    }

    @Override
    public <T> T average(String name, int batch, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.average$(this, name, batch, timers, f);
    }

    @Override
    public <T> T silent(String name, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.silent$(this, name, timers, f);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$intel$analytics$bigdl$serving$http$Supportive$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public OptionParser<Operations.Config> parser() {
        return this.parser;
    }

    public void main(String[] args) {
        Operations.Config arg = (Operations.Config)Option$.MODULE$.option2Iterable(this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new Operations.Config(Operations$Config$.MODULE$.apply$default$1(), Operations$Config$.MODULE$.apply$default$2()))).head();
        String path = arg.modelPath();
        String jsonPath = arg.jsonPath();
        String string = TestUtils$.MODULE$.getStrFromResourceFile(jsonPath);
        Activity input = JsonInputDeserializer$.MODULE$.deserialize(string, JsonInputDeserializer$.MODULE$.deserialize$default$2());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)threadNumber -> {
            InferenceModel model = new InferenceModel(threadNumber);
            model.doLoadTensorflow(path, "frozenModel");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)range -> {
                MODULE$.logger().info(new StringBuilder(43).append("inference with ").append(threadNumber).append(" threads and range ").append(range).append(" starts.\n").toString());
                String preprocessingKey = new StringBuilder(28).append("preprocessing.").append(threadNumber).append("_thread.").append(range).append("_range").toString();
                String postprocessingKey = new StringBuilder(29).append("postprocessing.").append(threadNumber).append("_thread.").append(range).append("_range").toString();
                String predictKey = new StringBuilder(22).append("predict.").append(threadNumber).append("_thread.").append(range).append("_range").toString();
                Timer preprocessingTimer = MODULE$.metrics().timer(preprocessingKey);
                Timer postprocessingTimer = MODULE$.metrics().timer(postprocessingKey);
                Timer predictTimer = MODULE$.metrics().timer(predictKey);
                package$.MODULE$.CollectionsHaveToParArray((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), threadNumber).indices(), (Function1)Predef$.MODULE$.$conforms()).toParArray().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)threadIndex -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                    MODULE$.timing("preprocessing", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{preprocessingTimer}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> MODULE$.mockOperation1ms()));
                    MODULE$.timing(new StringBuilder(15).append("thread ").append(threadIndex).append(" predict").toString(), (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{predictTimer}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        Activity activity = model.doPredict(input);
                    });
                    MODULE$.timing("postprocessing", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{postprocessingTimer}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> MODULE$.mockOperation1ms()));
                    Thread.sleep(range);
                }));
                .colon.colon servingMetricsList = new .colon.colon((Object)ServingTimerMetrics$.MODULE$.apply(preprocessingKey, preprocessingTimer), (List)new .colon.colon((Object)ServingTimerMetrics$.MODULE$.apply(predictKey, predictTimer), (List)new .colon.colon((Object)ServingTimerMetrics$.MODULE$.apply(postprocessingKey, postprocessingTimer), (List)Nil$.MODULE$)));
                String jsonMetrics = JsonUtil$.MODULE$.toJson(servingMetricsList);
                MODULE$.logger().info(jsonMetrics);
            });
        });
    }

    public void mockOperation1ms() {
        IntRef num = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 200000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ++num$1.elem);
    }

    public MetricRegistry metrics() {
        return this.metrics;
    }

    private Operations$() {
        MODULE$ = this;
        Supportive.$init$(this);
        this.parser = new OptionParser<Operations.Config>(){
            {
                this.opt('m', "modelPath", Read$.MODULE$.stringRead()).text("Model Path for Test").action((Function2 & Serializable & scala.Serializable)(x, params) -> params.copy((String)x, params.copy$default$2())).required();
                this.opt('j', "jsonPath", Read$.MODULE$.stringRead()).text("Json Format Input Path of Model").action((Function2 & Serializable & scala.Serializable)(x, params) -> {
                    String x$1 = x;
                    String x$2 = params.copy$default$1();
                    return params.copy(x$2, x$1);
                }).required();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String com.intel.analytics.bigdl.serving.benchmark.Operations$Config ), $anonfun$new$2(java.lang.String com.intel.analytics.bigdl.serving.benchmark.Operations$Config )}, serializedLambda);
            }
        };
        this.metrics = new MetricRegistry();
    }
}

