/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.serving.http;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.RateLimiter;
import com.intel.analytics.bigdl.serving.http.ClusterServingMetaData;
import com.intel.analytics.bigdl.serving.http.DataInputMessage;
import com.intel.analytics.bigdl.serving.http.DequeueMessage;
import com.intel.analytics.bigdl.serving.http.FrontEndApp$;
import com.intel.analytics.bigdl.serving.http.Instances;
import com.intel.analytics.bigdl.serving.http.Instances$;
import com.intel.analytics.bigdl.serving.http.InstancesPredictionInput$;
import com.intel.analytics.bigdl.serving.http.ModelMetaData;
import com.intel.analytics.bigdl.serving.http.ModelOutputMessage;
import com.intel.analytics.bigdl.serving.http.PredictionInput;
import com.intel.analytics.bigdl.serving.http.PredictionInputMessage;
import com.intel.analytics.bigdl.serving.http.PredictionOutput;
import com.intel.analytics.bigdl.serving.http.PredictionQueryMessage;
import com.intel.analytics.bigdl.serving.http.QueryActor;
import com.intel.analytics.bigdl.serving.http.RedisGetActor;
import com.intel.analytics.bigdl.serving.http.RedisIOActor;
import com.intel.analytics.bigdl.serving.http.RedisPutActor;
import com.intel.analytics.bigdl.serving.http.Servable;
import com.intel.analytics.bigdl.serving.http.Supportive;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\r\u001b\u0001\u001dB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006g\u0001!\t\u0001\u000e\u0005\no\u0001\u0001\r\u00111A\u0005\u0002aB\u0011\"\u0011\u0001A\u0002\u0003\u0007I\u0011\u0001\"\t\u0013-\u0003\u0001\u0019!A!B\u0013I\u0004\"\u0003'\u0001\u0001\u0004\u0005\r\u0011\"\u00019\u0011%i\u0005\u00011AA\u0002\u0013\u0005a\nC\u0005Q\u0001\u0001\u0007\t\u0011)Q\u0005s!I\u0011\u000b\u0001a\u0001\u0002\u0004%\tA\u0015\u0005\n;\u0002\u0001\r\u00111A\u0005\u0002yC\u0011\u0002\u0019\u0001A\u0002\u0003\u0005\u000b\u0015B*\t\u000f\u0005\u0004!\u0019!C\u0001E\"1Q\u000e\u0001Q\u0001\n\rDqA\u001c\u0001C\u0002\u0013\u0005q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0011\u001d\t\t\u0001\u0001Q\u0001\nYD!\"a\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u00019\u0011-\t)\u0001\u0001a\u0001\u0002\u0004%\t!a\u0002\t\u0015\u0005-\u0001\u00011A\u0001B\u0003&\u0011\bC\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005\u001d\u0003bBA*\u0001\u0011\u0005\u0013Q\u000b\u0002\u0017\u00072,8\u000f^3s'\u0016\u0014h/\u001b8h'\u0016\u0014h/\u00192mK*\u00111\u0004H\u0001\u0005QR$\bO\u0003\u0002\u001e=\u000591/\u001a:wS:<'BA\u0010!\u0003\u0015\u0011\u0017n\u001a3m\u0015\t\t#%A\u0005b]\u0006d\u0017\u0010^5dg*\u00111\u0005J\u0001\u0006S:$X\r\u001c\u0006\u0002K\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u000b\u0017\u0011\u0005%RS\"\u0001\u000e\n\u0005-R\"\u0001C*feZ\f'\r\\3\u0011\u0005%j\u0013B\u0001\u0018\u001b\u0005)\u0019V\u000f\u001d9peRLg/Z\u0001\u0017G2,8\u000f^3s'\u0016\u0014h/\u001b8h\u001b\u0016$\u0018\rR1uCB\u0011\u0011&M\u0005\u0003ei\u0011ac\u00117vgR,'oU3sm&tw-T3uC\u0012\u000bG/Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U2\u0004CA\u0015\u0001\u0011\u0015y#\u00011\u00011\u0003-\u0011X\rZ5t!V$H/\u001a:\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003y\nA!Y6lC&\u0011\u0001i\u000f\u0002\t\u0003\u000e$xN\u001d*fM\u0006y!/\u001a3jgB+H\u000f^3s?\u0012*\u0017\u000f\u0006\u0002D\u0013B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n!QK\\5u\u0011\u001dQE!!AA\u0002e\n1\u0001\u001f\u00132\u00031\u0011X\rZ5t!V$H/\u001a:!\u0003-\u0011X\rZ5t\u000f\u0016$H/\u001a:\u0002\u001fI,G-[:HKR$XM]0%KF$\"aQ(\t\u000f);\u0011\u0011!a\u0001s\u0005a!/\u001a3jg\u001e+G\u000f^3sA\u0005a\u0011/^3sS\u0016\u0014\u0018+^3vKV\t1\u000bE\u0002U7fj\u0011!\u0016\u0006\u0003-^\u000b!bY8oGV\u0014(/\u001a8u\u0015\tA\u0016,\u0001\u0003vi&d'\"\u0001.\u0002\t)\fg/Y\u0005\u00039V\u00131\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\f\u0001#];fe&,'/U;fk\u0016|F%Z9\u0015\u0005\r{\u0006b\u0002&\u000b\u0003\u0003\u0005\raU\u0001\u000ecV,'/[3s#V,W/\u001a\u0011\u0002\u001f),G-[:Q_>d7i\u001c8gS\u001e,\u0012a\u0019\t\u0003I.l\u0011!\u001a\u0006\u0003M\u001e\fQA[3eSNT!\u0001[5\u0002\u000f\rd\u0017.\u001a8ug*\t!.A\u0003sK\u0012L7/\u0003\u0002mK\ny!*\u001a3jgB{w\u000e\\\"p]\u001aLw-\u0001\tkK\u0012L7\u000fU8pY\u000e{gNZ5hA\u0005I!.\u001a3jgB{w\u000e\\\u000b\u0002aB\u0011A-]\u0005\u0003e\u0016\u0014\u0011BS3eSN\u0004vn\u001c7\u0002\u0015),G-[:Q_>d\u0007%A\u0006sCR,G*[7ji\u0016\u0014X#\u0001<\u0011\u0005]tX\"\u0001=\u000b\u0005YK(B\u0001-{\u0015\tYH0\u0001\u0004d_6lwN\u001c\u0006\u0003{\u0012\naaZ8pO2,\u0017BA@y\u0005-\u0011\u0016\r^3MS6LG/\u001a:\u0002\u0019I\fG/\u001a'j[&$XM\u001d\u0011\u0002\u000f%|\u0017i\u0019;pe\u0006Y\u0011n\\!di>\u0014x\fJ3r)\r\u0019\u0015\u0011\u0002\u0005\b\u0015N\t\t\u00111\u0001:\u0003!Iw.Q2u_J\u0004\u0013\u0001\u00027pC\u0012$\u0012aQ\u0001\baJ,G-[2u)\u0011\t)\"a\u0011\u0011\r\u0005]\u0011qEA\u0017\u001d\u0011\tI\"a\t\u000f\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b'\u0003\u0019a$o\\8u}%\ta)C\u0002\u0002&\u0015\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002*\u0005-\"aA*fc*\u0019\u0011QE#\u0011\u000b%\ny#a\r\n\u0007\u0005E\"D\u0001\tQe\u0016$\u0017n\u0019;j_:|U\u000f\u001e9viB!\u0011QGA\u001f\u001d\u0011\t9$!\u000f\u0011\u0007\u0005mQ)C\u0002\u0002<\u0015\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001e\u000b\"9\u0011Q\t\fA\u0002\u0005M\u0012!B5oaV$H\u0003BA\u000b\u0003\u0013Bq!a\u0013\u0018\u0001\u0004\ti%A\u0005j]N$\u0018M\\2fgB\u0019\u0011&a\u0014\n\u0007\u0005E#DA\u0005J]N$\u0018M\\2fg\u0006Yq-\u001a;NKR\fG)\u0019;b+\t\t9\u0006E\u0002*\u00033J1!a\u0017\u001b\u00055iu\u000eZ3m\u001b\u0016$\u0018\rR1uC\u0002")
public class ClusterServingServable
extends Servable
implements Supportive {
    private final ClusterServingMetaData clusterServingMetaData;
    private ActorRef redisPutter;
    private ActorRef redisGetter;
    private LinkedBlockingQueue<ActorRef> querierQueue;
    private final JedisPoolConfig jedisPoolConfig;
    private final JedisPool jedisPool;
    private final RateLimiter rateLimiter;
    private ActorRef ioActor;
    private final Logger logger;

    @Override
    public <T> T timing(String name, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.timing$(this, name, timers, f);
    }

    @Override
    public <T> T average(String name, int batch, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.average$(this, name, batch, timers, f);
    }

    @Override
    public <T> T silent(String name, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.silent$(this, name, timers, f);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$intel$analytics$bigdl$serving$http$Supportive$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ActorRef redisPutter() {
        return this.redisPutter;
    }

    public void redisPutter_$eq(ActorRef x$1) {
        this.redisPutter = x$1;
    }

    public ActorRef redisGetter() {
        return this.redisGetter;
    }

    public void redisGetter_$eq(ActorRef x$1) {
        this.redisGetter = x$1;
    }

    public LinkedBlockingQueue<ActorRef> querierQueue() {
        return this.querierQueue;
    }

    public void querierQueue_$eq(LinkedBlockingQueue<ActorRef> x$1) {
        this.querierQueue = x$1;
    }

    public JedisPoolConfig jedisPoolConfig() {
        return this.jedisPoolConfig;
    }

    public JedisPool jedisPool() {
        return this.jedisPool;
    }

    public RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    public ActorRef ioActor() {
        return this.ioActor;
    }

    public void ioActor_$eq(ActorRef x$1) {
        this.ioActor = x$1;
    }

    @Override
    public void load() {
        String redisPutterName = new StringBuilder(14).append("redis-putter-").append(this.clusterServingMetaData.modelName()).append("-").append(this.clusterServingMetaData.modelVersion()).toString();
        this.redisPutter_$eq((ActorRef)this.timing(new StringBuilder(13).append(redisPutterName).append(" initialized.").toString(), (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
            Props redisPutterProps = Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new RedisPutActor($this.clusterServingMetaData.redisHost(), new StringOps(Predef$.MODULE$.augmentString($this.clusterServingMetaData.redisPort())).toInt(), $this.clusterServingMetaData.redisInputQueue(), $this.clusterServingMetaData.redisOutputQueue(), $this.clusterServingMetaData.timeWindow(), $this.clusterServingMetaData.countWindow(), $this.clusterServingMetaData.redisSecureEnabled(), $this.clusterServingMetaData.redisTrustStorePath(), $this.clusterServingMetaData.redisTrustStoreToken()), ClassTag$.MODULE$.apply(RedisPutActor.class));
            return FrontEndApp$.MODULE$.system().actorOf(redisPutterProps, redisPutterName);
        }));
        String redisGetterName = new StringBuilder(14).append("redis-getter-").append(this.clusterServingMetaData.modelName()).append("-").append(this.clusterServingMetaData.modelVersion()).toString();
        this.redisGetter_$eq((ActorRef)this.timing(new StringBuilder(13).append(redisGetterName).append(" initialized.").toString(), (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
            Props redisGetterProps = Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new RedisGetActor($this.clusterServingMetaData.redisHost(), new StringOps(Predef$.MODULE$.augmentString($this.clusterServingMetaData.redisPort())).toInt(), $this.clusterServingMetaData.redisInputQueue(), $this.clusterServingMetaData.redisOutputQueue(), $this.clusterServingMetaData.redisSecureEnabled(), $this.clusterServingMetaData.redisTrustStorePath(), $this.clusterServingMetaData.redisTrustStoreToken()), ClassTag$.MODULE$.apply(RedisGetActor.class));
            return FrontEndApp$.MODULE$.system().actorOf(redisGetterProps, redisGetterName);
        }));
        int querierNum = 1000;
        this.querierQueue_$eq((LinkedBlockingQueue)this.timing("queriers initialized.", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            LinkedBlockingQueue querierQueue = new LinkedBlockingQueue(querierNum);
            Props querierProps = Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new QueryActor(this.redisGetter()), ClassTag$.MODULE$.apply(QueryActor.class));
            ((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)querierNum), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                String querierName = new StringBuilder(10).append("querier-").append(index).append("-").append($this.clusterServingMetaData.modelName()).append("-").append($this.clusterServingMetaData.modelVersion()).toString();
                ActorRef querier = FrontEndApp$.MODULE$.system().actorOf(querierProps, querierName);
                querierQueue.put(querier);
            }, List$.MODULE$.canBuildFrom());
            return var2_2;
        }));
        String actorName = new StringBuilder(22).append("redis-ioActor-getter-").append(this.clusterServingMetaData.modelName()).append("-").append(this.clusterServingMetaData.modelVersion()).toString();
        this.ioActor_$eq((ActorRef)this.timing(new StringBuilder(13).append(actorName).append(" initialized.").toString(), (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
            Props getterProps = Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                JedisPool x$1 = this.jedisPool();
                String x$2 = $this.clusterServingMetaData.redisOutputQueue();
                String x$3 = $this.clusterServingMetaData.redisInputQueue();
                return new RedisIOActor(x$2, x$3, x$1);
            }, ClassTag$.MODULE$.apply(RedisIOActor.class));
            return FrontEndApp$.MODULE$.system().actorOf(getterProps, actorName);
        }));
        Scheduler qual$1 = FrontEndApp$.MODULE$.system().scheduler();
        FiniteDuration x$4 = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).milliseconds();
        FiniteDuration x$5 = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millisecond();
        ActorRef x$6 = this.ioActor();
        DequeueMessage x$7 = new DequeueMessage();
        ExecutionContextExecutor x$8 = FrontEndApp$.MODULE$.system().dispatcher();
        ActorRef x$9 = qual$1.schedule$default$6(x$4, x$5, x$6, (Object)x$7);
        qual$1.schedule(x$4, x$5, x$6, (Object)x$7, (ExecutionContext)x$8, x$9);
    }

    @Override
    public Seq<PredictionOutput<String>> predict(String input) {
        String id = UUID.randomUUID().toString();
        Iterable result = (Iterable)this.timing("response waiting", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
            String id = UUID.randomUUID().toString();
            Map results = (Map)this.timing(new StringBuilder(27).append("query message wait for key ").append(id).toString(), (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
                ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.ioActor());
                DataInputMessage x$1 = new DataInputMessage(id, input);
                Timeout x$2 = FrontEndApp$.MODULE$.timeout();
                ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
                return ((ModelOutputMessage)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)FrontEndApp$.MODULE$.timeout().duration())).valueMap();
            });
            ObjectMapper objectMapper = new ObjectMapper();
            return (Iterable)results.map((Function1 & Serializable & scala.Serializable)r -> {
                String resultStr = objectMapper.writeValueAsString(r._2());
                return new PredictionOutput<String>((String)r._1(), resultStr);
            }, Iterable$.MODULE$.canBuildFrom());
        });
        return result.toSeq();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<PredictionOutput<String>> predict(Instances instances) {
        void var3_3;
        this.logger().info("cluster serving predict as instance");
        List inputs = (List)instances.instances().map((Function1 & Serializable & scala.Serializable)instance -> InstancesPredictionInput$.MODULE$.apply(Instances$.MODULE$.apply((LinkedHashMap<String, Object>)instance)), List$.MODULE$.canBuildFrom());
        this.timing("put message send", (Seq<Timer>)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PredictionInputMessage message = new PredictionInputMessage((Seq<PredictionInput>)inputs);
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.redisPutter());
            PredictionInputMessage x$1 = message;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        });
        Seq result = (Seq)this.timing("response waiting", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
            List ids = (List)inputs.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), List$.MODULE$.canBuildFrom());
            PredictionQueryMessage queryMessage = new PredictionQueryMessage((Seq<String>)ids);
            ActorRef querier = (ActorRef)this.timing("querier take", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> this.querierQueue().take());
            Seq results = (Seq)this.timing(new StringBuilder(27).append("query message wait for key ").append(ids).toString(), (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{FrontEndApp$.MODULE$.overallRequestTimer(), FrontEndApp$.MODULE$.waitRedisTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                ActorRef qual$2 = akka.pattern.package$.MODULE$.ask(querier);
                PredictionQueryMessage x$3 = queryMessage;
                Timeout x$4 = FrontEndApp$.MODULE$.timeout();
                ActorRef x$5 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$2, (Object)x$3);
                return (Seq)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$2, (Object)x$3, x$4, x$5), (Duration)FrontEndApp$.MODULE$.timeout().duration());
            });
            this.timing("querier back", (Seq<Timer>)Nil$.MODULE$, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.querierQueue().offer(querier));
            ObjectMapper objectMapper = new ObjectMapper();
            return (Seq)results.map((Function1 & Serializable & scala.Serializable)r -> {
                String resultStr = objectMapper.writeValueAsString(r._2());
                return new PredictionOutput<String>((String)r._1(), resultStr);
            }, Seq$.MODULE$.canBuildFrom());
        });
        return var3_3;
    }

    @Override
    public ModelMetaData getMetaData() {
        return new ClusterServingMetaData(this.clusterServingMetaData.modelName(), this.clusterServingMetaData.modelVersion(), this.clusterServingMetaData.redisHost(), this.clusterServingMetaData.redisPort(), this.clusterServingMetaData.redisInputQueue(), this.clusterServingMetaData.redisOutputQueue(), this.clusterServingMetaData.timeWindow(), this.clusterServingMetaData.countWindow(), this.clusterServingMetaData.tokenBucketEnabled(), this.clusterServingMetaData.tokensPerSecond(), this.clusterServingMetaData.redisSecureEnabled(), "*******", "*******", this.clusterServingMetaData.inputCompileType(), this.clusterServingMetaData.features());
    }

    public ClusterServingServable(ClusterServingMetaData clusterServingMetaData) {
        RateLimiter rateLimiter;
        this.clusterServingMetaData = clusterServingMetaData;
        super(clusterServingMetaData);
        Supportive.$init$(this);
        this.jedisPoolConfig = new JedisPoolConfig();
        this.jedisPoolConfig().setMaxTotal(256);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig(), clusterServingMetaData.redisHost(), new StringOps(Predef$.MODULE$.augmentString(clusterServingMetaData.redisPort())).toInt());
        boolean bl = clusterServingMetaData.tokenBucketEnabled();
        if (bl) {
            rateLimiter = RateLimiter.create((double)clusterServingMetaData.tokensPerSecond());
        } else if (!bl) {
            rateLimiter = null;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        this.rateLimiter = rateLimiter;
    }
}

