/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.serving.http;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Props;
import akka.actor.Props$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.ConnectionContext;
import akka.http.scaladsl.ConnectionContext$;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.StatusCode$;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.ExceptionHandler;
import akka.http.scaladsl.server.PathMatcher;
import akka.http.scaladsl.server.RejectionHandler;
import akka.http.scaladsl.server.RouteResult$;
import akka.http.scaladsl.server.RoutingLog;
import akka.http.scaladsl.server.RoutingLog$;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.TupleOps;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.ParserSettings$;
import akka.http.scaladsl.settings.RoutingSettings;
import akka.http.scaladsl.settings.RoutingSettings$;
import akka.http.scaladsl.settings.ServerSettings;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.orca.inference.EncryptSupportive;
import com.intel.analytics.bigdl.serving.http.ClusterServingMetaData;
import com.intel.analytics.bigdl.serving.http.ClusterServingServable;
import com.intel.analytics.bigdl.serving.http.FrontEndApp$;
import com.intel.analytics.bigdl.serving.http.FrontEndAppArguments;
import com.intel.analytics.bigdl.serving.http.FrontEndAppArguments$;
import com.intel.analytics.bigdl.serving.http.InferenceModelMetaData;
import com.intel.analytics.bigdl.serving.http.InferenceModelServable;
import com.intel.analytics.bigdl.serving.http.Instances;
import com.intel.analytics.bigdl.serving.http.JacksonJsonSerializer;
import com.intel.analytics.bigdl.serving.http.JsonUtil$;
import com.intel.analytics.bigdl.serving.http.ModelMetaData;
import com.intel.analytics.bigdl.serving.http.ModelNotFoundException;
import com.intel.analytics.bigdl.serving.http.Predictions;
import com.intel.analytics.bigdl.serving.http.Predictions$;
import com.intel.analytics.bigdl.serving.http.RedisPutActor;
import com.intel.analytics.bigdl.serving.http.SecuredModelSecretSaltMessage;
import com.intel.analytics.bigdl.serving.http.Servable;
import com.intel.analytics.bigdl.serving.http.ServableLoadException;
import com.intel.analytics.bigdl.serving.http.ServableManager;
import com.intel.analytics.bigdl.serving.http.ServingError;
import com.intel.analytics.bigdl.serving.http.ServingRuntimeException;
import com.intel.analytics.bigdl.serving.http.ServingTimerMetrics;
import com.intel.analytics.bigdl.serving.http.ServingTimerMetrics$;
import com.intel.analytics.bigdl.serving.http.Supportive;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scopt.OptionParser;
import scopt.Read$;

public final class FrontEndApp$
implements Supportive,
EncryptSupportive {
    public static FrontEndApp$ MODULE$;
    private final Logger logger;
    private final String name;
    private final ActorSystem system;
    private final ActorMaterializer materializer;
    private final ExecutionContextExecutor executionContext;
    private final Timeout timeout;
    private final MetricRegistry metrics;
    private final Timer overallRequestTimer;
    private final Timer predictRequestTimer;
    private final Timer servableRetriveTimer;
    private final Timer servablesRetriveTimer;
    private final Timer backendInferenceTimer;
    private final Timer putRedisTimer;
    private final Timer getRedisTimer;
    private final Timer waitRedisTimer;
    private final Timer metricsRequestTimer;
    private final HashMap<String, HashMap<String, Timer>> modelInferenceTimersMap;
    private final HashMap<String, HashMap<String, Timer>> purePredictTimersMap;
    private final Timer makeActivityTimer;
    private final Timer handleResponseTimer;
    private final JacksonJsonSerializer jacksonJsonSerializer;
    private final OptionParser<FrontEndAppArguments> argumentsParser;
    private final int BLOCK_SIZE;

    static {
        new FrontEndApp$();
    }

    public String encryptWithAESCBC(String content, String secret, String salt, int keyLen) {
        return EncryptSupportive.encryptWithAESCBC$((EncryptSupportive)this, (String)content, (String)secret, (String)salt, (int)keyLen);
    }

    public int encryptWithAESCBC$default$4() {
        return EncryptSupportive.encryptWithAESCBC$default$4$((EncryptSupportive)this);
    }

    public String decryptWithAESCBC(String content, String secret, String salt, int keyLen) {
        return EncryptSupportive.decryptWithAESCBC$((EncryptSupportive)this, (String)content, (String)secret, (String)salt, (int)keyLen);
    }

    public int decryptWithAESCBC$default$4() {
        return EncryptSupportive.decryptWithAESCBC$default$4$((EncryptSupportive)this);
    }

    public String encryptWithAESGCM(String content, String secret, String salt, int keyLen) {
        return EncryptSupportive.encryptWithAESGCM$((EncryptSupportive)this, (String)content, (String)secret, (String)salt, (int)keyLen);
    }

    public int encryptWithAESGCM$default$4() {
        return EncryptSupportive.encryptWithAESGCM$default$4$((EncryptSupportive)this);
    }

    public byte[] encryptBytesWithAESGCM(byte[] content, String secret, String salt, int keyLen) {
        return EncryptSupportive.encryptBytesWithAESGCM$((EncryptSupportive)this, (byte[])content, (String)secret, (String)salt, (int)keyLen);
    }

    public int encryptBytesWithAESGCM$default$4() {
        return EncryptSupportive.encryptBytesWithAESGCM$default$4$((EncryptSupportive)this);
    }

    public String decryptWithAESGCM(String content, String secret, String salt, int keyLen) {
        return EncryptSupportive.decryptWithAESGCM$((EncryptSupportive)this, (String)content, (String)secret, (String)salt, (int)keyLen);
    }

    public int decryptWithAESGCM$default$4() {
        return EncryptSupportive.decryptWithAESGCM$default$4$((EncryptSupportive)this);
    }

    public byte[] decryptBytesWithAESGCM(byte[] content, String secret, String salt, int keyLen) {
        return EncryptSupportive.decryptBytesWithAESGCM$((EncryptSupportive)this, (byte[])content, (String)secret, (String)salt, (int)keyLen);
    }

    public int decryptBytesWithAESGCM$default$4() {
        return EncryptSupportive.decryptBytesWithAESGCM$default$4$((EncryptSupportive)this);
    }

    public void encryptFileWithAESCBC(String filePath, String secret, String salt, String outputFile, int keyLen, String encoding) {
        EncryptSupportive.encryptFileWithAESCBC$((EncryptSupportive)this, (String)filePath, (String)secret, (String)salt, (String)outputFile, (int)keyLen, (String)encoding);
    }

    public int encryptFileWithAESCBC$default$5() {
        return EncryptSupportive.encryptFileWithAESCBC$default$5$((EncryptSupportive)this);
    }

    public String encryptFileWithAESCBC$default$6() {
        return EncryptSupportive.encryptFileWithAESCBC$default$6$((EncryptSupportive)this);
    }

    public String decryptFileWithAESCBC(String filePath, String secret, String salt, int keyLen, String encoding) {
        return EncryptSupportive.decryptFileWithAESCBC$((EncryptSupportive)this, (String)filePath, (String)secret, (String)salt, (int)keyLen, (String)encoding);
    }

    public int decryptFileWithAESCBC$default$4() {
        return EncryptSupportive.decryptFileWithAESCBC$default$4$((EncryptSupportive)this);
    }

    public String decryptFileWithAESCBC$default$5() {
        return EncryptSupportive.decryptFileWithAESCBC$default$5$((EncryptSupportive)this);
    }

    public void decryptFileWithAESCBC(String filePath, String secret, String salt, String outputFile) {
        EncryptSupportive.decryptFileWithAESCBC$((EncryptSupportive)this, (String)filePath, (String)secret, (String)salt, (String)outputFile);
    }

    @Override
    public <T> T timing(String name, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.timing$(this, name, timers, f);
    }

    @Override
    public <T> T average(String name, int batch, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.average$(this, name, batch, timers, f);
    }

    @Override
    public <T> T silent(String name, Seq<Timer> timers, Function0<T> f) {
        return (T)Supportive.silent$(this, name, timers, f);
    }

    public int BLOCK_SIZE() {
        return this.BLOCK_SIZE;
    }

    public void com$intel$analytics$bigdl$orca$inference$EncryptSupportive$_setter_$BLOCK_SIZE_$eq(int x$1) {
        this.BLOCK_SIZE = x$1;
    }

    @Override
    public void com$intel$analytics$bigdl$serving$http$Supportive$_setter_$logger_$eq(Logger x$1) {
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    public String name() {
        return this.name;
    }

    public ActorSystem system() {
        return this.system;
    }

    public ActorMaterializer materializer() {
        return this.materializer;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public void isLocalURI(String path) {
        URI uri = new URI(path);
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equalsIgnoreCase("file")) {
            this.logger().error(new StringBuilder(19).append(path).append(" isn't a local file").toString());
        } else {
            this.logger().info(new StringBuilder(16).append(path).append(" is a local file").toString());
        }
    }

    public void main(String[] args) {
        this.timing(new StringBuilder(22).append(this.name()).append(" started successfully.").toString(), (Seq<Timer>)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FrontEndAppArguments arguments = (FrontEndAppArguments)MODULE$.timing("parse arguments", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
                FrontEndAppArguments frontEndAppArguments;
                Option option = MODULE$.argumentsParser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new FrontEndAppArguments(FrontEndAppArguments$.MODULE$.apply$default$1(), FrontEndAppArguments$.MODULE$.apply$default$2(), FrontEndAppArguments$.MODULE$.apply$default$3(), FrontEndAppArguments$.MODULE$.apply$default$4(), FrontEndAppArguments$.MODULE$.apply$default$5(), FrontEndAppArguments$.MODULE$.apply$default$6(), FrontEndAppArguments$.MODULE$.apply$default$7(), FrontEndAppArguments$.MODULE$.apply$default$8(), FrontEndAppArguments$.MODULE$.apply$default$9(), FrontEndAppArguments$.MODULE$.apply$default$10(), FrontEndAppArguments$.MODULE$.apply$default$11(), FrontEndAppArguments$.MODULE$.apply$default$12(), FrontEndAppArguments$.MODULE$.apply$default$13(), FrontEndAppArguments$.MODULE$.apply$default$14(), FrontEndAppArguments$.MODULE$.apply$default$15(), FrontEndAppArguments$.MODULE$.apply$default$16(), FrontEndAppArguments$.MODULE$.apply$default$17(), FrontEndAppArguments$.MODULE$.apply$default$18(), FrontEndAppArguments$.MODULE$.apply$default$19(), FrontEndAppArguments$.MODULE$.apply$default$20()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FrontEndAppArguments arguments = (FrontEndAppArguments)some.value();
                    MODULE$.logger().info(new StringBuilder(14).append("starting with ").append(arguments).toString());
                    frontEndAppArguments = arguments;
                } else if (None$.MODULE$.equals(option)) {
                    MODULE$.argumentsParser().failure("miss args, please see the usage info");
                    frontEndAppArguments = null;
                } else {
                    throw new MatchError((Object)option);
                }
                return frontEndAppArguments;
            });
            ServableManager servableManager = new ServableManager();
            MODULE$.logger().info("Multi Serving Mode");
            MODULE$.timing("load servable manager", (Seq<Timer>)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MODULE$.isLocalURI(arguments.servableManagerPath());
                try {
                    servableManager.load(arguments.servableManagerPath(), MODULE$.purePredictTimersMap(), MODULE$.modelInferenceTimersMap());
                }
                catch (ServableLoadException e) {
                    throw e;
                }
                catch (Throwable e) {
                    String exampleYaml = "\n                ---\n                 modelMetaDataList:\n                 - !<ClusterServingMetaData>\n                    modelName: \"1\"\n                    modelVersion: \"1.0\"\n                    redisHost: \"localhost\"\n                    redisPort: \"6381\"\n                    redisInputQueue: \"serving_stream2\"\n                    redisOutputQueue: \"cluster-serving_serving_stream2:\"\n                 - !<InferenceModelMetaData>\n                    modelName: \"1\"\n                    modelVersion: \"1.0\"\n                    modelPath: \"/\"\n                    modelType: \"OpenVINO\"\n                    features:\n                      - \"a\"\n                      - \"b\"\n              ";
                    MODULE$.logger().info(new StringBuilder(24).append("Example Format of Input:").append(exampleYaml).toString());
                    throw e;
                }
            });
            MODULE$.logger().info("Servable Manager Load Success!");
            ObjectRef redisPutter = ObjectRef.create(null);
            Function1 route = (Function1)MODULE$.timing("initialize http route", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher(""))).apply((Function0 & Serializable & scala.Serializable)() -> (StandardRoute)MODULE$.timing("welcome", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.overallRequestTimer()}), (Function0 & Serializable & scala.Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new StringBuilder(11).append("welcome to ").append(MODULE$.name()).toString(), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.StringMarshaller())))))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)Directives$.MODULE$.get().$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("metrics")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (StandardRoute)MODULE$.timing("metrics", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.overallRequestTimer(), MODULE$.metricsRequestTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                Set keys = MODULE$.metrics().getTimers().keySet();
                List servingMetrics = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(keys.toArray())).map((Function1 & Serializable & scala.Serializable)key -> {
                    Timer timer = (Timer)MODULE$.metrics().getTimers().get(key);
                    return ServingTimerMetrics$.MODULE$.apply(key.toString(), timer);
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServingTimerMetrics.class))))).toList();
                return Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)MODULE$.jacksonJsonSerializer().serialize(servingMetrics), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.StringMarshaller())));
            })))).$tilde((Function1)Directive$.MODULE$.addDirectiveApply((Directive)((Directive)((Directive)Directives$.MODULE$.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("model-secure")), TupleOps.Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.extract((Function1 & Serializable & scala.Serializable)x$1 -> x$1.request().entity().contentType()), TupleOps.Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(Unmarshaller$.MODULE$.stringUnmarshaller()))), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1()))))), ApplyConverter$.MODULE$.hac2()).apply((Function2 & Serializable & scala.Serializable)(contentType, content) -> {
                StandardRoute standardRoute;
                try {
                    StandardRoute standardRoute2;
                    ActorRef x$3;
                    Timeout x$2;
                    SecuredModelSecretSaltMessage x$1;
                    if ((ActorRef)redisPutter$1.elem == null) {
                        String redisPutterName = "redis-putter";
                        MODULE$.isLocalURI(arguments.redissTrustStorePath());
                        redisPutter$1.elem = (ActorRef)MODULE$.timing(new StringBuilder(13).append(redisPutterName).append(" initialized.").toString(), (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
                            Props redisPutterProps = Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new RedisPutActor(arguments.redisHost(), arguments.redisPort(), arguments.redisInputQueue(), arguments.redisOutputQueue(), arguments.timeWindow(), arguments.countWindow(), arguments.redisSecureEnabled(), arguments.redissTrustStorePath(), arguments.redissTrustStoreToken()), ClassTag$.MODULE$.apply(RedisPutActor.class));
                            return MODULE$.system().actorOf(redisPutterProps, redisPutterName);
                        });
                    }
                    String[] secrets = content.split("&");
                    String secret = secrets[0].split("=")[1];
                    String salt = secrets[1].split("=")[1];
                    SecuredModelSecretSaltMessage message = new SecuredModelSecretSaltMessage(secret, salt);
                    ActorRef qual$1 = package$.MODULE$.ask((ActorRef)redisPutter$1.elem);
                    boolean result = BoxesRunTime.unboxToBoolean((Object)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = message), x$2 = MODULE$.timeout(), x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)MODULE$.timeout().duration()));
                    boolean bl = result;
                    if (bl) {
                        standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)"model secured secrect and salt succeed to put in redis", Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.StringMarshaller())));
                    } else if (!bl) {
                        standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)"model secured secrect and salt failed to put in redis", Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.StringMarshaller())));
                    } else {
                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                    }
                    standardRoute = standardRoute2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ServingError error = new ServingError(new StringBuilder(49).append(e.getMessage()).append("\n please post a content like ").append("secret=xxx&salt=xxxx").toString());
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)500), (Object)error.toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                return standardRoute;
            }))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)Directives$.MODULE$.get().$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("models")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)MODULE$.timing("get all model infos", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.overallRequestTimer(), MODULE$.servablesRetriveTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                StandardRoute standardRoute;
                try {
                    List<Servable> servables = servableManager.retriveAllServables();
                    List metaData = (List)servables.map((Function1 & Serializable & scala.Serializable)e -> e.getMetaData(), List$.MODULE$.canBuildFrom());
                    String json = JsonUtil$.MODULE$.toJson(metaData);
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)200), (Object)json), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (ModelNotFoundException e2) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)404), (Object)"Model Not Found"), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (ServingRuntimeException e3) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)405), (Object)new StringBuilder(27).append("Serving Runtime Error Err: ").append(e3).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (Throwable e4) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)500), (Object)new StringBuilder(16).append("Internal Error: ").append(e4).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                return standardRoute;
            })))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathPrefix(Directives$.MODULE$._segmentStringToPathMatcher("models"))).apply((Function0 & Serializable & scala.Serializable)() -> Directives$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation((Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.get().$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.path((PathMatcher)Directives$.MODULE$.Segment()), TupleOps.Join$.MODULE$.join0P())), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)modelName -> (Function1)MODULE$.timing("get model infos with model name", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.overallRequestTimer(), MODULE$.servablesRetriveTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                StandardRoute standardRoute;
                try {
                    List<Servable> servables = servableManager.retriveServables((String)modelName);
                    List metaData = (List)servables.map((Function1 & Serializable & scala.Serializable)e -> e.getMetaData(), List$.MODULE$.canBuildFrom());
                    String json = JsonUtil$.MODULE$.toJson(metaData);
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)200), (Object)json), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (ModelNotFoundException e2) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)404), (Object)"Model Not Found"), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (ServingRuntimeException e3) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)405), (Object)new StringBuilder(27).append("Serving Runtime Error Err: ").append(e3).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (Throwable e4) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)500), (Object)new StringBuilder(16).append("Internal Error: ").append(e4).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                return standardRoute;
            }))).$tilde((Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.get().$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.path(Directives$.MODULE$.Segment().$div(Directives$.MODULE$._segmentStringToPathMatcher("versions"), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t0())).$div((PathMatcher)Directives$.MODULE$.Segment(), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1()))))), TupleOps.Join$.MODULE$.join0P())), ApplyConverter$.MODULE$.hac2()).apply((Function2 & Serializable & scala.Serializable)(modelName, modelVersion) -> (Function1)MODULE$.timing("get model info with model name and model version", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.overallRequestTimer(), MODULE$.servableRetriveTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                StandardRoute standardRoute;
                try {
                    Servable servables = servableManager.retriveServable((String)modelName, (String)modelVersion);
                    ModelMetaData metaData = servables.getMetaData();
                    String json = JsonUtil$.MODULE$.toJson(metaData);
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)200), (Object)json), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (ModelNotFoundException e) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)404), (Object)"Model Not Found"), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (ServingRuntimeException e) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)405), (Object)new StringBuilder(27).append("Serving Runtime Error Err: ").append(e).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (Throwable e) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)500), (Object)new StringBuilder(16).append("Internal Error: ").append(e).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                return standardRoute;
            })))).$tilde((Function1)Directive$.MODULE$.addDirectiveApply((Directive)((Directive)((Directive)Directives$.MODULE$.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.path(Directives$.MODULE$.Segment().$div(Directives$.MODULE$._segmentStringToPathMatcher("versions"), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t0())).$div((PathMatcher)Directives$.MODULE$.Segment(), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1())))).$div(Directives$.MODULE$._segmentStringToPathMatcher("predict"), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t0()))), TupleOps.Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.extract((Function1 & Serializable & scala.Serializable)x$2 -> x$2.request().entity().contentType()), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append2())))))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(Unmarshaller$.MODULE$.stringUnmarshaller()))), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append3()))))), ApplyConverter$.MODULE$.hac4()).apply((Function4 & Serializable & scala.Serializable)(modelName, modelVersion, contentType, content) -> (Function1)MODULE$.timing("backend inference", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.overallRequestTimer(), MODULE$.backendInferenceTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                StandardRoute standardRoute;
                try {
                    Function1 function1;
                    MODULE$.logger().info(new StringBuilder(29).append("model name: ").append((String)modelName).append(", model version: ").append((String)modelVersion).toString());
                    Servable servable = (Servable)MODULE$.timing("servable retrive", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.servableRetriveTimer()}), (Function0 & Serializable & scala.Serializable)() -> servableManager.retriveServable((String)modelName, (String)modelVersion));
                    Timer modelInferenceTimer = (Timer)((HashMap)MODULE$.modelInferenceTimersMap().apply(modelName)).apply(modelVersion);
                    Servable servable2 = servable;
                    if (servable2 instanceof ClusterServingServable) {
                        ClusterServingServable clusterServingServable = (ClusterServingServable)servable2;
                        Predictions result = (Predictions)MODULE$.timing("cluster serving inference", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.predictRequestTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                            Seq seq;
                            BoxedUnit boxedUnit;
                            boolean bl;
                            boolean bl2 = arguments.tokenBucketEnabled();
                            if (bl2) {
                                bl = !clusterServingServable.rateLimiter().tryAcquire((long)arguments.tokenAcquireTimeout(), TimeUnit.MILLISECONDS);
                            } else if (!bl2) {
                                bl = false;
                            } else {
                                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
                            }
                            boolean rejected = bl;
                            if (rejected) {
                                ServingError error = new ServingError("limited");
                                boxedUnit = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)500), (Object)error.toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            String string = ((ClusterServingMetaData)servable.getMetaData()).inputCompileType();
                            if ("direct".equals(string)) {
                                seq = (Seq)MODULE$.timing("model inference direct", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{modelInferenceTimer}), (Function0 & Serializable & scala.Serializable)() -> servable.predict((String)content));
                            } else if ("instance".equals(string)) {
                                Instances instances = (Instances)MODULE$.timing("json deserialization", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> JsonUtil$.MODULE$.fromJson(Instances.class, (String)content));
                                seq = (Seq)MODULE$.timing("model inference", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{modelInferenceTimer}), (Function0 & Serializable & scala.Serializable)() -> servable.predict(instances));
                            } else {
                                throw new MatchError((Object)string);
                            }
                            Seq outputs = seq;
                            return Predictions$.MODULE$.apply(outputs, ManifestFactory$.MODULE$.classType(String.class));
                        });
                        function1 = (Function1)MODULE$.timing("cluster serving response complete", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)200), (Object)result.toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller()))));
                    } else if (servable2 instanceof InferenceModelServable) {
                        String result = (String)MODULE$.timing("inference model inference", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{MODULE$.predictRequestTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                            Seq seq;
                            String string = ((InferenceModelMetaData)servable.getMetaData()).inputCompileType();
                            if ("direct".equals(string)) {
                                seq = (Seq)MODULE$.timing("model inference direct", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{modelInferenceTimer}), (Function0 & Serializable & scala.Serializable)() -> servable.predict((String)content));
                            } else if ("instance".equals(string)) {
                                Instances instances = (Instances)MODULE$.timing("json deserialization", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> JsonUtil$.MODULE$.fromJson(Instances.class, (String)content));
                                seq = (Seq)MODULE$.timing("model inference", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{modelInferenceTimer}), (Function0 & Serializable & scala.Serializable)() -> servable.predict(instances));
                            } else {
                                throw new MatchError((Object)string);
                            }
                            Seq outputs = seq;
                            return JsonUtil$.MODULE$.toJson(outputs.map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3.result(), Seq$.MODULE$.canBuildFrom()));
                        });
                        function1 = (Function1)MODULE$.timing("inference model response complete", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)200), (Object)result), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller()))));
                    } else {
                        throw new MatchError((Object)servable2);
                    }
                    standardRoute = function1;
                }
                catch (ModelNotFoundException e) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)404), (Object)new StringBuilder(22).append("Model Not Found. Err: ").append(e.message()).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (ServingRuntimeException e) {
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)405), (Object)new StringBuilder(27).append("Serving Runtime Error Err: ").append(e.message()).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)500), (Object)new StringBuilder(16).append("Internal Error: ").append(e).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1 & Serializable & scala.Serializable)code -> StatusCode$.MODULE$.int2StatusCode(BoxesRunTime.unboxToInt((Object)code)), Marshaller$.MODULE$.StringMarshaller())));
                }
                return standardRoute;
            })))})))));
            if (arguments.httpsEnabled()) {
                MODULE$.isLocalURI(arguments.httpsKeyStorePath());
                ConnectionContext serverContext = MODULE$.defineServerContext(arguments.httpsKeyStoreToken(), arguments.httpsKeyStorePath());
                HttpExt qual$2 = Http$.MODULE$.apply(MODULE$.system());
                Function1 x$4 = route;
                RoutingSettings x$5 = (RoutingSettings)RoutingSettings$.MODULE$.default((ActorRefFactory)MODULE$.system());
                ParserSettings x$6 = (ParserSettings)ParserSettings$.MODULE$.default((ActorRefFactory)MODULE$.system());
                ActorMaterializer x$7 = MODULE$.materializer();
                RoutingLog x$8 = RoutingLog$.MODULE$.fromActorSystem(MODULE$.system());
                ExecutionContextExecutor x$9 = MODULE$.executionContext();
                RejectionHandler x$10 = RouteResult$.MODULE$.route2HandlerFlow$default$7(x$4);
                ExceptionHandler x$11 = RouteResult$.MODULE$.route2HandlerFlow$default$8(x$4);
                Flow x$12 = RouteResult$.MODULE$.route2HandlerFlow(x$4, x$5, x$6, (Materializer)x$7, x$8, (ExecutionContext)x$9, x$10, x$11);
                String x$13 = arguments.interface();
                int x$14 = arguments.securePort();
                ConnectionContext x$15 = serverContext;
                ServerSettings x$16 = qual$2.bindAndHandle$default$5();
                LoggingAdapter x$17 = qual$2.bindAndHandle$default$6();
                qual$2.bindAndHandle(x$12, x$13, x$14, x$15, x$16, x$17, (Materializer)MODULE$.materializer());
                MODULE$.logger().info(new StringBuilder(26).append("https started at https://").append(arguments.interface()).append(":").append(arguments.securePort()).toString());
            }
            HttpExt qual$3 = Http$.MODULE$.apply(MODULE$.system());
            Function1 x$18 = route;
            RoutingSettings x$19 = (RoutingSettings)RoutingSettings$.MODULE$.default((ActorRefFactory)MODULE$.system());
            ParserSettings x$20 = (ParserSettings)ParserSettings$.MODULE$.default((ActorRefFactory)MODULE$.system());
            ActorMaterializer x$21 = MODULE$.materializer();
            RoutingLog x$22 = RoutingLog$.MODULE$.fromActorSystem(MODULE$.system());
            ExecutionContextExecutor x$23 = MODULE$.executionContext();
            RejectionHandler x$24 = RouteResult$.MODULE$.route2HandlerFlow$default$7(x$18);
            ExceptionHandler x$25 = RouteResult$.MODULE$.route2HandlerFlow$default$8(x$18);
            Flow x$26 = RouteResult$.MODULE$.route2HandlerFlow(x$18, x$19, x$20, (Materializer)x$21, x$22, (ExecutionContext)x$23, x$24, x$25);
            String x$27 = arguments.interface();
            int x$28 = arguments.port();
            ConnectionContext x$29 = qual$3.bindAndHandle$default$4();
            ServerSettings x$30 = qual$3.bindAndHandle$default$5();
            LoggingAdapter x$31 = qual$3.bindAndHandle$default$6();
            qual$3.bindAndHandle(x$26, x$27, x$28, x$29, x$30, x$31, (Materializer)MODULE$.materializer());
            MODULE$.logger().info(new StringBuilder(24).append("http started at http://").append(arguments.interface()).append(":").append(arguments.port()).toString());
        });
    }

    public MetricRegistry metrics() {
        return this.metrics;
    }

    public Timer overallRequestTimer() {
        return this.overallRequestTimer;
    }

    public Timer predictRequestTimer() {
        return this.predictRequestTimer;
    }

    public Timer servableRetriveTimer() {
        return this.servableRetriveTimer;
    }

    public Timer servablesRetriveTimer() {
        return this.servablesRetriveTimer;
    }

    public Timer backendInferenceTimer() {
        return this.backendInferenceTimer;
    }

    public Timer putRedisTimer() {
        return this.putRedisTimer;
    }

    public Timer getRedisTimer() {
        return this.getRedisTimer;
    }

    public Timer waitRedisTimer() {
        return this.waitRedisTimer;
    }

    public Timer metricsRequestTimer() {
        return this.metricsRequestTimer;
    }

    public HashMap<String, HashMap<String, Timer>> modelInferenceTimersMap() {
        return this.modelInferenceTimersMap;
    }

    public HashMap<String, HashMap<String, Timer>> purePredictTimersMap() {
        return this.purePredictTimersMap;
    }

    public Timer makeActivityTimer() {
        return this.makeActivityTimer;
    }

    public Timer handleResponseTimer() {
        return this.handleResponseTimer;
    }

    public JacksonJsonSerializer jacksonJsonSerializer() {
        return this.jacksonJsonSerializer;
    }

    public OptionParser<FrontEndAppArguments> argumentsParser() {
        return this.argumentsParser;
    }

    public ConnectionContext defineServerContext(String httpsKeyStoreToken, String httpsKeyStorePath) {
        char[] token = httpsKeyStoreToken.toCharArray();
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        InputStream keystoreInputStream = new File(httpsKeyStorePath).toURI().toURL().openStream();
        Log4Error$.MODULE$.invalidOperationError(keystoreInputStream != null, "Keystore required!", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        keyStore.load(keystoreInputStream, token);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, token);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return ConnectionContext$.MODULE$.https(sslContext, ConnectionContext$.MODULE$.https$default$2(), ConnectionContext$.MODULE$.https$default$3(), ConnectionContext$.MODULE$.https$default$4(), ConnectionContext$.MODULE$.https$default$5(), ConnectionContext$.MODULE$.https$default$6());
    }

    private FrontEndApp$() {
        MODULE$ = this;
        Supportive.$init$(this);
        EncryptSupportive.$init$((EncryptSupportive)this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.name = "BigDL web serving frontend";
        this.system = ActorSystem$.MODULE$.apply("bigdl-serving-frontend-system");
        this.materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)this.system());
        this.executionContext = this.system().dispatcher();
        this.timeout = Timeout$.MODULE$.apply(100L, TimeUnit.SECONDS);
        this.metrics = new MetricRegistry();
        this.overallRequestTimer = this.metrics().timer("bigdl.serving.request.overall");
        this.predictRequestTimer = this.metrics().timer("bigdl.serving.request.predict");
        this.servableRetriveTimer = this.metrics().timer("bigdl.serving.retrive.servable");
        this.servablesRetriveTimer = this.metrics().timer("bigdl.serving.retrive.servables");
        this.backendInferenceTimer = this.metrics().timer("bigdl.serving.backend.inference");
        this.putRedisTimer = this.metrics().timer("bigdl.serving.redis.put");
        this.getRedisTimer = this.metrics().timer("bigdl.serving.redis.get");
        this.waitRedisTimer = this.metrics().timer("bigdl.serving.redis.wait");
        this.metricsRequestTimer = this.metrics().timer("bigdl.serving.request.metrics");
        this.modelInferenceTimersMap = new HashMap();
        this.purePredictTimersMap = new HashMap();
        this.makeActivityTimer = this.metrics().timer("bigdl.serving.activity.make");
        this.handleResponseTimer = this.metrics().timer("bigdl.serving.response.handling");
        this.jacksonJsonSerializer = new JacksonJsonSerializer();
        this.argumentsParser = new OptionParser<FrontEndAppArguments>(){

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$2(int x, FrontEndAppArguments c) {
                int x$1 = x;
                String x$2 = c.copy$default$1();
                int x$3 = c.copy$default$3();
                String x$4 = c.copy$default$4();
                int x$5 = c.copy$default$5();
                String x$6 = c.copy$default$6();
                String x$7 = c.copy$default$7();
                int x$8 = c.copy$default$8();
                int x$9 = c.copy$default$9();
                int x$10 = c.copy$default$10();
                boolean x$11 = c.copy$default$11();
                int x$12 = c.copy$default$12();
                int x$13 = c.copy$default$13();
                boolean x$14 = c.copy$default$14();
                String x$15 = c.copy$default$15();
                String x$16 = c.copy$default$16();
                boolean x$17 = c.copy$default$17();
                String x$18 = c.copy$default$18();
                String x$19 = c.copy$default$19();
                String x$20 = c.copy$default$20();
                return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$3(int x, FrontEndAppArguments c) {
                int x$21 = x;
                String x$22 = c.copy$default$1();
                int x$23 = c.copy$default$2();
                String x$24 = c.copy$default$4();
                int x$25 = c.copy$default$5();
                String x$26 = c.copy$default$6();
                String x$27 = c.copy$default$7();
                int x$28 = c.copy$default$8();
                int x$29 = c.copy$default$9();
                int x$30 = c.copy$default$10();
                boolean x$31 = c.copy$default$11();
                int x$32 = c.copy$default$12();
                int x$33 = c.copy$default$13();
                boolean x$34 = c.copy$default$14();
                String x$35 = c.copy$default$15();
                String x$36 = c.copy$default$16();
                boolean x$37 = c.copy$default$17();
                String x$38 = c.copy$default$18();
                String x$39 = c.copy$default$19();
                String x$40 = c.copy$default$20();
                return c.copy(x$22, x$23, x$21, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$5(int x, FrontEndAppArguments c) {
                int x$61 = x;
                String x$62 = c.copy$default$1();
                int x$63 = c.copy$default$2();
                int x$64 = c.copy$default$3();
                String x$65 = c.copy$default$4();
                String x$66 = c.copy$default$6();
                String x$67 = c.copy$default$7();
                int x$68 = c.copy$default$8();
                int x$69 = c.copy$default$9();
                int x$70 = c.copy$default$10();
                boolean x$71 = c.copy$default$11();
                int x$72 = c.copy$default$12();
                int x$73 = c.copy$default$13();
                boolean x$74 = c.copy$default$14();
                String x$75 = c.copy$default$15();
                String x$76 = c.copy$default$16();
                boolean x$77 = c.copy$default$17();
                String x$78 = c.copy$default$18();
                String x$79 = c.copy$default$19();
                String x$80 = c.copy$default$20();
                return c.copy(x$62, x$63, x$64, x$65, x$61, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$8(int x, FrontEndAppArguments c) {
                int x$121 = x;
                String x$122 = c.copy$default$1();
                int x$123 = c.copy$default$2();
                int x$124 = c.copy$default$3();
                String x$125 = c.copy$default$4();
                int x$126 = c.copy$default$5();
                String x$127 = c.copy$default$6();
                String x$128 = c.copy$default$7();
                int x$129 = c.copy$default$9();
                int x$130 = c.copy$default$10();
                boolean x$131 = c.copy$default$11();
                int x$132 = c.copy$default$12();
                int x$133 = c.copy$default$13();
                boolean x$134 = c.copy$default$14();
                String x$135 = c.copy$default$15();
                String x$136 = c.copy$default$16();
                boolean x$137 = c.copy$default$17();
                String x$138 = c.copy$default$18();
                String x$139 = c.copy$default$19();
                String x$140 = c.copy$default$20();
                return c.copy(x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$121, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$9(int x, FrontEndAppArguments c) {
                int x$141 = x;
                String x$142 = c.copy$default$1();
                int x$143 = c.copy$default$2();
                int x$144 = c.copy$default$3();
                String x$145 = c.copy$default$4();
                int x$146 = c.copy$default$5();
                String x$147 = c.copy$default$6();
                String x$148 = c.copy$default$7();
                int x$149 = c.copy$default$8();
                int x$150 = c.copy$default$10();
                boolean x$151 = c.copy$default$11();
                int x$152 = c.copy$default$12();
                int x$153 = c.copy$default$13();
                boolean x$154 = c.copy$default$14();
                String x$155 = c.copy$default$15();
                String x$156 = c.copy$default$16();
                boolean x$157 = c.copy$default$17();
                String x$158 = c.copy$default$18();
                String x$159 = c.copy$default$19();
                String x$160 = c.copy$default$20();
                return c.copy(x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$141, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$10(int x, FrontEndAppArguments c) {
                int x$161 = x;
                String x$162 = c.copy$default$1();
                int x$163 = c.copy$default$2();
                int x$164 = c.copy$default$3();
                String x$165 = c.copy$default$4();
                int x$166 = c.copy$default$5();
                String x$167 = c.copy$default$6();
                String x$168 = c.copy$default$7();
                int x$169 = c.copy$default$8();
                int x$170 = c.copy$default$9();
                boolean x$171 = c.copy$default$11();
                int x$172 = c.copy$default$12();
                int x$173 = c.copy$default$13();
                boolean x$174 = c.copy$default$14();
                String x$175 = c.copy$default$15();
                String x$176 = c.copy$default$16();
                boolean x$177 = c.copy$default$17();
                String x$178 = c.copy$default$18();
                String x$179 = c.copy$default$19();
                String x$180 = c.copy$default$20();
                return c.copy(x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$161, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$11(boolean x, FrontEndAppArguments c) {
                boolean x$181 = x;
                String x$182 = c.copy$default$1();
                int x$183 = c.copy$default$2();
                int x$184 = c.copy$default$3();
                String x$185 = c.copy$default$4();
                int x$186 = c.copy$default$5();
                String x$187 = c.copy$default$6();
                String x$188 = c.copy$default$7();
                int x$189 = c.copy$default$8();
                int x$190 = c.copy$default$9();
                int x$191 = c.copy$default$10();
                int x$192 = c.copy$default$12();
                int x$193 = c.copy$default$13();
                boolean x$194 = c.copy$default$14();
                String x$195 = c.copy$default$15();
                String x$196 = c.copy$default$16();
                boolean x$197 = c.copy$default$17();
                String x$198 = c.copy$default$18();
                String x$199 = c.copy$default$19();
                String x$200 = c.copy$default$20();
                return c.copy(x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$190, x$191, x$181, x$192, x$193, x$194, x$195, x$196, x$197, x$198, x$199, x$200);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$12(int x, FrontEndAppArguments c) {
                int x$201 = x;
                String x$202 = c.copy$default$1();
                int x$203 = c.copy$default$2();
                int x$204 = c.copy$default$3();
                String x$205 = c.copy$default$4();
                int x$206 = c.copy$default$5();
                String x$207 = c.copy$default$6();
                String x$208 = c.copy$default$7();
                int x$209 = c.copy$default$8();
                int x$210 = c.copy$default$9();
                int x$211 = c.copy$default$10();
                boolean x$212 = c.copy$default$11();
                int x$213 = c.copy$default$13();
                boolean x$214 = c.copy$default$14();
                String x$215 = c.copy$default$15();
                String x$216 = c.copy$default$16();
                boolean x$217 = c.copy$default$17();
                String x$218 = c.copy$default$18();
                String x$219 = c.copy$default$19();
                String x$220 = c.copy$default$20();
                return c.copy(x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, x$212, x$201, x$213, x$214, x$215, x$216, x$217, x$218, x$219, x$220);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$13(int x, FrontEndAppArguments c) {
                int x$221 = x;
                String x$222 = c.copy$default$1();
                int x$223 = c.copy$default$2();
                int x$224 = c.copy$default$3();
                String x$225 = c.copy$default$4();
                int x$226 = c.copy$default$5();
                String x$227 = c.copy$default$6();
                String x$228 = c.copy$default$7();
                int x$229 = c.copy$default$8();
                int x$230 = c.copy$default$9();
                int x$231 = c.copy$default$10();
                boolean x$232 = c.copy$default$11();
                int x$233 = c.copy$default$12();
                boolean x$234 = c.copy$default$14();
                String x$235 = c.copy$default$15();
                String x$236 = c.copy$default$16();
                boolean x$237 = c.copy$default$17();
                String x$238 = c.copy$default$18();
                String x$239 = c.copy$default$19();
                String x$240 = c.copy$default$20();
                return c.copy(x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$231, x$232, x$233, x$221, x$234, x$235, x$236, x$237, x$238, x$239, x$240);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$14(boolean x, FrontEndAppArguments c) {
                boolean x$241 = x;
                String x$242 = c.copy$default$1();
                int x$243 = c.copy$default$2();
                int x$244 = c.copy$default$3();
                String x$245 = c.copy$default$4();
                int x$246 = c.copy$default$5();
                String x$247 = c.copy$default$6();
                String x$248 = c.copy$default$7();
                int x$249 = c.copy$default$8();
                int x$250 = c.copy$default$9();
                int x$251 = c.copy$default$10();
                boolean x$252 = c.copy$default$11();
                int x$253 = c.copy$default$12();
                int x$254 = c.copy$default$13();
                String x$255 = c.copy$default$15();
                String x$256 = c.copy$default$16();
                boolean x$257 = c.copy$default$17();
                String x$258 = c.copy$default$18();
                String x$259 = c.copy$default$19();
                String x$260 = c.copy$default$20();
                return c.copy(x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$250, x$251, x$252, x$253, x$254, x$241, x$255, x$256, x$257, x$258, x$259, x$260);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$17(boolean x, FrontEndAppArguments c) {
                boolean x$301 = x;
                String x$302 = c.copy$default$1();
                int x$303 = c.copy$default$2();
                int x$304 = c.copy$default$3();
                String x$305 = c.copy$default$4();
                int x$306 = c.copy$default$5();
                String x$307 = c.copy$default$6();
                String x$308 = c.copy$default$7();
                int x$309 = c.copy$default$8();
                int x$310 = c.copy$default$9();
                int x$311 = c.copy$default$10();
                boolean x$312 = c.copy$default$11();
                int x$313 = c.copy$default$12();
                int x$314 = c.copy$default$13();
                boolean x$315 = c.copy$default$14();
                String x$316 = c.copy$default$15();
                String x$317 = c.copy$default$16();
                String x$318 = c.copy$default$18();
                String x$319 = c.copy$default$19();
                String x$320 = c.copy$default$20();
                return c.copy(x$302, x$303, x$304, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$312, x$313, x$314, x$315, x$316, x$317, x$301, x$318, x$319, x$320);
            }

            public static final /* synthetic */ FrontEndAppArguments $anonfun$new$18(boolean x, FrontEndAppArguments c) {
                boolean x$321 = x;
                String x$322 = c.copy$default$1();
                int x$323 = c.copy$default$2();
                int x$324 = c.copy$default$3();
                String x$325 = c.copy$default$4();
                int x$326 = c.copy$default$5();
                String x$327 = c.copy$default$6();
                String x$328 = c.copy$default$7();
                int x$329 = c.copy$default$8();
                int x$330 = c.copy$default$9();
                int x$331 = c.copy$default$10();
                boolean x$332 = c.copy$default$11();
                int x$333 = c.copy$default$12();
                int x$334 = c.copy$default$13();
                String x$335 = c.copy$default$15();
                String x$336 = c.copy$default$16();
                boolean x$337 = c.copy$default$17();
                String x$338 = c.copy$default$18();
                String x$339 = c.copy$default$19();
                String x$340 = c.copy$default$20();
                return c.copy(x$322, x$323, x$324, x$325, x$326, x$327, x$328, x$329, x$330, x$331, x$332, x$333, x$334, x$321, x$335, x$336, x$337, x$338, x$339, x$340);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BigDL Serving Frontend"}));
                this.opt('i', "interface", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15(), c.copy$default$16(), c.copy$default$17(), c.copy$default$18(), c.copy$default$19(), c.copy$default$20())).text("network interface of frontend");
                this.opt('p', "port", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c)).text("network port of frontend");
                this.opt('s', "securePort", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c)).text("https port of frontend");
                this.opt('h', "redisHost", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$41 = x;
                    String x$42 = c.copy$default$1();
                    int x$43 = c.copy$default$2();
                    int x$44 = c.copy$default$3();
                    int x$45 = c.copy$default$5();
                    String x$46 = c.copy$default$6();
                    String x$47 = c.copy$default$7();
                    int x$48 = c.copy$default$8();
                    int x$49 = c.copy$default$9();
                    int x$50 = c.copy$default$10();
                    boolean x$51 = c.copy$default$11();
                    int x$52 = c.copy$default$12();
                    int x$53 = c.copy$default$13();
                    boolean x$54 = c.copy$default$14();
                    String x$55 = c.copy$default$15();
                    String x$56 = c.copy$default$16();
                    boolean x$57 = c.copy$default$17();
                    String x$58 = c.copy$default$18();
                    String x$59 = c.copy$default$19();
                    String x$60 = c.copy$default$20();
                    return c.copy(x$42, x$43, x$44, x$41, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
                }).text("host of redis");
                this.opt('r', "redisPort", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x), c)).text("port of redis");
                this.opt('i', "redisInputQueue", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$81 = x;
                    String x$82 = c.copy$default$1();
                    int x$83 = c.copy$default$2();
                    int x$84 = c.copy$default$3();
                    String x$85 = c.copy$default$4();
                    int x$86 = c.copy$default$5();
                    String x$87 = c.copy$default$7();
                    int x$88 = c.copy$default$8();
                    int x$89 = c.copy$default$9();
                    int x$90 = c.copy$default$10();
                    boolean x$91 = c.copy$default$11();
                    int x$92 = c.copy$default$12();
                    int x$93 = c.copy$default$13();
                    boolean x$94 = c.copy$default$14();
                    String x$95 = c.copy$default$15();
                    String x$96 = c.copy$default$16();
                    boolean x$97 = c.copy$default$17();
                    String x$98 = c.copy$default$18();
                    String x$99 = c.copy$default$19();
                    String x$100 = c.copy$default$20();
                    return c.copy(x$82, x$83, x$84, x$85, x$86, x$81, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100);
                }).text("input queue of redis");
                this.opt('o', "redisOutputQueue", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$101 = x;
                    String x$102 = c.copy$default$1();
                    int x$103 = c.copy$default$2();
                    int x$104 = c.copy$default$3();
                    String x$105 = c.copy$default$4();
                    int x$106 = c.copy$default$5();
                    String x$107 = c.copy$default$6();
                    int x$108 = c.copy$default$8();
                    int x$109 = c.copy$default$9();
                    int x$110 = c.copy$default$10();
                    boolean x$111 = c.copy$default$11();
                    int x$112 = c.copy$default$12();
                    int x$113 = c.copy$default$13();
                    boolean x$114 = c.copy$default$14();
                    String x$115 = c.copy$default$15();
                    String x$116 = c.copy$default$16();
                    boolean x$117 = c.copy$default$17();
                    String x$118 = c.copy$default$18();
                    String x$119 = c.copy$default$19();
                    String x$120 = c.copy$default$20();
                    return c.copy(x$102, x$103, x$104, x$105, x$106, x$107, x$101, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120);
                }).text("output queue  of redis");
                this.opt('l', "parallelism", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)x), c)).text("parallelism of frontend");
                this.opt('t', "timeWindow", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x), c)).text("timeWindow of frontend");
                this.opt('c', "countWindow", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$10(BoxesRunTime.unboxToInt((Object)x), c)).text("countWindow of frontend");
                this.opt('e', "tokenBucketEnabled", Read$.MODULE$.booleanRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$11(BoxesRunTime.unboxToBoolean((Object)x), c)).text("Token Bucket Enabled or not");
                this.opt('k', "tokensPerSecond", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$12(BoxesRunTime.unboxToInt((Object)x), c)).text("tokens per second");
                this.opt('a', "tokenAcquireTimeout", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)x), c)).text("token acquire timeout");
                this.opt('s', "httpsEnabled", Read$.MODULE$.booleanRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$14(BoxesRunTime.unboxToBoolean((Object)x), c)).text("https enabled or not");
                this.opt('p', "httpsKeyStorePath", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$261 = x;
                    String x$262 = c.copy$default$1();
                    int x$263 = c.copy$default$2();
                    int x$264 = c.copy$default$3();
                    String x$265 = c.copy$default$4();
                    int x$266 = c.copy$default$5();
                    String x$267 = c.copy$default$6();
                    String x$268 = c.copy$default$7();
                    int x$269 = c.copy$default$8();
                    int x$270 = c.copy$default$9();
                    int x$271 = c.copy$default$10();
                    boolean x$272 = c.copy$default$11();
                    int x$273 = c.copy$default$12();
                    int x$274 = c.copy$default$13();
                    boolean x$275 = c.copy$default$14();
                    String x$276 = c.copy$default$16();
                    boolean x$277 = c.copy$default$17();
                    String x$278 = c.copy$default$18();
                    String x$279 = c.copy$default$19();
                    String x$280 = c.copy$default$20();
                    return c.copy(x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, x$270, x$271, x$272, x$273, x$274, x$275, x$261, x$276, x$277, x$278, x$279, x$280);
                }).text("https keyStore path");
                this.opt('w', "httpsKeyStoreToken", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$281 = x;
                    String x$282 = c.copy$default$1();
                    int x$283 = c.copy$default$2();
                    int x$284 = c.copy$default$3();
                    String x$285 = c.copy$default$4();
                    int x$286 = c.copy$default$5();
                    String x$287 = c.copy$default$6();
                    String x$288 = c.copy$default$7();
                    int x$289 = c.copy$default$8();
                    int x$290 = c.copy$default$9();
                    int x$291 = c.copy$default$10();
                    boolean x$292 = c.copy$default$11();
                    int x$293 = c.copy$default$12();
                    int x$294 = c.copy$default$13();
                    boolean x$295 = c.copy$default$14();
                    String x$296 = c.copy$default$15();
                    boolean x$297 = c.copy$default$17();
                    String x$298 = c.copy$default$18();
                    String x$299 = c.copy$default$19();
                    String x$300 = c.copy$default$20();
                    return c.copy(x$282, x$283, x$284, x$285, x$286, x$287, x$288, x$289, x$290, x$291, x$292, x$293, x$294, x$295, x$296, x$281, x$297, x$298, x$299, x$300);
                }).text("https keyStore token");
                this.opt('s', "redisSecureEnabled", Read$.MODULE$.booleanRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$17(BoxesRunTime.unboxToBoolean((Object)x), c)).text("redis secure enabled or not");
                this.opt('s', "httpsEnabled", Read$.MODULE$.booleanRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$18(BoxesRunTime.unboxToBoolean((Object)x), c)).text("https enabled or not");
                this.opt('p', "redissTrustStorePath", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$341 = x;
                    String x$342 = c.copy$default$1();
                    int x$343 = c.copy$default$2();
                    int x$344 = c.copy$default$3();
                    String x$345 = c.copy$default$4();
                    int x$346 = c.copy$default$5();
                    String x$347 = c.copy$default$6();
                    String x$348 = c.copy$default$7();
                    int x$349 = c.copy$default$8();
                    int x$350 = c.copy$default$9();
                    int x$351 = c.copy$default$10();
                    boolean x$352 = c.copy$default$11();
                    int x$353 = c.copy$default$12();
                    int x$354 = c.copy$default$13();
                    boolean x$355 = c.copy$default$14();
                    String x$356 = c.copy$default$15();
                    String x$357 = c.copy$default$16();
                    boolean x$358 = c.copy$default$17();
                    String x$359 = c.copy$default$19();
                    String x$360 = c.copy$default$20();
                    return c.copy(x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$352, x$353, x$354, x$355, x$356, x$357, x$358, x$341, x$359, x$360);
                }).text("rediss trustStore path");
                this.opt('w', "redissTrustStoreToken", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$361 = x;
                    String x$362 = c.copy$default$1();
                    int x$363 = c.copy$default$2();
                    int x$364 = c.copy$default$3();
                    String x$365 = c.copy$default$4();
                    int x$366 = c.copy$default$5();
                    String x$367 = c.copy$default$6();
                    String x$368 = c.copy$default$7();
                    int x$369 = c.copy$default$8();
                    int x$370 = c.copy$default$9();
                    int x$371 = c.copy$default$10();
                    boolean x$372 = c.copy$default$11();
                    int x$373 = c.copy$default$12();
                    int x$374 = c.copy$default$13();
                    boolean x$375 = c.copy$default$14();
                    String x$376 = c.copy$default$15();
                    String x$377 = c.copy$default$16();
                    boolean x$378 = c.copy$default$17();
                    String x$379 = c.copy$default$18();
                    String x$380 = c.copy$default$20();
                    return c.copy(x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$371, x$372, x$373, x$374, x$375, x$376, x$377, x$378, x$379, x$361, x$380);
                }).text("rediss trustStore password");
                this.opt('z', "servableManagerConfPath", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$381 = x;
                    String x$382 = c.copy$default$1();
                    int x$383 = c.copy$default$2();
                    int x$384 = c.copy$default$3();
                    String x$385 = c.copy$default$4();
                    int x$386 = c.copy$default$5();
                    String x$387 = c.copy$default$6();
                    String x$388 = c.copy$default$7();
                    int x$389 = c.copy$default$8();
                    int x$390 = c.copy$default$9();
                    int x$391 = c.copy$default$10();
                    boolean x$392 = c.copy$default$11();
                    int x$393 = c.copy$default$12();
                    int x$394 = c.copy$default$13();
                    boolean x$395 = c.copy$default$14();
                    String x$396 = c.copy$default$15();
                    String x$397 = c.copy$default$16();
                    boolean x$398 = c.copy$default$17();
                    String x$399 = c.copy$default$18();
                    String x$400 = c.copy$default$19();
                    return c.copy(x$382, x$383, x$384, x$385, x$386, x$387, x$388, x$389, x$390, x$391, x$392, x$393, x$394, x$395, x$396, x$397, x$398, x$399, x$400, x$381);
                }).text("servableManagerConfPath");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$2$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$3$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$4(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$5$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$6(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$7(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$8$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$9$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$10$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$11$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$12$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$13$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$14$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$15(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$16(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$17$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$18$adapted(java.lang.Object com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$19(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$20(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments ), $anonfun$new$21(java.lang.String com.intel.analytics.bigdl.serving.http.FrontEndAppArguments )}, serializedLambda);
            }
        };
    }
}

