/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.serving.http;

import com.codahale.metrics.Timer;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.orca.inference.InferenceModel;
import com.intel.analytics.bigdl.orca.inference.JTensor;
import com.intel.analytics.bigdl.serving.http.FrontEndApp$;
import com.intel.analytics.bigdl.serving.http.InferenceModelMetaData;
import com.intel.analytics.bigdl.serving.http.Instances;
import com.intel.analytics.bigdl.serving.http.JsonInputDomainDeser$;
import com.intel.analytics.bigdl.serving.http.PredictionOutput;
import com.intel.analytics.bigdl.serving.http.Servable;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001\u0002\t\u0012\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!)\u0001\u0007\u0001C\u0001c!9Q\u0007\u0001b\u0001\n\u00031\u0004BB \u0001A\u0003%q\u0007C\u0005A\u0001\u0001\u0007\t\u0019!C\u0001\u0003\"I!\n\u0001a\u0001\u0002\u0004%\ta\u0013\u0005\n)\u0002\u0001\r\u0011!Q!\n\tCq!\u0016\u0001A\u0002\u0013\u0005a\u000bC\u0004[\u0001\u0001\u0007I\u0011A.\t\ru\u0003\u0001\u0015)\u0003X\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015\u0001\u0007\u0001\"\u0001\u007f\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000b\u0011a#\u00138gKJ,gnY3N_\u0012,GnU3sm\u0006\u0014G.\u001a\u0006\u0003%M\tA\u0001\u001b;ua*\u0011A#F\u0001\bg\u0016\u0014h/\u001b8h\u0015\t1r#A\u0003cS\u001e$GN\u0003\u0002\u00193\u0005I\u0011M\\1msRL7m\u001d\u0006\u00035m\tQ!\u001b8uK2T\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0011\u000e\u0003EI!AI\t\u0003\u0011M+'O^1cY\u0016\fa#\u001b8gKJ,gnY3N_\u0012,G.T3uC\u0012\u000bG/\u0019\t\u0003A\u0015J!AJ\t\u0003-%sg-\u001a:f]\u000e,Wj\u001c3fY6+G/\u0019#bi\u0006\f\u0001\u0003];sKB\u0013X\rZ5diRKW.\u001a:\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013aB7fiJL7m\u001d\u0006\u0003[m\t\u0001bY8eC\"\fG.Z\u0005\u0003_)\u0012Q\u0001V5nKJ\fa\u0001P5oSRtDc\u0001\u001a4iA\u0011\u0001\u0005\u0001\u0005\u0006G\r\u0001\r\u0001\n\u0005\u0006O\r\u0001\r\u0001K\u0001\u0007Y><w-\u001a:\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000bMdg\r\u000e6\u000b\u0003q\n1a\u001c:h\u0013\tq\u0014H\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0015iw\u000eZ3m+\u0005\u0011\u0005CA\"I\u001b\u0005!%BA#G\u0003%IgNZ3sK:\u001cWM\u0003\u0002H+\u0005!qN]2b\u0013\tIEI\u0001\bJ]\u001a,'/\u001a8dK6{G-\u001a7\u0002\u00135|G-\u001a7`I\u0015\fHC\u0001'S!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0011)f.\u001b;\t\u000fM;\u0011\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\u0002\r5|G-\u001a7!\u0003II7OR5sgR$\u0016.\\3Qe\u0016$\u0017n\u0019;\u0016\u0003]\u0003\"!\u0014-\n\u0005es%a\u0002\"p_2,\u0017M\\\u0001\u0017SN4\u0015N]:u)&lW\r\u0015:fI&\u001cGo\u0018\u0013fcR\u0011A\n\u0018\u0005\b'*\t\t\u00111\u0001X\u0003MI7OR5sgR$\u0016.\\3Qe\u0016$\u0017n\u0019;!\u0003\u0011aw.\u00193\u0015\u00031\u000bq\u0001\u001d:fI&\u001cG\u000f\u0006\u0002csB\u00191m\u001b8\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4\u001e\u0003\u0019a$o\\8u}%\tq*\u0003\u0002k\u001d\u00069\u0001/Y2lC\u001e,\u0017B\u00017n\u0005\r\u0019V-\u001d\u0006\u0003U:\u00032\u0001I8r\u0013\t\u0001\u0018C\u0001\tQe\u0016$\u0017n\u0019;j_:|U\u000f\u001e9viB\u0011!O\u001e\b\u0003gR\u0004\"!\u001a(\n\u0005Ut\u0015A\u0002)sK\u0012,g-\u0003\u0002xq\n11\u000b\u001e:j]\u001eT!!\u001e(\t\u000bil\u0001\u0019A>\u0002\r%t\u0007/\u001e;t!\t\u0001C0\u0003\u0002~#\tI\u0011J\\:uC:\u001cWm\u001d\u000b\u0003E~Da!!\u0001\u000f\u0001\u0004\t\u0018!B5oaV$\u0018A\u0004;f]N|'\u000fV8TiJLgn\u001a\u000b\u0004c\u0006\u001d\u0001bBA\u0005\u001f\u0001\u0007\u00111B\u0001\u0007i\u0016t7o\u001c:\u0011\r\u00055\u0011QCA\r\u001b\t\tyA\u0003\u0003\u0002\n\u0005E!bAA\n+\u0005)A\r\u001c7jE&!\u0011qCA\b\u0005\u0019!VM\\:peB\u0019Q*a\u0007\n\u0007\u0005uaJA\u0003GY>\fG\u000f")
public class InferenceModelServable
extends Servable {
    private final InferenceModelMetaData inferenceModelMetaData;
    private final Timer purePredictTimer;
    private final Logger logger;
    private InferenceModel model;
    private boolean isFirstTimePredict;

    public Logger logger() {
        return this.logger;
    }

    public InferenceModel model() {
        return this.model;
    }

    public void model_$eq(InferenceModel x$1) {
        this.model = x$1;
    }

    public boolean isFirstTimePredict() {
        return this.isFirstTimePredict;
    }

    public void isFirstTimePredict_$eq(boolean x$1) {
        this.isFirstTimePredict = x$1;
    }

    @Override
    public void load() {
        this.model_$eq(new InferenceModel(this.inferenceModelMetaData.modelConCurrentNum()));
        String string = this.inferenceModelMetaData.modelType();
        if ("OpenVINO".equals(string)) {
            InferenceModel qual$1 = this.model();
            String x$1 = this.inferenceModelMetaData.modelPath();
            String x$2 = this.inferenceModelMetaData.weightPath();
            int x$3 = qual$1.doLoadOpenVINO$default$3();
            qual$1.doLoadOpenVINO(x$1, x$2, x$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("tf.frozenModel".equals(string)) {
            this.model().doLoadTensorflow(this.inferenceModelMetaData.modelPath(), "frozenModel");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("BigDL".equals(string)) {
            InferenceModel qual$2 = this.model();
            String x$4 = this.inferenceModelMetaData.modelPath();
            String x$5 = this.inferenceModelMetaData.weightPath();
            boolean x$6 = qual$2.doLoadBigDL$default$3();
            qual$2.doLoadBigDL(x$4, x$5, x$6);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("Caffe".equals(string)) {
            InferenceModel qual$3 = this.model();
            String x$7 = this.inferenceModelMetaData.modelPath();
            String x$8 = this.inferenceModelMetaData.weightPath();
            boolean x$9 = qual$3.doLoadCaffe$default$3();
            qual$3.doLoadCaffe(x$7, x$8, x$9);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("PyTorch".equals(string)) {
            this.model().doLoadPyTorch(this.inferenceModelMetaData.modelPath());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)string);
        }
        this.logger().info(new StringBuilder(29).append("model loaded successfully as ").append(this.model()).toString());
    }

    @Override
    public Seq<PredictionOutput<String>> predict(Instances inputs) {
        this.logger().info("inference model predict as instance");
        Seq activities = (Seq)FrontEndApp$.MODULE$.timing("activity make", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{FrontEndApp$.MODULE$.makeActivityTimer()}), (Function0 & Serializable & scala.Serializable)() -> inputs.makeActivities($this.inferenceModelMetaData.features()));
        return (Seq)activities.map((Function1 & Serializable & scala.Serializable)activity -> {
            Activity result = this.isFirstTimePredict() ? (Activity)FrontEndApp$.MODULE$.timing("model first predict", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
                this.isFirstTimePredict_$eq(false);
                return this.model().doPredict(activity);
            }) : (Activity)FrontEndApp$.MODULE$.timing("model predict", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{$this.purePredictTimer}), (Function0 & Serializable & scala.Serializable)() -> this.model().doPredict(activity));
            return (PredictionOutput)FrontEndApp$.MODULE$.timing("handle response", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{FrontEndApp$.MODULE$.handleResponseTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                String responses = this.tensorToString((Tensor<Object>)result.toTensor((TensorNumericMath.TensorNumeric)TensorNumericMath.TensorNumeric$.NumericFloat$.MODULE$));
                return new PredictionOutput<String>("", responses);
            });
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<PredictionOutput<String>> predict(String input) {
        this.logger().info("inference model predict as string");
        Seq activities = (Seq)FrontEndApp$.MODULE$.timing("activity make", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{FrontEndApp$.MODULE$.makeActivityTimer()}), (Function0 & Serializable & scala.Serializable)() -> JsonInputDomainDeser$.MODULE$.deserialize(input));
        return (Seq)activities.map((Function1 & Serializable & scala.Serializable)activity -> {
            Activity result = this.isFirstTimePredict() ? (Activity)FrontEndApp$.MODULE$.timing("model first predict", (Seq<Timer>)Nil$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
                this.isFirstTimePredict_$eq(false);
                return this.model().doPredict(activity);
            }) : (Activity)FrontEndApp$.MODULE$.timing("model predict", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{$this.purePredictTimer}), (Function0 & Serializable & scala.Serializable)() -> this.model().doPredict(activity));
            return (PredictionOutput)FrontEndApp$.MODULE$.timing("handle response", (Seq<Timer>)Predef$.MODULE$.wrapRefArray((Object[])new Timer[]{FrontEndApp$.MODULE$.handleResponseTimer()}), (Function0 & Serializable & scala.Serializable)() -> {
                String responses = this.tensorToString((Tensor<Object>)result.toTensor((TensorNumericMath.TensorNumeric)TensorNumericMath.TensorNumeric$.NumericFloat$.MODULE$));
                return new PredictionOutput<String>("", responses);
            });
        }, Seq$.MODULE$.canBuildFrom());
    }

    private String tensorToString(Tensor<Object> tensor) {
        int[] outputShape = tensor.size();
        JTensor jTensor = new JTensor((float[])tensor.storage().array(), outputShape, false);
        return new StringBuilder(20).append("{ \"data\":").append(new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(jTensor.getData())).mkString(",")).append(", \"shape\":").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(jTensor.getShape())).mkString(",")).append("}").toString();
    }

    public InferenceModelServable(InferenceModelMetaData inferenceModelMetaData, Timer purePredictTimer) {
        this.inferenceModelMetaData = inferenceModelMetaData;
        this.purePredictTimer = purePredictTimer;
        super(inferenceModelMetaData);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.isFirstTimePredict = true;
    }
}

