/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.serving.http;

import com.codahale.metrics.Timer;
import com.intel.analytics.bigdl.serving.http.ClusterServingMetaData;
import com.intel.analytics.bigdl.serving.http.ClusterServingServable;
import com.intel.analytics.bigdl.serving.http.FrontEndApp$;
import com.intel.analytics.bigdl.serving.http.InferenceModelMetaData;
import com.intel.analytics.bigdl.serving.http.InferenceModelServable;
import com.intel.analytics.bigdl.serving.http.ModelMetaData;
import com.intel.analytics.bigdl.serving.http.ModelNotFoundException;
import com.intel.analytics.bigdl.serving.http.Servable;
import com.intel.analytics.bigdl.serving.http.ServableLoadException;
import com.intel.analytics.bigdl.serving.http.ServableManagerConf;
import com.intel.analytics.bigdl.serving.http.YamlUtil$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0003\u0006\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001a\u0001\n\u0013\u0019\u0003bB\u001e\u0001\u0001\u0004%I\u0001\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u0013\t\u000b\r\u0003A\u0011\u0001#\t\u000bU\u0003A\u0011\u0001,\t\u000b\u0001\u0004A\u0011A1\t\u000b\u0011\u0004A\u0011A3\u0003\u001fM+'O^1cY\u0016l\u0015M\\1hKJT!a\u0003\u0007\u0002\t!$H\u000f\u001d\u0006\u0003\u001b9\tqa]3sm&twM\u0003\u0002\u0010!\u0005)!-[4eY*\u0011\u0011CE\u0001\nC:\fG.\u001f;jGNT!a\u0005\u000b\u0002\u000b%tG/\u001a7\u000b\u0003U\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!\"A\bn_\u0012,GNV3sg&|g.T1q+\u0005!\u0003\u0003B\u0013+Y]j\u0011A\n\u0006\u0003O!\nq!\\;uC\ndWM\u0003\u0002*5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-2#a\u0002%bg\"l\u0015\r\u001d\t\u0003[Qr!A\f\u001a\u0011\u0005=RR\"\u0001\u0019\u000b\u0005E2\u0012A\u0002\u001fs_>$h(\u0003\u000245\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019$\u0004\u0005\u0003&U1B\u0004CA\u0011:\u0013\tQ$B\u0001\u0005TKJ4\u0018M\u00197f\u0003Miw\u000eZ3m-\u0016\u00148/[8o\u001b\u0006\u0004x\fJ3r)\ti\u0004\t\u0005\u0002\u001a}%\u0011qH\u0007\u0002\u0005+:LG\u000fC\u0004B\u0007\u0005\u0005\t\u0019\u0001\u0013\u0002\u0007a$\u0013'\u0001\tn_\u0012,GNV3sg&|g.T1qA\u0005!An\\1e)\u0011iTiR*\t\u000b\u0019+\u0001\u0019\u0001\u0017\u00021M,'O^1cY\u0016l\u0015M\\1hKJ\u001cuN\u001c4jO\u0012K'\u000fC\u0003I\u000b\u0001\u0007\u0011*\u0001\u000bqkJ,\u0007K]3eS\u000e$H+[7feNl\u0015\r\u001d\t\u0005K)b#\n\u0005\u0003&U1Z\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u001diW\r\u001e:jGNT!\u0001\u0015\u000b\u0002\u0011\r|G-\u00195bY\u0016L!AU'\u0003\u000bQKW.\u001a:\t\u000bQ+\u0001\u0019A%\u0002/5|G-\u001a7J]\u001a,'/\u001a8dKRKW.\u001a:t\u001b\u0006\u0004\u0018a\u0005:fiJLg/Z!mYN+'O^1cY\u0016\u001cX#A,\u0011\u0007ak\u0006H\u0004\u0002Z7:\u0011qFW\u0005\u00027%\u0011ALG\u0001\ba\u0006\u001c7.Y4f\u0013\tqvL\u0001\u0003MSN$(B\u0001/\u001b\u0003A\u0011X\r\u001e:jm\u0016\u001cVM\u001d<bE2,7\u000f\u0006\u0002XE\")1m\u0002a\u0001Y\u0005IQn\u001c3fY:\u000bW.Z\u0001\u0010e\u0016$(/\u001b<f'\u0016\u0014h/\u00192mKR\u0019\u0001HZ4\t\u000b\rD\u0001\u0019\u0001\u0017\t\u000b!D\u0001\u0019\u0001\u0017\u0002\u00195|G-\u001a7WKJ\u001c\u0018n\u001c8")
public class ServableManager {
    private HashMap<String, HashMap<String, Servable>> modelVersionMap = new HashMap();

    private HashMap<String, HashMap<String, Servable>> modelVersionMap() {
        return this.modelVersionMap;
    }

    private void modelVersionMap_$eq(HashMap<String, HashMap<String, Servable>> x$1) {
        this.modelVersionMap = x$1;
    }

    public void load(String servableManagerConfigDir, HashMap<String, HashMap<String, Timer>> purePredictTimersMap, HashMap<String, HashMap<String, Timer>> modelInferenceTimersMap) {
        if (!Files.exists(Paths.get(servableManagerConfigDir, new String[0]), new LinkOption[0])) {
            throw new ServableLoadException("servable Manager config dir not exist", null);
        }
        String servableManagerConfYaml = Source$.MODULE$.fromFile(servableManagerConfigDir, Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List<ModelMetaData> modelInfoList = YamlUtil$.MODULE$.fromYaml(ServableManagerConf.class, servableManagerConfYaml, ManifestFactory$.MODULE$.classType(ServableManagerConf.class)).modelMetaDataList();
        modelInfoList.foreach((Function1 & Serializable & scala.Serializable)modelInfo -> {
            ServableManager.$anonfun$load$1(this, modelInferenceTimersMap, purePredictTimersMap, modelInfo);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public List<Servable> retriveAllServables() {
        void var1_1;
        List result = ((TraversableOnce)this.modelVersionMap().values().flatMap((Function1 & Serializable & scala.Serializable)maps -> maps.values().toList(), Iterable$.MODULE$.canBuildFrom())).toList();
        return var1_1;
    }

    public List<Servable> retriveServables(String modelName) {
        if (!this.modelVersionMap().contains((Object)modelName)) {
            throw new ModelNotFoundException(new StringBuilder(29).append("model not exist. Model Name: ").append(modelName).toString(), null);
        }
        return ((HashMap)this.modelVersionMap().apply((Object)modelName)).values().toList();
    }

    public Servable retriveServable(String modelName, String modelVersion) {
        if (!this.modelVersionMap().contains((Object)modelName) || !((HashMap)this.modelVersionMap().apply((Object)modelName)).contains((Object)modelVersion)) {
            throw new ModelNotFoundException(new StringBuilder(46).append("model not exist. Model Name: ").append(modelName).append(", Model Version: ").append(modelVersion).toString(), null);
        }
        return (Servable)((HashMap)this.modelVersionMap().apply((Object)modelName)).apply((Object)modelVersion);
    }

    public static final /* synthetic */ void $anonfun$load$1(ServableManager $this, HashMap modelInferenceTimersMap$1, HashMap purePredictTimersMap$1, ModelMetaData modelInfo) {
        Servable servable;
        if (!$this.modelVersionMap().contains((Object)modelInfo.getModelName())) {
            HashMap versionMapper = new HashMap();
            $this.modelVersionMap().update((Object)modelInfo.getModelName(), (Object)versionMapper);
            HashMap timerMapperInference = new HashMap();
            modelInferenceTimersMap$1.update((Object)modelInfo.getModelName(), (Object)timerMapperInference);
            HashMap timerMapperPurePredict = new HashMap();
            purePredictTimersMap$1.update((Object)modelInfo.getModelName(), (Object)timerMapperPurePredict);
        }
        if (((HashMap)$this.modelVersionMap().apply((Object)modelInfo.getModelName())).contains((Object)modelInfo.getModelVersion())) {
            throw new ServableLoadException(new StringBuilder(52).append("duplicated model info. Model Name: ").append(modelInfo.getModelName()).append(", Model Version: ").append(modelInfo.getModelVersion()).toString(), null);
        }
        ((HashMap)modelInferenceTimersMap$1.apply((Object)modelInfo.getModelName())).update((Object)modelInfo.getModelVersion(), (Object)FrontEndApp$.MODULE$.metrics().timer(new StringBuilder(25).append("bigdl.serving.inference.").append(modelInfo.getModelName()).append(".").append(modelInfo.getModelVersion()).toString()));
        ((HashMap)purePredictTimersMap$1.apply((Object)modelInfo.getModelName())).update((Object)modelInfo.getModelVersion(), (Object)FrontEndApp$.MODULE$.metrics().timer(new StringBuilder(20).append("bigdl.pure.predict.").append(modelInfo.getModelName()).append(".").append(modelInfo.getModelVersion()).toString()));
        ModelMetaData modelMetaData = modelInfo;
        if (modelMetaData instanceof ClusterServingMetaData) {
            ClusterServingMetaData clusterServingMetaData = (ClusterServingMetaData)modelMetaData;
            servable = new ClusterServingServable(clusterServingMetaData);
        } else if (modelMetaData instanceof InferenceModelMetaData) {
            InferenceModelMetaData inferenceModelMetaData = (InferenceModelMetaData)modelMetaData;
            servable = new InferenceModelServable(inferenceModelMetaData, (Timer)((HashMap)purePredictTimersMap$1.apply((Object)modelInfo.getModelName())).apply((Object)modelInfo.getModelVersion()));
        } else {
            throw new MatchError((Object)modelMetaData);
        }
        ClusterServingServable servable2 = servable;
        ((Servable)servable2).load();
        ((HashMap)$this.modelVersionMap().apply((Object)modelInfo.getModelName())).update((Object)modelInfo.getModelVersion(), (Object)servable2);
    }
}

