/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.serving.serialization;

import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.serving.serialization.ArrowSerializer;
import com.intel.analytics.bigdl.serving.utils.Conventions$;
import com.intel.analytics.bigdl.serving.utils.TensorUtils$;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class ArrowSerializer$ {
    public static ArrowSerializer$ MODULE$;

    static {
        new ArrowSerializer$();
    }

    public Schema getSchema() {
        Field dataField = new Field("data", FieldType.nullable((ArrowType)Conventions$.MODULE$.ARROW_FLOAT()), null);
        Field shapeField = new Field("shape", FieldType.nullable((ArrowType)Conventions$.MODULE$.ARROW_INT()), null);
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)dataField, (List)new .colon.colon((Object)shapeField, (List)Nil$.MODULE$))).asJava(), null);
    }

    public void writeTensor(Tensor<Object> tensor, VectorSchemaRoot vectorSchemaRoot, ArrowStreamWriter writer) {
        int[] shape = tensor.size();
        int totalSize = TensorUtils$.MODULE$.getTotalSize(tensor);
        float[] data = (float[])tensor.resize(totalSize).toArray();
        ArrowSerializer serializer = new ArrowSerializer(data, shape);
        serializer.copyToSchemaRoot(vectorSchemaRoot);
        writer.writeBatch();
    }

    public byte[] activityBatchToByte(Activity t, int idx) {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.create((Schema)this.getSchema(), (BufferAllocator)allocator);
        ArrowStreamWriter writer = new ArrowStreamWriter(vectorSchemaRoot, null, (OutputStream)out);
        writer.start();
        if (t.isTable()) {
            t.toTable().keySet().foreach((Function1 & Serializable & scala.Serializable)key -> {
                ArrowSerializer$.$anonfun$activityBatchToByte$1(idx, t, vectorSchemaRoot, writer, key);
                return BoxedUnit.UNIT;
            });
        } else if (t.isTensor()) {
            Tensor tensor = idx > 0 ? t.toTensor((TensorNumericMath.TensorNumeric)TensorNumericMath.TensorNumeric$.NumericFloat$.MODULE$).select(1, idx) : t.toTensor((TensorNumericMath.TensorNumeric)TensorNumericMath.TensorNumeric$.NumericFloat$.MODULE$);
            this.writeTensor((Tensor<Object>)tensor, vectorSchemaRoot, writer);
        } else {
            throw new Error("Your input for Post-processing is invalid, neither Table nor Tensor, please check.");
        }
        vectorSchemaRoot.close();
        writer.end();
        writer.close();
        out.flush();
        out.close();
        return out.toByteArray();
    }

    public static final /* synthetic */ void $anonfun$activityBatchToByte$1(int idx$1, Activity t$1, VectorSchemaRoot vectorSchemaRoot$1, ArrowStreamWriter writer$1, Object key) {
        Tensor tensor = idx$1 > 0 ? ((Tensor)t$1.toTable().apply(key)).select(1, idx$1) : (Tensor)t$1.toTable().apply(key);
        MODULE$.writeTensor((Tensor<Object>)tensor, vectorSchemaRoot$1, writer$1);
    }

    private ArrowSerializer$() {
        MODULE$ = this;
    }
}

