/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.serving.utils;

import com.intel.analytics.bigdl.serving.utils.PrintReaderRunnable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import redis.embedded.Redis;
import redis.embedded.exceptions.EmbeddedRedisException;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=e!\u0002\r\u001a\u0003\u00031\u0003\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011}\u0002!\u0011!Q\u0001\neBQ\u0001\u0011\u0001\u0005\u0012\u0005C\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u0003$\t\u0013a\u0003\u0001\u0019!a\u0001\n#I\u0006\"C0\u0001\u0001\u0004\u0005\t\u0015)\u0003H\u0011\u001d\u0001\u0007\u00011A\u0005\n\u0005Dq!\u001a\u0001A\u0002\u0013%a\r\u0003\u0004i\u0001\u0001\u0006KA\u0019\u0005\nS\u0002\u0001\r\u00111A\u0005\n)D\u0011B\u001c\u0001A\u0002\u0003\u0007I\u0011B8\t\u0013E\u0004\u0001\u0019!A!B\u0013Y\u0007b\u0002:\u0001\u0005\u0004%ia\u001d\u0005\u0007u\u0002\u0001\u000bQ\u0002;\t\u000bm\u0004A\u0011\t?\t\u000bu\u0004A\u0011\t@\t\r\u0005%\u0003\u0001\"\u0003\u007f\u0011\u0019\tY\u0005\u0001C\u0005}\"9\u0011q\r\u0001\u0007\u0012\u0005e\u0001bBA5\u0001\u0011%\u00111\u000e\u0005\u0007\u0003g\u0002A\u0011\t@\t\r\u0005\u0005\u0005\u0001\"\u0003\u007f\u0011\u001d\t\u0019\t\u0001C!\u0003\u000b\u0013Q#\u00112tiJ\f7\r\u001e*fI&\u001c\u0018J\\:uC:\u001cWM\u0003\u0002\u001b7\u0005)Q\u000f^5mg*\u0011A$H\u0001\bg\u0016\u0014h/\u001b8h\u0015\tqr$A\u0003cS\u001e$GN\u0003\u0002!C\u0005I\u0011M\\1msRL7m\u001d\u0006\u0003E\r\nQ!\u001b8uK2T\u0011\u0001J\u0001\u0004G>l7\u0001A\n\u0004\u0001\u001dz\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0011a\u0017M\\4\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001C3nE\u0016$G-\u001a3\u000b\u0003Q\nQA]3eSNL!AN\u0019\u0003\u000bI+G-[:\u0002\tA|'\u000f^\u000b\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t\u0019\u0011J\u001c;\u0002\u000bA|'\u000f\u001e\u0011\u0002\rqJg.\u001b;?)\t\u0011E\t\u0005\u0002D\u00015\t\u0011\u0004C\u00038\u0007\u0001\u0007\u0011(\u0001\u0003be\u001e\u001cX#A$\u0011\u0007![U*D\u0001J\u0015\tQ5&\u0001\u0003vi&d\u0017B\u0001'J\u0005\u0011a\u0015n\u001d;\u0011\u00059+fBA(T!\t\u00016(D\u0001R\u0015\t\u0011V%\u0001\u0004=e>|GOP\u0005\u0003)n\na\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011AkO\u0001\tCJ<7o\u0018\u0013fcR\u0011!,\u0018\t\u0003umK!\u0001X\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b=\u0016\t\t\u00111\u0001H\u0003\rAH%M\u0001\u0006CJ<7\u000fI\u0001\u0007C\u000e$\u0018N^3\u0016\u0003\t\u0004\"AO2\n\u0005\u0011\\$a\u0002\"p_2,\u0017M\\\u0001\u000bC\u000e$\u0018N^3`I\u0015\fHC\u0001.h\u0011\u001dq\u0006\"!AA\u0002\t\fq!Y2uSZ,\u0007%\u0001\u0007sK\u0012L7\u000f\u0015:pG\u0016\u001c8/F\u0001l!\tAC.\u0003\u0002nS\t9\u0001K]8dKN\u001c\u0018\u0001\u0005:fI&\u001c\bK]8dKN\u001cx\fJ3r)\tQ\u0006\u000fC\u0004_\u0017\u0005\u0005\t\u0019A6\u0002\u001bI,G-[:Qe>\u001cWm]:!\u0003!)\u00070Z2vi>\u0014X#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005]L\u0015AC2p]\u000e,(O]3oi&\u0011\u0011P\u001e\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006IQ\r_3dkR|'\u000fI\u0001\tSN\f5\r^5wKR\t!-A\u0003ti\u0006\u0014H\u000fF\u0001[Q\u0015\u0001\u0012\u0011AA\n!\u0015Q\u00141AA\u0004\u0013\r\t)a\u000f\u0002\u0007i\"\u0014xn^:\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u00042\u0003))\u0007pY3qi&|gn]\u0005\u0005\u0003#\tYA\u0001\fF[\n,G\rZ3e%\u0016$\u0017n]#yG\u0016\u0004H/[8oc\u0019qR*!\u0006\u0002HEJ1%a\u0006\u0002 \u0005u\u0012\u0011E\u000b\u0005\u00033\tY\"F\u0001N\t\u001d\ti\"\nb\u0001\u0003O\u0011\u0011\u0001V\u0005\u0005\u0003C\t\u0019#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003KY\u0014A\u0002;ie><8/\u0005\u0003\u0002*\u0005=\u0002c\u0001\u001e\u0002,%\u0019\u0011QF\u001e\u0003\u000f9{G\u000f[5oOB!\u0011\u0011GA\u001c\u001d\rQ\u00141G\u0005\u0004\u0003kY\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003s\tYDA\u0005UQJ|w/\u00192mK*\u0019\u0011QG\u001e2\u0013\r\ny$!\u0011\u0002D\u0005\u0015bb\u0001\u001e\u0002B%\u0019\u0011QE\u001e2\u000b\tR4(!\u0012\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n9!A\u0005m_\u001e,%O]8sg\u0006)\u0012m^1jiJ+G-[:TKJ4XM\u001d*fC\u0012L\b&\u0002\n\u0002P\u0005u\u0003#\u0002\u001e\u0002\u0004\u0005E\u0003\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]3&\u0001\u0002j_&!\u00111LA+\u0005-Iu*\u0012=dKB$\u0018n\u001c82\ryi\u0015qLA3c%\u0019\u0013qCA\u0010\u0003C\n\t#M\u0005$\u0003\u007f\t\t%a\u0019\u0002&E*!EO\u001e\u0002FE\u001aa%!\u0015\u0002#I,G-[:SK\u0006$\u0017\u0010U1ui\u0016\u0014h.A\rde\u0016\fG/\u001a*fI&\u001c\bK]8dKN\u001c()^5mI\u0016\u0014XCAA7!\rA\u0013qN\u0005\u0004\u0003cJ#A\u0004)s_\u000e,7o\u001d\"vS2$WM]\u0001\u0005gR|\u0007\u000fK\u0003\u0016\u0003\u0003\t9(\r\u0004\u001f\u001b\u0006e\u0014qP\u0019\nG\u0005]\u0011qDA>\u0003C\t\u0014bIA \u0003\u0003\ni(!\n2\u000b\tR4(!\u00122\u0007\u0019\n9!\u0001\u0006uef<\u0016-\u001b;G_J\fQ\u0001]8siN$\"!a\"\u0011\t![\u0015\u0011\u0012\t\u0004Q\u0005-\u0015bAAGS\t9\u0011J\u001c;fO\u0016\u0014\b")
public abstract class AbstractRedisInstance
implements Redis {
    private final int port;
    private List<String> args;
    private boolean active;
    private Process redisProcess;
    private final ExecutorService executor;

    public int port() {
        return this.port;
    }

    public List<String> args() {
        return this.args;
    }

    public void args_$eq(List<String> x$1) {
        this.args = x$1;
    }

    private boolean active() {
        return this.active;
    }

    private void active_$eq(boolean x$1) {
        this.active = x$1;
    }

    private Process redisProcess() {
        return this.redisProcess;
    }

    private void redisProcess_$eq(Process x$1) {
        this.redisProcess = x$1;
    }

    private final ExecutorService executor() {
        return this.executor;
    }

    public boolean isActive() {
        return this.active();
    }

    public void start() throws EmbeddedRedisException {
        if (this.active()) {
            throw new EmbeddedRedisException("This redis server instance is already running...");
        }
        try {
            this.redisProcess_$eq(this.createRedisProcessBuilder().start());
            this.logErrors();
            this.awaitRedisServerReady();
            this.active_$eq(true);
        }
        catch (IOException var2) {
            throw new EmbeddedRedisException("Failed to start Redis instance", (Throwable)var2);
        }
    }

    private void logErrors() {
        InputStream errorStream = this.redisProcess().getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
        PrintReaderRunnable printReaderTask = new PrintReaderRunnable(reader);
        this.executor().submit(printReaderTask);
    }

    private void awaitRedisServerReady() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.redisProcess().getInputStream()));
        String outputLine = "";
        try {
            while (true) {
                if ((outputLine = reader.readLine()) == null) {
                    throw new RuntimeException("Can't start redis server. Check logs for details.");
                }
                if (!outputLine.matches(this.redisReadyPattern())) {
                    continue;
                }
                break;
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public abstract String redisReadyPattern();

    /*
     * WARNING - void declaration
     */
    private ProcessBuilder createRedisProcessBuilder() {
        void var2_2;
        File executable = new File(this.args().get(0));
        ProcessBuilder pb = new ProcessBuilder(this.args());
        pb.directory(executable.getParentFile());
        return var2_2;
    }

    public void stop() throws EmbeddedRedisException {
        block0: {
            if (!this.active()) break block0;
            this.redisProcess().destroy();
            this.tryWaitFor();
            this.active_$eq(false);
        }
    }

    private void tryWaitFor() {
        try {
            this.redisProcess().waitFor();
        }
        catch (InterruptedException var2) {
            throw new EmbeddedRedisException("Failed to stop redis instance", (Throwable)var2);
        }
    }

    public List<Integer> ports() {
        return Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.port())});
    }

    public AbstractRedisInstance(int port) {
        this.port = port;
        this.active = false;
        this.executor = Executors.newSingleThreadExecutor();
    }
}

