/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.serving.utils;

import com.intel.analytics.bigdl.serving.utils.Conventions$;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.exceptions.JedisConnectionException;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class RedisUtils$ {
    public static RedisUtils$ MODULE$;
    private final Logger logger;

    static {
        new RedisUtils$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void createRedisGroupIfNotExist(Jedis jedis, String streamName) {
        try {
            jedis.xgroupCreate(streamName, "serving", new StreamEntryID(0L, 0L), true);
        }
        catch (Exception e) {
            this.logger().info(new StringBuilder(49).append("xgroupCreate raise [").append(e).append("], ").append("will not create new group.").toString());
        }
    }

    public void checkMemory(Jedis db, double inputThreshold, double cutRatio) {
        scala.collection.immutable.Map<String, String> redisInfo = this.getMapFromInfo(db.info());
        StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString((String)redisInfo.apply((Object)"used_memory")));
        StringOps stringOps2 = new StringOps(Predef$.MODULE$.augmentString((String)redisInfo.apply((Object)"maxmemory")));
        if ((double)stringOps.toLong() >= (double)stringOps2.toLong() * inputThreshold) {
            RedisUtils$ redisUtils$ = this;
            synchronized (redisUtils$) {
                redisInfo = this.getMapFromInfo(db.info());
                if (new StringOps(Predef$.MODULE$.augmentString((String)redisInfo.apply((Object)"maxmemory"))).toLong() > 0L) {
                    StringOps stringOps3 = new StringOps(Predef$.MODULE$.augmentString((String)redisInfo.apply((Object)"used_memory")));
                    StringOps stringOps4 = new StringOps(Predef$.MODULE$.augmentString((String)redisInfo.apply((Object)"maxmemory")));
                    if ((double)stringOps3.toLong() >= (double)stringOps4.toLong() * inputThreshold) {
                        this.logger().warn(new StringBuilder(75).append("Used memory ").append(redisInfo.apply((Object)"used_memory")).append(", ").append("Max memory ").append(redisInfo.apply((Object)"maxmemory")).append(". Your input data length is ").append(db.xlen(Conventions$.MODULE$.SERVING_STREAM_DEFAULT_NAME())).append(". Removing old data...").toString());
                        db.xtrim(Conventions$.MODULE$.SERVING_STREAM_DEFAULT_NAME(), (long)((double)Predef$.MODULE$.Long2long(db.xlen(Conventions$.MODULE$.SERVING_STREAM_DEFAULT_NAME())) * cutRatio), true);
                        this.logger().warn(new StringBuilder(50).append("Trimmed stream, now your serving stream length is ").append(db.xlen(Conventions$.MODULE$.SERVING_STREAM_DEFAULT_NAME())).toString());
                        scala.collection.immutable.Map<String, String> cuttedRedisInfo = this.getMapFromInfo(db.info());
                        while (true) {
                            StringOps stringOps5 = new StringOps(Predef$.MODULE$.augmentString((String)cuttedRedisInfo.apply((Object)"used_memory")));
                            StringOps stringOps6 = new StringOps(Predef$.MODULE$.augmentString((String)cuttedRedisInfo.apply((Object)"maxmemory")));
                            if (!((double)stringOps5.toLong() >= (double)stringOps6.toLong() * inputThreshold)) break;
                            this.logger().error(new StringBuilder(107).append("Used memory ").append(redisInfo.apply((Object)"used_memory")).append(", ").append("Max memory ").append(redisInfo.apply((Object)"maxmemory")).append(". ").append("Your result field has exceeded the limit, please dequeue. Will retry in 10 sec..").toString());
                            cuttedRedisInfo = this.getMapFromInfo(db.info());
                            Thread.sleep(10000L);
                        }
                    }
                }
            }
        }
    }

    public scala.collection.immutable.Map<String, String> getMapFromInfo(String info) {
        ObjectRef infoMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        String[] tabs = info.split("#");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tabs)).foreach((Function1 & Serializable & scala.Serializable)tab -> {
            RedisUtils$.$anonfun$getMapFromInfo$1(infoMap, tab);
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)infoMap.elem;
    }

    /*
     * WARNING - void declaration
     */
    public Jedis getRedisClient(JedisPool redisPool) {
        void var2_2;
        Jedis jedis = null;
        int cnt = 0;
        while (jedis == null) {
            try {
                jedis = redisPool.getResource();
            }
            catch (JedisConnectionException e) {
                this.logger().info(new StringBuilder(146).append("Redis client can not connect, maybe max number of clients is reached.").append("Waiting, if you always receive this, please stop your service and report bug.").toString());
                e.printStackTrace();
                if (++cnt >= 10) {
                    throw new Error("can not get redis from the pool");
                }
                Thread.sleep(500L);
            }
            Thread.sleep(10L);
        }
        return var2_2;
    }

    public void writeHashMap(Pipeline ppl, String key, String value, String name) {
        String hKey = new StringBuilder(1).append(Conventions$.MODULE$.RESULT_PREFIX()).append(name).append(":").append(key).toString();
        java.util.Map hValue = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value)}))).asJava();
        ppl.hmset(hKey, hValue);
    }

    public void writeXstream(Pipeline ppl, String key, String value, String name) {
        String streamKey = new StringBuilder(1).append(Conventions$.MODULE$.RESULT_PREFIX()).append(name).append(":").append(key).toString();
        java.util.Map streamValue = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value)}))).asJava();
        ppl.xadd(streamKey, StreamEntryID.NEW_ENTRY, streamValue);
    }

    public static final /* synthetic */ void $anonfun$getMapFromInfo$2(ObjectRef infoMap$1, String key) {
        block0: {
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])key.split(":"))).size() != 2) break block0;
            infoMap$1.elem = ((scala.collection.immutable.Map)infoMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])key.split(":"))).head()), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])key.split(":"))).last()));
        }
    }

    public static final /* synthetic */ void $anonfun$getMapFromInfo$1(ObjectRef infoMap$1, String tab) {
        block0: {
            if (tab.length() <= 0) break block0;
            String[] keys = tab.split("\r\n");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).foreach((Function1 & Serializable & scala.Serializable)key -> {
                RedisUtils$.$anonfun$getMapFromInfo$2(infoMap$1, key);
                return BoxedUnit.UNIT;
            });
        }
    }

    private RedisUtils$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

