/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBPartitionInfo;
import com.intel.genomicsdb.GenomicsDBPartitionStrategy;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;

public class GenomicsDBConfiguration
extends Configuration
implements Serializable {
    public static final String LOADERJSON = "genomicsdb.input.loaderjsonfile";
    public static final String QUERYJSON = "genomicsdb.input.queryjsonfile";
    public static final String MPIHOSTFILE = "genomicsdb.input.mpi.hostfile";
    public static final String PARTITION_STRATEGY = "genomicsdb.partition.strategy";
    private Boolean produceCombinedVCF = false;
    private Boolean produceTileDBArray = false;
    private Integer segmentSize = 1000;
    private Integer nCellsPerTile = 1000;
    private LinkedList<GenomicsDBPartitionInfo> partitionInfoList = null;
    private ArrayList<String> hosts = new ArrayList();

    public GenomicsDBConfiguration(Configuration configuration) throws FileNotFoundException {
        super(configuration);
    }

    public GenomicsDBConfiguration(Configuration configuration, List<GenomicsDBPartitionInfo> list) throws FileNotFoundException {
        super(configuration);
        for (GenomicsDBPartitionInfo info : list) {
            this.addPartitions(info);
        }
    }

    public GenomicsDBConfiguration setLoaderJsonFile(String path) {
        this.set(LOADERJSON, path);
        return this;
    }

    public GenomicsDBConfiguration setQueryJsonFile(String path) {
        this.set(QUERYJSON, path);
        return this;
    }

    public GenomicsDBConfiguration setHostFile(String path) throws FileNotFoundException {
        this.set(MPIHOSTFILE, path);
        Scanner scanner = new Scanner(new FileInputStream(path));
        while (scanner.hasNextLine()) {
            String host = scanner.nextLine();
            this.hosts.add(host);
        }
        return this;
    }

    List<String> getHosts() {
        return this.hosts;
    }

    void setPartitionStrategy(Boolean isRowPartitioned) {
        if (isRowPartitioned.booleanValue()) {
            this.set(PARTITION_STRATEGY, String.valueOf(GenomicsDBPartitionStrategy.ROW_MAJOR()));
        } else {
            this.set(PARTITION_STRATEGY, String.valueOf(GenomicsDBPartitionStrategy.COL_MAJOR()));
        }
    }

    void setPartitionStrategy(String partitionStrategy) {
        if (partitionStrategy.equals("ROW_MAJOR")) {
            this.set(PARTITION_STRATEGY, String.valueOf(GenomicsDBPartitionStrategy.ROW_MAJOR()));
        } else if (partitionStrategy.equals("COL_MAJOR")) {
            this.set(PARTITION_STRATEGY, String.valueOf(GenomicsDBPartitionStrategy.COL_MAJOR()));
        }
    }

    private void addPartitions(GenomicsDBPartitionInfo genomicsDBPartitionInfo) {
        if (this.partitionInfoList == null) {
            this.partitionInfoList = new LinkedList();
        }
        this.partitionInfoList.push(genomicsDBPartitionInfo);
    }
}

