/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBQueryStream;
import com.intel.genomicsdb.GenomicsDBTimer;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.FeatureReader;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class GenomicsDBFeatureReader<T extends Feature, SOURCE>
implements FeatureReader<T> {
    private String mLoaderJSONFile = null;
    private String mQueryJSONFile = null;
    private FeatureCodec<T, SOURCE> mCodec = null;
    protected FeatureCodecHeader mFCHeader;
    private VCFHeader mVCFHeader = null;
    private ArrayList<String> mSequenceNames;

    public GenomicsDBFeatureReader(String loaderJSONFile, String tiledbWorkspace, String arrayName, String referenceGenome, FeatureCodec<T, SOURCE> codec) throws IOException {
        this(loaderJSONFile, tiledbWorkspace, arrayName, referenceGenome, null, codec);
    }

    public GenomicsDBFeatureReader(String loaderJSONFile, String tiledbWorkspace, String arrayName, String referenceGenome, String templateVCFHeaderFilename, FeatureCodec<T, SOURCE> codec) throws IOException {
        String indentString = "    ";
        String queryJSON = "{\n";
        queryJSON = queryJSON + indentString + "\"scan_full\": true,\n";
        queryJSON = queryJSON + indentString + "\"workspace\": \"" + tiledbWorkspace + "\",\n";
        queryJSON = queryJSON + indentString + "\"array\": \"" + arrayName + "\",\n";
        queryJSON = queryJSON + indentString + "\"reference_genome\": \"" + referenceGenome + "\",\n";
        if (templateVCFHeaderFilename != null) {
            queryJSON = queryJSON + indentString + "\"vcf_header_filename\": \"" + templateVCFHeaderFilename + "\"\n";
        }
        queryJSON = queryJSON + "}\n";
        File tmpQueryJSONFile = File.createTempFile("queryJSON", ".json");
        tmpQueryJSONFile.deleteOnExit();
        FileWriter fptr = new FileWriter(tmpQueryJSONFile);
        fptr.write(queryJSON);
        fptr.close();
        this.initialize(loaderJSONFile, tmpQueryJSONFile.getAbsolutePath(), codec);
    }

    public GenomicsDBFeatureReader(String loaderJSONFile, String queryJSONFile, FeatureCodec<T, SOURCE> codec) throws IOException {
        this.initialize(loaderJSONFile, queryJSONFile, codec);
    }

    public GenomicsDBFeatureReader(String queryJSONFile, FeatureCodec<T, SOURCE> codec) throws IOException {
        this.initialize("", queryJSONFile, codec);
    }

    public void initialize(String loaderJSONFile, String queryJSONFile, FeatureCodec<T, SOURCE> codec) throws IOException {
        this.mCodec = codec;
        this.mLoaderJSONFile = loaderJSONFile;
        this.mQueryJSONFile = queryJSONFile;
        GenomicsDBQueryStream gdbStream = new GenomicsDBQueryStream(loaderJSONFile, queryJSONFile);
        Object source = codec.makeSourceFromStream((InputStream)gdbStream);
        this.mFCHeader = codec.readHeader(source);
        this.mVCFHeader = (VCFHeader)this.mFCHeader.getHeaderValue();
        this.mSequenceNames = new ArrayList(this.mVCFHeader.getContigLines().size());
        for (VCFContigHeaderLine contigHeaderLine : this.mVCFHeader.getContigLines()) {
            this.mSequenceNames.add(contigHeaderLine.getID());
        }
        gdbStream.close();
    }

    public Object getHeader() {
        return this.mFCHeader.getHeaderValue();
    }

    public List<String> getSequenceNames() {
        return this.mSequenceNames;
    }

    public void close() throws IOException {
    }

    public CloseableTribbleIterator<T> iterator() throws IOException {
        return new GenomicsDBFeatureIterator(this.mLoaderJSONFile, this.mQueryJSONFile, this.mCodec);
    }

    public CloseableTribbleIterator<T> query(String chr, int start, int end) throws IOException {
        return new GenomicsDBFeatureIterator(this.mLoaderJSONFile, this.mQueryJSONFile, this.mCodec, chr, start, end);
    }

    class GenomicsDBFeatureIterator
    implements CloseableTribbleIterator<T> {
        private FeatureCodec<T, SOURCE> mCodec = null;
        private GenomicsDBQueryStream mStream = null;
        private SOURCE mSource = null;
        private GenomicsDBTimer mTimer = null;
        private boolean mClosedBefore = false;

        public GenomicsDBFeatureIterator(String loaderJSONFile, String queryJSONFile, FeatureCodec<T, SOURCE> codec) throws IOException {
            this(loaderJSONFile, queryJSONFile, codec, "", 0, 0);
        }

        public GenomicsDBFeatureIterator(String loaderJSONFile, String queryJSONFile, FeatureCodec<T, SOURCE> codec, String chr, int start, int end) throws IOException {
            this.mCodec = codec;
            this.mStream = new GenomicsDBQueryStream(loaderJSONFile, queryJSONFile, chr, start, end);
            this.mStream.skip(GenomicsDBFeatureReader.this.mFCHeader.getHeaderEnd());
            this.mSource = codec.makeSourceFromStream((InputStream)this.mStream);
            this.mTimer = new GenomicsDBTimer();
        }

        public boolean hasNext() {
            boolean isDone = this.mCodec.isDone(this.mSource);
            if (isDone) {
                this.close();
            }
            return !isDone;
        }

        public T next() {
            try {
                this.mTimer.start();
                if (this.mCodec.isDone(this.mSource)) {
                    throw new RuntimeException("No more valid records exist");
                }
                Feature nextObj = this.mCodec.decode(this.mSource);
                this.mTimer.stop();
                return nextObj;
            }
            catch (IOException e) {
                throw new RuntimeException("Unknown codec exception");
            }
        }

        public void close() {
            if (!this.mClosedBefore) {
                this.mTimer.print("GenomicsDB iterator next() timer", System.err);
                this.mCodec.close(this.mSource);
                this.mClosedBefore = true;
            }
        }

        public GenomicsDBFeatureIterator iterator() {
            return this;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }
    }
}

