/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import com.intel.genomicsdb.ChromosomeInterval;
import com.intel.genomicsdb.GenomicsDBCallsetsMapProto;
import com.intel.genomicsdb.GenomicsDBException;
import com.intel.genomicsdb.GenomicsDBImportConfiguration;
import com.intel.genomicsdb.GenomicsDBImporterStreamWrapper;
import com.intel.genomicsdb.GenomicsDBUtils;
import com.intel.genomicsdb.GenomicsDBVidMapProto;
import com.intel.genomicsdb.MultiChromosomeIterator;
import com.intel.genomicsdb.SampleInfo;
import com.intel.genomicsdb.SilentByteBufferStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.FeatureReader;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GenomicsDBImporter {
    static long mDefaultBufferCapacity;
    private static final String mTempLoaderJSONFileName = ".tmp_loader.json";
    private final String DEFAULT_ARRAYNAME = "genomicsdb_array";
    private final long DEFAULT_SIZE_PER_COLUMN_PARTITION = 10240L;
    private final int DEFAULT_TILEDB_CELLS_PER_TILE = 1000;
    private String mLoaderJSONFile = null;
    private int mRank = 0;
    private long mLbRowIdx = 0L;
    private long mUbRowIdx = 0x7FFFFFFFFFFFFFFEL;
    private boolean mContainsBufferStreams = false;
    private long mGenomicsDBImporterObjectHandle = 0L;
    private ArrayList<GenomicsDBImporterStreamWrapper> mBufferStreamWrapperVector = null;
    private boolean mIsLoaderSetupDone = false;
    private long[] mExhaustedBufferStreamIdentifiers = null;
    private long mNumExhaustedBufferStreams = 0L;
    private boolean mDone = false;
    private JSONObject mCallsetMappingJSON = null;
    private boolean mUsingVidMappingProtoBuf = false;
    private GenomicsDBVidMapProto.VidMappingPB mVidMap = null;
    private ChromosomeInterval mChromosomeInterval;
    private GenomicsDBCallsetsMapProto.CallsetMappingPB mCallsetMap = null;

    private native int jniGenomicsDBImporter(String var1, int var2, long var3, long var5);

    private native long jniInitializeGenomicsDBImporterObject(String var1, int var2, long var3, long var5);

    private native long jniCopyVidMap(long var1, byte[] var3);

    private native long jniCopyCallsetMap(long var1, byte[] var3);

    private native void jniAddBufferStream(long var1, String var3, boolean var4, long var5, byte[] var7, long var8);

    private native long jniSetupGenomicsDBLoader(long var1, String var3, boolean var4);

    private native void jniWriteDataToBufferStream(long var1, int var3, int var4, byte[] var5, long var6);

    private native boolean jniImportBatch(long var1, long[] var3);

    private static native String jniGetChromosomeIntervalsForColumnPartition(String var0, int var1);

    public GenomicsDBImporter() {
    }

    public GenomicsDBImporter(String loaderJSONFile) {
        this.initialize(loaderJSONFile, 0, 0L, 0x7FFFFFFFFFFFFFFEL);
    }

    public GenomicsDBImporter(String loaderJSONFile, int rank) {
        this.initialize(loaderJSONFile, rank, 0L, 0x7FFFFFFFFFFFFFFEL);
    }

    public GenomicsDBImporter(String loaderJSONFile, int rank, long lbRowIdx, long ubRowIdx) {
        this.initialize(loaderJSONFile, rank, lbRowIdx, ubRowIdx);
    }

    public GenomicsDBImporter(Map<String, FeatureReader<VariantContext>> sampleToVCMap, Set<VCFHeaderLine> mergedHeader, ChromosomeInterval chromosomeInterval, String workspace, String arrayname, Long sizePerColumnPartition, Long segmentSize) throws IOException {
        this(sampleToVCMap, mergedHeader, chromosomeInterval, workspace, arrayname, sizePerColumnPartition, segmentSize, false);
    }

    public GenomicsDBImporter(Map<String, FeatureReader<VariantContext>> sampleToVCMap, Set<VCFHeaderLine> mergedHeader, ChromosomeInterval chromosomeInterval, String workspace, String arrayname, Long sizePerColumnPartition, Long segmentSize, boolean useSamplesInOrderProvided) throws IOException {
        this.mUsingVidMappingProtoBuf = true;
        if (sizePerColumnPartition == 0L) {
            sizePerColumnPartition = 10240L;
        }
        sizePerColumnPartition = sizePerColumnPartition * (long)sampleToVCMap.size();
        GenomicsDBImportConfiguration.ImportConfiguration importConfiguration = this.createImportConfiguration(workspace, arrayname, sizePerColumnPartition, segmentSize);
        this.mVidMap = this.generateVidMapFromMergedHeader(mergedHeader);
        this.mCallsetMap = this.generateSortedCallSetMap(sampleToVCMap, useSamplesInOrderProvided);
        File importJSONFile = GenomicsDBImporter.printLoaderJSONFile(importConfiguration, "");
        this.initialize(importJSONFile.getAbsolutePath(), 0, 0L, 0L);
        this.mChromosomeInterval = chromosomeInterval;
        this.mGenomicsDBImporterObjectHandle = this.jniInitializeGenomicsDBImporterObject(this.mLoaderJSONFile, this.mRank, this.mLbRowIdx, this.mUbRowIdx);
        this.jniCopyVidMap(this.mGenomicsDBImporterObjectHandle, this.mVidMap.toByteArray());
        this.jniCopyCallsetMap(this.mGenomicsDBImporterObjectHandle, this.mCallsetMap.toByteArray());
        for (Map.Entry<String, GenomicsDBCallsetsMapProto.SampleIDToTileDBIDMap> callset : this.mCallsetMap.getCallsetMap().entrySet()) {
            GenomicsDBCallsetsMapProto.SampleIDToTileDBIDMap sampleIDToTileDBIDMap = callset.getValue();
            FeatureReader<VariantContext> featureReader = sampleToVCMap.get(sampleIDToTileDBIDMap.getSampleName());
            CloseableTribbleIterator iterator = featureReader.query(this.mChromosomeInterval.mChromosomeName, (int)this.mChromosomeInterval.mBegin, (int)this.mChromosomeInterval.mEnd);
            String streamName = sampleIDToTileDBIDMap.getStreamName();
            LinkedHashMap<Integer, SampleInfo> sampleIndexToInfo = new LinkedHashMap<Integer, SampleInfo>();
            this.addSortedVariantContextIterator(streamName, (VCFHeader)featureReader.getHeader(), (Iterator<VariantContext>)iterator, importConfiguration.getSizePerColumnPartition(), VariantContextWriterBuilder.OutputType.BCF_STREAM, sampleIndexToInfo);
        }
    }

    public GenomicsDBImporter(Map<String, FeatureReader<VariantContext>> sampleToVCMap, Set<VCFHeaderLine> mergedHeader, ChromosomeInterval chromosomeInterval, String workspace, String arrayname, Long sizePerColumnPartition, Long segmentSize, String outputVidMapJSONFilePath) throws IOException {
        this(sampleToVCMap, mergedHeader, chromosomeInterval, workspace, arrayname, sizePerColumnPartition, segmentSize);
        String vidMapJSONString = JsonFormat.printToString((Message)this.mVidMap);
        File vidMapJSONFile = new File(outputVidMapJSONFilePath);
        try (PrintWriter out = new PrintWriter(vidMapJSONFile);){
            out.println(vidMapJSONString);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private GenomicsDBImportConfiguration.ImportConfiguration createImportConfiguration(String workspace, String arrayname, Long sizePerColumnPartition, Long segmentSize) {
        String name = arrayname.isEmpty() ? "genomicsdb_array" : arrayname;
        GenomicsDBImportConfiguration.Partition.Builder pB = GenomicsDBImportConfiguration.Partition.newBuilder();
        GenomicsDBImportConfiguration.Partition p0 = pB.setBegin(0L).setWorkspace(workspace).setArray(name).build();
        GenomicsDBImportConfiguration.ImportConfiguration.Builder importBuilder = GenomicsDBImportConfiguration.ImportConfiguration.newBuilder();
        GenomicsDBImportConfiguration.ImportConfiguration importConfiguration = importBuilder.setRowBasedPartitioning(false).setSizePerColumnPartition(sizePerColumnPartition).addColumnPartitions(p0).setProduceTiledbArray(true).setNumCellsPerTile(1000L).setCompressTiledbArray(true).setSegmentSize(segmentSize).setTreatDeletionsAsIntervals(true).build();
        return importConfiguration;
    }

    public static File printLoaderJSONFile(GenomicsDBImportConfiguration.ImportConfiguration importConfiguration, String filename) {
        String loaderJSONString = JsonFormat.printToString((Message)importConfiguration);
        File tempLoaderJSONFile = filename.isEmpty() ? new File(mTempLoaderJSONFileName) : new File(filename);
        try (PrintWriter out = new PrintWriter(tempLoaderJSONFile);){
            out.println(loaderJSONString);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return tempLoaderJSONFile;
    }

    private GenomicsDBCallsetsMapProto.CallsetMappingPB generateSortedCallSetMap(Map<String, FeatureReader<VariantContext>> variants, boolean useSamplesInOrderProvided) {
        ArrayList sampleNames = new ArrayList(variants.size());
        for (Map.Entry<String, FeatureReader<VariantContext>> v : variants.entrySet()) {
            VCFHeader h = (VCFHeader)v.getValue().getHeader();
            sampleNames.add(h.getSampleNamesInOrder().get(0));
        }
        if (!useSamplesInOrderProvided) {
            Collections.sort(sampleNames);
        }
        GenomicsDBCallsetsMapProto.CallsetMappingPB.Builder callsetMapBuilder = GenomicsDBCallsetsMapProto.CallsetMappingPB.newBuilder();
        int tileDBRowIndex = 0;
        HashMap<String, GenomicsDBCallsetsMapProto.SampleIDToTileDBIDMap> sampleMap = new HashMap<String, GenomicsDBCallsetsMapProto.SampleIDToTileDBIDMap>();
        for (String sampleName : sampleNames) {
            GenomicsDBCallsetsMapProto.SampleIDToTileDBIDMap.Builder idMapBuilder = GenomicsDBCallsetsMapProto.SampleIDToTileDBIDMap.newBuilder();
            idMapBuilder.setSampleName(sampleName).setTiledbRowIndex(tileDBRowIndex++).setIdxInFile(0).setStreamName(sampleName + "_stream");
            GenomicsDBCallsetsMapProto.SampleIDToTileDBIDMap sampleIDToTileDBIDMap = idMapBuilder.build();
            sampleMap.put(sampleName, sampleIDToTileDBIDMap);
        }
        return callsetMapBuilder.putAllCallsetMap(sampleMap).build();
    }

    private void initialize(String loaderJSONFile, int rank, long lbRowIdx, long ubRowIdx) {
        this.mLoaderJSONFile = loaderJSONFile;
        this.mRank = rank;
        this.mLbRowIdx = lbRowIdx;
        this.mUbRowIdx = ubRowIdx;
    }

    private GenomicsDBVidMapProto.VidMappingPB generateVidMapFromMergedHeader(Set<VCFHeaderLine> mergedHeader) {
        ArrayList<GenomicsDBVidMapProto.InfoField> infoFields = new ArrayList<GenomicsDBVidMapProto.InfoField>();
        ArrayList<GenomicsDBVidMapProto.Chromosome> contigs = new ArrayList<GenomicsDBVidMapProto.Chromosome>();
        int dpIndex = -1;
        long columnOffset = 0L;
        for (VCFHeaderLine headerLine : mergedHeader) {
            GenomicsDBVidMapProto.InfoField.Builder infoBuilder = GenomicsDBVidMapProto.InfoField.newBuilder();
            if (headerLine instanceof VCFFormatHeaderLine) {
                String genomicsDBType;
                VCFFormatHeaderLine formatHeaderLine = (VCFFormatHeaderLine)headerLine;
                boolean isGT = formatHeaderLine.getID().equals("GT");
                String string = genomicsDBType = isGT ? "int" : formatHeaderLine.getType().toString();
                String genomicsDBLength = isGT ? "P" : (formatHeaderLine.getType() == VCFHeaderLineType.String ? "VAR" : this.getLength((VCFHeaderLine)formatHeaderLine));
                infoBuilder.setName(formatHeaderLine.getID()).setType(genomicsDBType).setLength(genomicsDBLength);
                if (formatHeaderLine.getID().equals("DP") && dpIndex != -1) {
                    GenomicsDBVidMapProto.InfoField prevDPField = this.remove(infoFields, dpIndex);
                    infoBuilder.addVcfFieldClass(prevDPField.getVcfFieldClass(0)).addVcfFieldClass("FORMAT");
                } else {
                    infoBuilder.addVcfFieldClass("FORMAT");
                }
                GenomicsDBVidMapProto.InfoField formatField = infoBuilder.build();
                infoFields.add(formatField);
                if (!formatHeaderLine.getID().equals("DP")) continue;
                dpIndex = infoFields.indexOf(formatField);
                continue;
            }
            if (headerLine instanceof VCFInfoHeaderLine) {
                VCFInfoHeaderLine infoHeaderLine = (VCFInfoHeaderLine)headerLine;
                if (infoHeaderLine.getType().equals((Object)VCFHeaderLineType.Flag)) {
                    System.err.println("WARNING: Flag type fields are not handled by GenomicsDB currently - skipping field " + infoHeaderLine.getID());
                    continue;
                }
                infoBuilder.setName(infoHeaderLine.getID()).setType(infoHeaderLine.getType().toString()).setLength(infoHeaderLine.getType() == VCFHeaderLineType.String ? "var" : this.getLength((VCFHeaderLine)infoHeaderLine));
                if (infoHeaderLine.getID().equals("DP") && dpIndex != -1) {
                    GenomicsDBVidMapProto.InfoField prevDPield = this.remove(infoFields, dpIndex);
                    infoBuilder.addVcfFieldClass(prevDPield.getVcfFieldClass(0)).addVcfFieldClass("INFO");
                } else {
                    infoBuilder.addVcfFieldClass("INFO");
                }
                GenomicsDBVidMapProto.InfoField infoField = infoBuilder.build();
                infoFields.add(infoField);
                if (!infoHeaderLine.getID().equals("DP")) continue;
                dpIndex = infoFields.indexOf(infoField);
                continue;
            }
            if (headerLine instanceof VCFFilterHeaderLine) {
                VCFFilterHeaderLine filterHeaderLine = (VCFFilterHeaderLine)headerLine;
                infoBuilder.setName(filterHeaderLine.getID());
                if (!filterHeaderLine.getValue().isEmpty()) {
                    infoBuilder.setType(filterHeaderLine.getValue());
                } else {
                    infoBuilder.setType("int");
                }
                infoBuilder.addVcfFieldClass("FILTER");
                GenomicsDBVidMapProto.InfoField filterField = infoBuilder.build();
                infoFields.add(filterField);
                continue;
            }
            if (!(headerLine instanceof VCFContigHeaderLine)) continue;
            VCFContigHeaderLine contigHeaderLine = (VCFContigHeaderLine)headerLine;
            long length = contigHeaderLine.getSAMSequenceRecord().getSequenceLength();
            GenomicsDBVidMapProto.Chromosome.Builder contigBuilder = GenomicsDBVidMapProto.Chromosome.newBuilder();
            contigBuilder.setName(contigHeaderLine.getID()).setLength(length).setTiledbColumnOffset(columnOffset);
            columnOffset += length;
            GenomicsDBVidMapProto.Chromosome chromosome = contigBuilder.build();
            contigs.add(chromosome);
        }
        GenomicsDBVidMapProto.VidMappingPB.Builder vidMapBuilder = GenomicsDBVidMapProto.VidMappingPB.newBuilder();
        return vidMapBuilder.addAllInfofields(infoFields).addAllChromosomes(contigs).build();
    }

    private GenomicsDBVidMapProto.InfoField remove(List<GenomicsDBVidMapProto.InfoField> infoFields, int dpIndex) {
        GenomicsDBVidMapProto.InfoField dpFormatField = infoFields.get(dpIndex);
        infoFields.remove(dpIndex);
        return dpFormatField;
    }

    private String getLength(VCFHeaderLine headerLine) {
        VCFHeaderLineCount type = headerLine instanceof VCFFormatHeaderLine ? ((VCFFormatHeaderLine)headerLine).getCountType() : ((VCFInfoHeaderLine)headerLine).getCountType();
        String length = "";
        switch (type) {
            case UNBOUNDED: {
                length = "VAR";
                break;
            }
            case A: {
                length = "A";
                break;
            }
            case R: {
                length = "R";
                break;
            }
            case G: {
                length = "G";
                break;
            }
            case INTEGER: {
                length = headerLine instanceof VCFFormatHeaderLine ? String.valueOf(((VCFFormatHeaderLine)headerLine).getCount()) : String.valueOf(((VCFInfoHeaderLine)headerLine).getCount());
            }
        }
        return length;
    }

    public static long initializeSampleInfoMapFromHeader(Map<Integer, SampleInfo> sampleIndexToInfo, VCFHeader vcfHeader, long rowIdx) {
        List headerSampleNames = vcfHeader.getGenotypeSamples();
        int numSamplesInHeader = headerSampleNames.size();
        for (int i = 0; i < numSamplesInHeader; ++i) {
            sampleIndexToInfo.put(i, new SampleInfo((String)headerSampleNames.get(i), rowIdx + (long)i));
        }
        return rowIdx + (long)numSamplesInHeader;
    }

    public int addBufferStream(String streamName, VCFHeader vcfHeader, long bufferCapacity, VariantContextWriterBuilder.OutputType streamType, Map<Integer, SampleInfo> sampleIndexToInfo) throws GenomicsDBException {
        return this.addBufferStream(streamName, vcfHeader, bufferCapacity, streamType, null, sampleIndexToInfo);
    }

    public int addSortedVariantContextIterator(String streamName, VCFHeader vcfHeader, Iterator<VariantContext> vcIterator, long bufferCapacity, VariantContextWriterBuilder.OutputType streamType, Map<Integer, SampleInfo> sampleIndexToInfo) throws GenomicsDBException {
        return this.addBufferStream(streamName, vcfHeader, bufferCapacity, streamType, vcIterator, sampleIndexToInfo);
    }

    public int setSortedVariantContextIterator(String streamName, VCFHeader vcfHeader, Iterator<VariantContext> vcIterator, long bufferCapacity, VariantContextWriterBuilder.OutputType streamType, Map<Integer, SampleInfo> sampleIndexToInfo) throws GenomicsDBException, IOException {
        int streamIdx = this.addSortedVariantContextIterator(streamName, vcfHeader, vcIterator, bufferCapacity, streamType, sampleIndexToInfo);
        this.setupGenomicsDBImporter();
        return streamIdx;
    }

    private int addBufferStream(String streamName, VCFHeader vcfHeader, long bufferCapacity, VariantContextWriterBuilder.OutputType streamType, Iterator<VariantContext> vcIterator, Map<Integer, SampleInfo> sampleIndexToInfo) throws GenomicsDBException {
        if (this.mIsLoaderSetupDone) {
            throw new GenomicsDBException("Cannot add buffer streams after setupGenomicsDBImporter() is called");
        }
        if (!this.mContainsBufferStreams) {
            if (this.mGenomicsDBImporterObjectHandle == 0L) {
                this.mGenomicsDBImporterObjectHandle = this.jniInitializeGenomicsDBImporterObject(this.mLoaderJSONFile, this.mRank, this.mLbRowIdx, this.mUbRowIdx);
            }
            if (this.mGenomicsDBImporterObjectHandle == 0L) {
                throw new GenomicsDBException("Could not initialize GenomicsDBImporter object");
            }
            this.mBufferStreamWrapperVector = new ArrayList();
            this.mCallsetMappingJSON = new JSONObject();
            this.mContainsBufferStreams = true;
        }
        this.mBufferStreamWrapperVector.add(new GenomicsDBImporterStreamWrapper(vcfHeader, bufferCapacity, streamType, vcIterator));
        int currIdx = this.mBufferStreamWrapperVector.size() - 1;
        SilentByteBufferStream currStream = this.mBufferStreamWrapperVector.get((int)currIdx).mStream;
        this.jniAddBufferStream(this.mGenomicsDBImporterObjectHandle, streamName, streamType == VariantContextWriterBuilder.OutputType.BCF_STREAM, bufferCapacity, currStream.getBuffer(), currStream.getNumValidBytes());
        if (sampleIndexToInfo != null) {
            for (Map.Entry<Integer, SampleInfo> currEntry : sampleIndexToInfo.entrySet()) {
                JSONObject sampleJSON = new JSONObject();
                sampleJSON.put((Object)"row_idx", (Object)currEntry.getValue().mRowIdx);
                sampleJSON.put((Object)"stream_name", (Object)streamName);
                sampleJSON.put((Object)"idx_in_file", (Object)currEntry.getKey());
                this.mCallsetMappingJSON.put((Object)currEntry.getValue().mName, (Object)sampleJSON);
            }
        }
        return currIdx;
    }

    public void setupGenomicsDBImporter() throws IOException {
        if (this.mIsLoaderSetupDone) {
            return;
        }
        JSONObject topCallsetJSON = new JSONObject();
        topCallsetJSON.put((Object)"callsets", (Object)this.mCallsetMappingJSON);
        StringWriter stringWriter = new StringWriter();
        topCallsetJSON.writeJSONString((Writer)stringWriter);
        long mMaxBufferStreamIdentifiers = this.jniSetupGenomicsDBLoader(this.mGenomicsDBImporterObjectHandle, stringWriter.toString(), this.mUsingVidMappingProtoBuf);
        this.mExhaustedBufferStreamIdentifiers = new long[2 * (int)mMaxBufferStreamIdentifiers + 1];
        int i = 0;
        int idx = 0;
        while (i < this.mBufferStreamWrapperVector.size()) {
            SilentByteBufferStream currStream = this.mBufferStreamWrapperVector.get((int)i).mStream;
            currStream.setNumValidBytes(0L);
            this.mExhaustedBufferStreamIdentifiers[idx] = i;
            this.mExhaustedBufferStreamIdentifiers[idx + 1] = 0L;
            ++i;
            idx += 2;
        }
        this.mExhaustedBufferStreamIdentifiers[(int)(2L * mMaxBufferStreamIdentifiers)] = this.mNumExhaustedBufferStreams = (long)this.mBufferStreamWrapperVector.size();
        this.mIsLoaderSetupDone = true;
    }

    public boolean add(VariantContext vc, int streamIdx) throws GenomicsDBException, RuntimeIOException {
        if (streamIdx < 0 || streamIdx >= this.mBufferStreamWrapperVector.size()) {
            throw new GenomicsDBException("Invalid stream idx " + Integer.toString(streamIdx) + " must be between [0-" + Long.toString(this.mBufferStreamWrapperVector.size() - 1) + "]");
        }
        if (!this.mIsLoaderSetupDone) {
            throw new GenomicsDBException("Cannot add VariantContext objects to streams before calling setupGenomicsDBImporter()");
        }
        GenomicsDBImporterStreamWrapper currWrapper = this.mBufferStreamWrapperVector.get(streamIdx);
        currWrapper.mVCWriter.add(vc);
        SilentByteBufferStream currStream = currWrapper.mStream;
        if (currStream.overflow() && currStream.getMarker() > 0L) {
            currStream.setNumValidBytes(currStream.getMarker());
            return false;
        }
        while (currStream.overflow()) {
            currStream.resize(2 * currStream.size() + 1);
            currStream.setNumValidBytes(0L);
            currStream.setOverflow(false);
            currWrapper.mVCWriter.add(vc);
        }
        currStream.setMarker(currStream.getNumValidBytes());
        return true;
    }

    public boolean importBatch() throws IOException {
        if (this.mDone) {
            return true;
        }
        if (!this.mIsLoaderSetupDone) {
            this.setupGenomicsDBImporter();
        }
        boolean allExhaustedStreamsHaveIterators = true;
        while (!this.mDone && allExhaustedStreamsHaveIterators) {
            int i = 0;
            int idx = 0;
            while ((long)i < this.mNumExhaustedBufferStreams) {
                int bufferStreamIdx = (int)this.mExhaustedBufferStreamIdentifiers[idx];
                GenomicsDBImporterStreamWrapper currWrapper = this.mBufferStreamWrapperVector.get(bufferStreamIdx);
                if (currWrapper.hasIterator()) {
                    boolean added;
                    while (currWrapper.getCurrentVC() != null && (added = this.add(currWrapper.getCurrentVC(), bufferStreamIdx))) {
                        currWrapper.next();
                    }
                }
                SilentByteBufferStream currStream = currWrapper.mStream;
                this.jniWriteDataToBufferStream(this.mGenomicsDBImporterObjectHandle, bufferStreamIdx, 0, currStream.getBuffer(), currStream.getNumValidBytes());
                ++i;
                idx += 2;
            }
            this.mDone = this.jniImportBatch(this.mGenomicsDBImporterObjectHandle, this.mExhaustedBufferStreamIdentifiers);
            this.mNumExhaustedBufferStreams = this.mExhaustedBufferStreamIdentifiers[this.mExhaustedBufferStreamIdentifiers.length - 1];
            long i2 = 0L;
            long idx2 = 0L;
            while (i2 < this.mNumExhaustedBufferStreams) {
                int bufferStreamIdx = (int)this.mExhaustedBufferStreamIdentifiers[(int)idx2];
                GenomicsDBImporterStreamWrapper currWrapper = this.mBufferStreamWrapperVector.get(bufferStreamIdx);
                if (!currWrapper.hasIterator()) {
                    allExhaustedStreamsHaveIterators = false;
                }
                SilentByteBufferStream currStream = currWrapper.mStream;
                currStream.setOverflow(false);
                currStream.setMarker(0L);
                currStream.setNumValidBytes(0L);
                ++i2;
                idx2 += 2L;
            }
            if (!this.mDone) continue;
            this.mGenomicsDBImporterObjectHandle = 0L;
            this.mContainsBufferStreams = false;
            this.mIsLoaderSetupDone = false;
        }
        FileUtils.deleteQuietly((File)new File(mTempLoaderJSONFileName));
        return this.mDone;
    }

    public long getNumExhaustedBufferStreams() {
        return this.mNumExhaustedBufferStreams;
    }

    public int getExhaustedBufferStreamIndex(long i) {
        assert (i < this.mNumExhaustedBufferStreams && i >= 0L);
        return (int)this.mExhaustedBufferStreamIdentifiers[2 * (int)i];
    }

    public boolean isDone() {
        return this.mDone;
    }

    private static ArrayList<ChromosomeInterval> getChromosomeIntervalsForColumnPartition(String loaderJSONFile, int partitionIdx) throws ParseException {
        String chromosomeIntervalsJSONString = GenomicsDBImporter.jniGetChromosomeIntervalsForColumnPartition(loaderJSONFile, partitionIdx);
        ArrayList<ChromosomeInterval> chromosomeIntervals = new ArrayList<ChromosomeInterval>();
        JSONParser parser = new JSONParser();
        JSONObject topObj = (JSONObject)parser.parse(chromosomeIntervalsJSONString);
        assert (topObj.containsKey((Object)"contigs"));
        JSONArray listOfDictionaries = (JSONArray)topObj.get((Object)"contigs");
        for (Object currDictObj : listOfDictionaries) {
            JSONObject currDict = (JSONObject)currDictObj;
            assert (currDict.size() == 1);
            for (Object currEntryObj : currDict.entrySet()) {
                Map.Entry currEntry = (Map.Entry)currEntryObj;
                JSONArray currValue = (JSONArray)currEntry.getValue();
                assert (currValue.size() == 2);
                chromosomeIntervals.add(new ChromosomeInterval((String)currEntry.getKey(), (Long)currValue.get(0), (Long)currValue.get(1)));
            }
        }
        return chromosomeIntervals;
    }

    public static <SOURCE> MultiChromosomeIterator<SOURCE> columnPartitionIterator(AbstractFeatureReader<VariantContext, SOURCE> reader, String loaderJSONFile, int partitionIdx) throws ParseException, IOException {
        return new MultiChromosomeIterator<SOURCE>(reader, GenomicsDBImporter.getChromosomeIntervalsForColumnPartition(loaderJSONFile, partitionIdx));
    }

    public <SOURCE> MultiChromosomeIterator<SOURCE> columnPartitionIterator(AbstractFeatureReader<VariantContext, SOURCE> reader) throws ParseException, IOException {
        return GenomicsDBImporter.columnPartitionIterator(reader, this.mLoaderJSONFile, this.mRank);
    }

    public void write() throws GenomicsDBException {
        this.write(this.mLoaderJSONFile, this.mRank, 0L, 0x7FFFFFFFFFFFFFFEL);
    }

    public void write(long lbRowIdx) throws GenomicsDBException {
        this.write(this.mLoaderJSONFile, this.mRank, lbRowIdx, 0x7FFFFFFFFFFFFFFEL);
    }

    public void write(int rank, long lbRowIdx) throws GenomicsDBException {
        this.write(this.mLoaderJSONFile, rank, lbRowIdx, 0x7FFFFFFFFFFFFFFEL);
    }

    public void write(int rank, long lbRowIdx, long ubRowIdx) throws GenomicsDBException {
        this.write(this.mLoaderJSONFile, rank, lbRowIdx, ubRowIdx);
    }

    public void write(String loaderJSONFile, int rank, long lbRowIdx, long ubRowIdx) throws GenomicsDBException {
        this.mDone = false;
        if (loaderJSONFile == null) {
            throw new GenomicsDBException("Loader JSON file not specified");
        }
        if (this.mContainsBufferStreams) {
            throw new GenomicsDBException("Cannot call write() functions if buffer streams are added");
        }
        int status = this.jniGenomicsDBImporter(loaderJSONFile, rank, lbRowIdx, ubRowIdx);
        if (status != 0) {
            throw new GenomicsDBException("GenomicsDBImporter write failed for loader JSON: " + loaderJSONFile + " rank: " + rank);
        }
        this.mDone = true;
    }

    static {
        try {
            boolean loaded = GenomicsDBUtils.loadLibrary();
            if (!loaded) {
                throw new GenomicsDBException("Could not load genomicsdb native library");
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw new GenomicsDBException("Could not load genomicsdb native library");
        }
        mDefaultBufferCapacity = 20480L;
    }
}

