/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBException;
import com.intel.genomicsdb.SilentByteBufferStream;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.OutputStream;
import java.util.Iterator;

class GenomicsDBImporterStreamWrapper {
    VariantContextWriter mVCWriter = null;
    SilentByteBufferStream mStream = null;
    private Iterator<VariantContext> mIterator = null;
    private VariantContext mCurrentVC = null;

    public GenomicsDBImporterStreamWrapper(VCFHeader vcfHeader, long bufferCapacity, VariantContextWriterBuilder.OutputType streamType, Iterator<VariantContext> vcIterator) throws GenomicsDBException {
        this.mIterator = vcIterator;
        if (vcIterator != null && vcIterator.hasNext()) {
            this.mCurrentVC = vcIterator.next();
        }
        boolean headerWritten = false;
        long currentCapacity = bufferCapacity;
        while (!headerWritten) {
            this.mStream = new SilentByteBufferStream(currentCapacity);
            switch (streamType) {
                case BCF_STREAM: {
                    this.mVCWriter = new VariantContextWriterBuilder().setOutputBCFStream((OutputStream)this.mStream).unsetOption(Options.INDEX_ON_THE_FLY).build();
                    break;
                }
                case VCF_STREAM: {
                    this.mVCWriter = new VariantContextWriterBuilder().setOutputVCFStream((OutputStream)this.mStream).unsetOption(Options.INDEX_ON_THE_FLY).build();
                    break;
                }
                default: {
                    throw new GenomicsDBException("Unknown stream type " + streamType.toString());
                }
            }
            this.mVCWriter.writeHeader(new VCFHeader(vcfHeader));
            if (this.mStream.overflow()) {
                currentCapacity = 2L * currentCapacity + 1L;
                continue;
            }
            headerWritten = true;
        }
    }

    boolean hasIterator() {
        return this.mIterator != null;
    }

    public VariantContext next() {
        this.mCurrentVC = this.mIterator != null && this.mIterator.hasNext() ? this.mIterator.next() : null;
        return this.mCurrentVC;
    }

    VariantContext getCurrentVC() {
        return this.mCurrentVC;
    }
}

