/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBConfiguration;
import com.intel.genomicsdb.GenomicsDBFeatureReader;
import com.intel.genomicsdb.GenomicsDBInputSplit;
import com.intel.genomicsdb.GenomicsDBRecordReader;
import htsjdk.tribble.Feature;
import htsjdk.variant.bcf2.BCF2Codec;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class GenomicsDBInputFormat<VCONTEXT extends Feature, SOURCE>
extends InputFormat<String, VCONTEXT>
implements Configurable {
    private GenomicsDBConfiguration genomicsDBConfiguration;
    private Configuration configuration;
    Logger logger = Logger.getLogger(GenomicsDBInputFormat.class);

    public List<InputSplit> getSplits(JobContext jobContext) throws FileNotFoundException {
        this.genomicsDBConfiguration = new GenomicsDBConfiguration(this.configuration);
        this.genomicsDBConfiguration.setLoaderJsonFile(this.configuration.get("genomicsdb.input.loaderjsonfile"));
        this.genomicsDBConfiguration.setQueryJsonFile(this.configuration.get("genomicsdb.input.queryjsonfile"));
        this.genomicsDBConfiguration.setHostFile(this.configuration.get("genomicsdb.input.mpi.hostfile"));
        List<String> hosts = this.genomicsDBConfiguration.getHosts();
        ArrayList<InputSplit> inputSplits = new ArrayList<InputSplit>(hosts.size());
        for (int i = 0; i < hosts.size(); ++i) {
            GenomicsDBInputSplit split = new GenomicsDBInputSplit();
            inputSplits.add(split);
        }
        return inputSplits;
    }

    public RecordReader<String, VCONTEXT> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        String queryJson;
        String loaderJson;
        if (taskAttemptContext != null) {
            Configuration configuration = taskAttemptContext.getConfiguration();
            loaderJson = configuration.get("genomicsdb.input.loaderjsonfile");
            queryJson = configuration.get("genomicsdb.input.queryjsonfile");
        } else {
            assert (this.configuration != null);
            loaderJson = this.configuration.get("genomicsdb.input.loaderjsonfile");
            queryJson = this.configuration.get("genomicsdb.input.queryjsonfile");
        }
        GenomicsDBFeatureReader featureReader = new GenomicsDBFeatureReader(loaderJson, queryJson, new BCF2Codec());
        GenomicsDBRecordReader recordReader = new GenomicsDBRecordReader(featureReader);
        return recordReader;
    }

    public GenomicsDBInputFormat() {
    }

    public GenomicsDBInputFormat(GenomicsDBConfiguration conf) {
        this.genomicsDBConfiguration = conf;
    }

    public GenomicsDBInputFormat<VCONTEXT, SOURCE> setLoaderJsonFile(String jsonFile) {
        this.genomicsDBConfiguration.setLoaderJsonFile(jsonFile);
        return this;
    }

    public GenomicsDBInputFormat<VCONTEXT, SOURCE> setQueryJsonFile(String jsonFile) {
        this.genomicsDBConfiguration.setQueryJsonFile(jsonFile);
        return this;
    }

    public GenomicsDBInputFormat<VCONTEXT, SOURCE> setHostFile(String hostFile) throws FileNotFoundException {
        this.genomicsDBConfiguration.setHostFile(hostFile);
        return this;
    }

    public void setConf(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConf() {
        return this.configuration;
    }
}

