/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.log4j.Logger;

public class GenomicsDBInputSplit
extends InputSplit
implements Writable {
    String[] hosts;
    long length = 0L;
    Logger logger = Logger.getLogger(GenomicsDBInputSplit.class);

    public GenomicsDBInputSplit() {
    }

    public GenomicsDBInputSplit(long length) {
        this.length = length;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.length);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.hosts = null;
        this.length = dataInput.readLong();
    }

    public long getLength() throws IOException, InterruptedException {
        return this.length;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        this.hosts = new String[1];
        this.hosts[0] = InetAddress.getLocalHost().getHostName();
        return this.hosts;
    }
}

