/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBContext;
import com.intel.genomicsdb.GenomicsDBInputFormat;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;

public final class GenomicsDBJavaSparkFactory {
    private static void usingGenomicsRDD(String[] args) {
        String loaderJsonFile = args[0];
        String queryJsonFile = args[1];
        String hostfile = args[2];
        SparkConf conf = new SparkConf();
        conf.setAppName("GenomicsDBTest using GenomicsDBRDD");
        JavaSparkContext sc = new JavaSparkContext(conf);
        Configuration hadoopConf = sc.hadoopConfiguration();
        hadoopConf.set("genomicsdb.input.loaderjsonfile", loaderJsonFile);
        hadoopConf.set("genomicsdb.input.queryjsonfile", queryJsonFile);
        hadoopConf.set("genomicsdb.input.mpi.hostfile", hostfile);
        GenomicsDBContext gc = new GenomicsDBContext(hadoopConf, sc.sc());
        JavaRDD variants = gc.getVariantContexts().toJavaRDD();
        System.out.println("Number of variants " + variants.count());
        List variantList = variants.collect();
        for (Object variantObj : variantList) {
            System.out.println(variantObj);
        }
    }

    public static void usingNewAPIHadoopRDD(String[] args) {
        String loaderJsonFile = args[0];
        String queryJsonFile = args[1];
        String hostfile = args[2];
        SparkConf conf = new SparkConf();
        conf.setAppName("GenomicsDBTest using newAPIHadoopRDD");
        JavaSparkContext sc = new JavaSparkContext(conf);
        Configuration hadoopConf = sc.hadoopConfiguration();
        hadoopConf.set("genomicsdb.input.loaderjsonfile", loaderJsonFile);
        hadoopConf.set("genomicsdb.input.queryjsonfile", queryJsonFile);
        hadoopConf.set("genomicsdb.input.mpi.hostfile", hostfile);
        Class<GenomicsDBInputFormat> gformatClazz = GenomicsDBInputFormat.class;
        JavaPairRDD variants = sc.newAPIHadoopRDD(hadoopConf, gformatClazz, String.class, VariantContext.class);
        System.out.println("Number of variants " + variants.count());
        List variantList = variants.collect();
        for (Object variantObj : variantList) {
            System.out.println(variantObj);
        }
    }

    public static void main(String[] args) throws Exception {
        GenomicsDBJavaSparkFactory.usingGenomicsRDD(args);
    }
}

