/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBException;
import com.intel.genomicsdb.GenomicsDBUtils;
import java.io.IOException;
import java.io.InputStream;

public class GenomicsDBQueryStream
extends InputStream {
    private String mLoaderJSONFile;
    private String mQueryJSONFile;
    private long mGenomicsDBReadStateHandle = 0L;

    private native long jniGenomicsDBInit(String var1, String var2, String var3, int var4, int var5, int var6, long var7, long var9);

    private native long jniGenomicsDBClose(long var1);

    private native long jniGenomicsDBGetNumBytesAvailable(long var1);

    private native byte jniGenomicsDBReadNextByte(long var1);

    private native int jniGenomicsDBRead(long var1, byte[] var3, int var4, int var5);

    private native long jniGenomicsDBSkip(long var1, long var3);

    public GenomicsDBQueryStream(String loaderJSONFile, String queryJSONFile) {
        this(loaderJSONFile, queryJSONFile, "", 0, 0);
    }

    public GenomicsDBQueryStream(String loaderJSONFile, String queryJSONFile, String chr, int start, int end) {
        this(loaderJSONFile, queryJSONFile, chr, start, end, 0);
    }

    public GenomicsDBQueryStream(String loaderJSONFile, String queryJSONFile, String chr, int start, int end, int rank) {
        this(loaderJSONFile, queryJSONFile, chr, start, end, rank, 0xA00000L, 0xA00000L);
    }

    public GenomicsDBQueryStream(String loaderJSONFile, String queryJSONFile, String chr, int start, int end, int rank, long bufferCapacity, long segmentSize) {
        this.mLoaderJSONFile = loaderJSONFile;
        this.mQueryJSONFile = queryJSONFile;
        this.mGenomicsDBReadStateHandle = this.jniGenomicsDBInit(loaderJSONFile, queryJSONFile, chr, start, end, rank, bufferCapacity, segmentSize);
    }

    @Override
    public int available() throws IOException {
        return (int)this.jniGenomicsDBGetNumBytesAvailable(this.mGenomicsDBReadStateHandle);
    }

    @Override
    public void close() throws IOException {
        this.mGenomicsDBReadStateHandle = this.jniGenomicsDBClose(this.mGenomicsDBReadStateHandle);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.jniGenomicsDBReadNextByte(this.mGenomicsDBReadStateHandle);
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        long numBytesRead = this.jniGenomicsDBRead(this.mGenomicsDBReadStateHandle, buffer, off, len);
        return numBytesRead == 0L ? -1 : (int)numBytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.jniGenomicsDBSkip(this.mGenomicsDBReadStateHandle, n);
    }

    static {
        try {
            boolean loaded = GenomicsDBUtils.loadLibrary();
            if (!loaded) {
                throw new GenomicsDBException("Could not load genomicsdb native library");
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw new GenomicsDBException("Could not load genomicsdb native library");
        }
    }
}

