/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class GenomicsDBRecordReader<VCONTEXT extends Feature, SOURCE>
extends RecordReader<String, VCONTEXT> {
    private final GenomicsDBFeatureReader<VCONTEXT, SOURCE> featureReader;
    private CloseableTribbleIterator<VCONTEXT> iterator;
    private VCONTEXT currentVariant;
    private long currentKey;

    GenomicsDBRecordReader(GenomicsDBFeatureReader<VCONTEXT, SOURCE> featureReader) {
        this.featureReader = featureReader;
        this.currentKey = -1L;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.initialize();
    }

    private void initialize() throws IOException {
        this.iterator = this.featureReader.iterator();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.iterator.hasNext()) {
            this.currentVariant = (Feature)this.iterator.next();
            ++this.currentKey;
            return true;
        }
        return false;
    }

    public String getCurrentKey() throws IOException, InterruptedException {
        return Long.toString(this.currentKey);
    }

    public VCONTEXT getCurrentValue() throws IOException, InterruptedException {
        return this.currentVariant;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
        this.iterator.close();
    }

    public Boolean hasNext() {
        return this.iterator.hasNext();
    }
}

