/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBConfiguration;
import com.intel.genomicsdb.GenomicsDBContext;
import com.intel.genomicsdb.GenomicsDBInputFormat;
import htsjdk.variant.variantcontext.VariantContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;

public final class GenomicsDBScalaSparkFactory$ {
    public static final GenomicsDBScalaSparkFactory$ MODULE$;

    static {
        new GenomicsDBScalaSparkFactory$();
    }

    public void usingGenomicsRDD(String[] args) {
        String master = args[0];
        String port = args[1];
        String loaderJsonFile = args[2];
        String queryJsonFile = args[3];
        String hostfile = args[4];
        SparkConf conf = new SparkConf().setMaster(new StringBuilder().append((Object)"spark://").append((Object)master).append((Object)":").append((Object)port).toString()).setAppName("GenomicsDBTest using GenomicsDBRDD");
        SparkContext sc = new SparkContext(conf);
        Configuration hadoopConf = sc.hadoopConfiguration();
        hadoopConf.set(GenomicsDBConfiguration.LOADERJSON, loaderJsonFile);
        hadoopConf.set(GenomicsDBConfiguration.QUERYJSON, queryJsonFile);
        hadoopConf.set(GenomicsDBConfiguration.MPIHOSTFILE, hostfile);
        GenomicsDBContext gc = new GenomicsDBContext(hadoopConf, sc);
        RDD<VariantContext> myrdd = gc.getVariantContexts();
        System.out.println(myrdd.count());
        Predef$.MODULE$.refArrayOps((Object[])myrdd.collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
    }

    public void usingNewAPIHadoopRDD(String[] args) {
        String master = args[0];
        String port = args[1];
        String loaderJsonFile = args[2];
        String queryJsonFile = args[3];
        String hostfile = args[4];
        SparkConf conf = new SparkConf().setMaster(new StringBuilder().append((Object)"spark://").append((Object)master).append((Object)":").append((Object)port).toString()).setAppName("GenomicsDBTest using newAPIHadoopRDD");
        SparkContext sc = new SparkContext(conf);
        Configuration hadoopConf = sc.hadoopConfiguration();
        hadoopConf.set(GenomicsDBConfiguration.LOADERJSON, loaderJsonFile);
        hadoopConf.set(GenomicsDBConfiguration.QUERYJSON, queryJsonFile);
        hadoopConf.set(GenomicsDBConfiguration.MPIHOSTFILE, hostfile);
        RDD myrdd = sc.newAPIHadoopRDD(sc.hadoopConfiguration(), GenomicsDBInputFormat.class, String.class, VariantContext.class);
        System.out.println(myrdd.count());
    }

    public void main(String[] args) {
        this.usingNewAPIHadoopRDD(args);
    }

    private GenomicsDBScalaSparkFactory$() {
        MODULE$ = this;
    }
}

