/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;

class GenomicsDBTimer {
    private long mBeginWallClockTime = 0L;
    private long mBeginCpuTime = 0L;
    private long mLastIntervalWallClockTime = 0L;
    private long mLastIntervalCpuTime = 0L;
    private double mCumulativeWallClockTime = 0.0;
    private double mCumulativeCpuTime = 0.0;

    public GenomicsDBTimer() {
        this.start();
    }

    public void start() {
        this.mBeginWallClockTime = System.nanoTime();
        this.mBeginCpuTime = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
    }

    public void stop() {
        long endWallClockTime = System.nanoTime();
        long endCpuTime = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
        this.mLastIntervalWallClockTime = endWallClockTime - this.mBeginWallClockTime;
        this.mLastIntervalCpuTime = endCpuTime - this.mBeginCpuTime;
        this.mCumulativeWallClockTime += (double)this.mLastIntervalWallClockTime / 1.0E9;
        this.mCumulativeCpuTime += (double)this.mLastIntervalCpuTime / 1.0E9;
    }

    public void print(String prefix, PrintStream fptr) {
        fptr.print("GENOMICSDB_TIMER,");
        if (!prefix.isEmpty()) {
            fptr.print(prefix + ',');
        }
        fptr.println("Wall-clock time(s)," + this.mCumulativeWallClockTime + ",Cpu time(s)," + this.mCumulativeCpuTime);
    }
}

