/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.ChromosomeInterval;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class MultiChromosomeIterator<SOURCE>
implements Iterator<VariantContext> {
    private ArrayList<ChromosomeInterval> mChromosomeIntervals = null;
    private AbstractFeatureReader<VariantContext, SOURCE> mReader = null;
    private int mIdxInIntervalList = 0;
    private CloseableTribbleIterator<VariantContext> mIterator = null;

    MultiChromosomeIterator(AbstractFeatureReader<VariantContext, SOURCE> reader, List<ChromosomeInterval> chromosomeIntervals) throws IOException {
        this.mReader = reader;
        VCFHeader mHeader = (VCFHeader)reader.getHeader();
        this.mChromosomeIntervals = new ArrayList();
        SAMSequenceDictionary contigDictionary = mHeader.getSequenceDictionary();
        for (ChromosomeInterval currInterval : chromosomeIntervals) {
            if (contigDictionary.getSequenceIndex(currInterval.mChromosomeName) == -1) continue;
            this.mChromosomeIntervals.add(currInterval);
        }
        if (this.mChromosomeIntervals.size() > 0) {
            ChromosomeInterval currInterval = this.mChromosomeIntervals.get(0);
            this.mIterator = this.mReader.query(currInterval.mChromosomeName, (int)currInterval.mBegin, (int)currInterval.mEnd);
        }
    }

    @Override
    public boolean hasNext() {
        return this.mIterator != null && this.mIterator.hasNext();
    }

    @Override
    public VariantContext next() throws NoSuchElementException {
        try {
            if (this.mIterator == null) {
                throw new NoSuchElementException("next() called for iterator with no more elements");
            }
            VariantContext returnValue = (VariantContext)this.mIterator.next();
            if (this.mIterator.hasNext()) {
                return returnValue;
            }
            ++this.mIdxInIntervalList;
            while (this.mIdxInIntervalList < this.mChromosomeIntervals.size()) {
                ChromosomeInterval currInterval = this.mChromosomeIntervals.get(this.mIdxInIntervalList);
                this.mIterator = this.mReader.query(currInterval.mChromosomeName, (int)currInterval.mBegin, (int)currInterval.mEnd);
                if (this.mIterator.hasNext()) {
                    return returnValue;
                }
                ++this.mIdxInIntervalList;
            }
            this.mIterator = null;
            return returnValue;
        }
        catch (IOException e) {
            throw new NoSuchElementException("Caught IOException: " + e.getMessage());
        }
    }
}

