/*
 * Decompiled with CFR 0.152.
 */
package com.intel.genomicsdb;

import com.intel.genomicsdb.GenomicsDBImporter;
import java.io.IOException;
import java.io.OutputStream;

class SilentByteBufferStream
extends OutputStream {
    private byte[] mBuffer = null;
    private long mNumValidBytes = 0L;
    private long mMarker = 0L;
    private boolean mOverflow = false;

    public SilentByteBufferStream() {
        this.mBuffer = new byte[(int)GenomicsDBImporter.mDefaultBufferCapacity];
    }

    public SilentByteBufferStream(long capacity) {
        this.mBuffer = new byte[(int)capacity];
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.mOverflow) {
            return;
        }
        if ((long)len + this.mNumValidBytes > (long)this.mBuffer.length) {
            this.mOverflow = true;
        } else {
            System.arraycopy(b, off, this.mBuffer, (int)this.mNumValidBytes, len);
            this.mNumValidBytes += (long)len;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mOverflow) {
            return;
        }
        if (this.mNumValidBytes + 1L > (long)this.mBuffer.length) {
            this.mOverflow = true;
        } else {
            this.mBuffer[(int)this.mNumValidBytes] = (byte)b;
            ++this.mNumValidBytes;
        }
    }

    public int size() {
        return this.mBuffer.length;
    }

    public void resize(long newSize) {
        byte[] tmp = new byte[(int)newSize];
        System.arraycopy(this.mBuffer, 0, tmp, 0, this.mBuffer.length);
        this.mBuffer = tmp;
    }

    public boolean overflow() {
        return this.mOverflow;
    }

    public void setOverflow(boolean value) {
        this.mOverflow = value;
    }

    public long getNumValidBytes() {
        return this.mNumValidBytes;
    }

    public void setNumValidBytes(long value) {
        this.mNumValidBytes = value;
    }

    public void setMarker(long value) {
        this.mMarker = value;
    }

    public long getMarker() {
        return this.mMarker;
    }

    public byte[] getBuffer() {
        return this.mBuffer;
    }
}

