/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.Heap;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.Range;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class AbstractMemoryBlock
extends AnyMemoryBlock {
    AbstractMemoryBlock(Heap heap, long size, boolean bounded, boolean transactional) {
        super(heap, size, bounded, transactional);
    }

    AbstractMemoryBlock(Heap heap, long poolHandle, long offset, boolean bounded) {
        super(heap, offset, bounded);
    }

    @Override
    public Heap heap() {
        return (Heap)super.heapInternal();
    }

    @Override
    abstract long metadataSize();

    @Override
    public void setByte(long offset, byte value) {
        super.rawSetByte(offset, value);
    }

    @Override
    public void setShort(long offset, short value) {
        super.rawSetShort(offset, value);
    }

    @Override
    public void setInt(long offset, int value) {
        super.rawSetInt(offset, value);
    }

    @Override
    public void setLong(long offset, long value) {
        super.rawSetLong(offset, value);
    }

    @Override
    public void copyFrom(MemoryAccessor srcAccessor, long srcOffset, long dstOffset, long length) {
        super.rawCopy(srcAccessor, srcOffset, dstOffset, length);
    }

    @Override
    public void copyFromArray(byte[] srcArray, int srcIndex, long dstOffset, int length) {
        super.rawCopyFromArray(srcArray, srcIndex, dstOffset, length);
    }

    @Override
    public void setMemory(byte value, long offset, long length) {
        super.rawSetMemory(value, offset, length);
    }

    @Override
    public <T> T withRange(long startOffset, long rangeLength, Function<Range, T> op) {
        return super.rawWithRange(startOffset, rangeLength, op);
    }

    @Override
    public void withRange(long startOffset, long rangeLength, Consumer<Range> op) {
        super.rawWithRange(startOffset, rangeLength, r -> {
            op.accept((Range)r);
            return null;
        });
    }

    @Override
    public void flush(long offset, long length) {
        super.flush(offset, length);
    }

    @Override
    public void addToTransaction(long offset, long length) {
        super.addToTransaction(offset, length);
    }

    public void free(boolean transactional) {
        this.heap().freeMemoryBlock(this, transactional);
    }

    @Override
    public void freeMemory() {
        this.heap().freeMemoryBlock(this, false);
    }
}

