/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.PersistentHeap;
import com.intel.pmem.llpl.Range;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class AbstractPersistentMemoryBlock
extends AnyMemoryBlock {
    private static final long METADATA_SIZE = 8L;

    AbstractPersistentMemoryBlock(PersistentHeap heap, long size, boolean bounded, boolean transactional) {
        super(heap, size, bounded, transactional);
    }

    AbstractPersistentMemoryBlock(PersistentHeap heap, long poolHandle, long offset, boolean bounded) {
        super(heap, offset, bounded);
    }

    @Override
    public PersistentHeap heap() {
        return (PersistentHeap)super.heapInternal();
    }

    @Override
    abstract long metadataSize();

    public void free(boolean transactional) {
        this.heap().freeMemoryBlock(this, transactional);
    }

    @Override
    public void freeMemory() {
        this.heap().freeMemoryBlock(this, false);
    }

    @Override
    public void setByte(long offset, byte value) {
        super.durableSetByte(offset, value);
    }

    @Override
    public void setShort(long offset, short value) {
        super.durableSetShort(offset, value);
    }

    @Override
    public void setInt(long offset, int value) {
        super.durableSetInt(offset, value);
    }

    @Override
    public void setLong(long offset, long value) {
        super.durableSetLong(offset, value);
    }

    @Override
    public void copyFrom(MemoryAccessor srcAccessor, long srcOffset, long dstOffset, long length) {
        super.durableCopy(srcAccessor, srcOffset, dstOffset, length);
    }

    @Override
    public void copyFromArray(byte[] srcArray, int srcIndex, long dstOffset, int length) {
        super.durableCopyFromArray(srcArray, srcIndex, dstOffset, length);
    }

    @Override
    public void setMemory(byte value, long offset, long length) {
        super.durableSetMemory(value, offset, length);
    }

    @Override
    public <T> T withRange(long startOffset, long rangeLength, Function<Range, T> op) {
        return super.durableWithRange(startOffset, rangeLength, op);
    }

    @Override
    public void withRange(long startOffset, long rangeLength, Consumer<Range> op) {
        super.durableWithRange(startOffset, rangeLength, r -> {
            op.accept((Range)r);
            return null;
        });
    }

    @Override
    public void transactionalSetByte(long offset, byte value) {
        super.transactionalSetByte(offset, value);
    }

    @Override
    public void transactionalSetShort(long offset, short value) {
        super.transactionalSetShort(offset, value);
    }

    @Override
    public void transactionalSetInt(long offset, int value) {
        super.transactionalSetInt(offset, value);
    }

    @Override
    public void transactionalSetLong(long offset, long value) {
        super.transactionalSetLong(offset, value);
    }

    public void transactionalCopyFromMemoryBlock(AnyMemoryBlock srcBlock, long srcOffset, long dstOffset, long length) {
        super.transactionalCopy(srcBlock, srcOffset, dstOffset, length);
    }

    @Override
    public void transactionalCopyFromArray(byte[] srcArray, int srcIndex, long dstOffset, int length) {
        super.transactionalCopyFromArray(srcArray, srcIndex, dstOffset, length);
    }

    @Override
    public void transactionalSetMemory(byte value, long offset, long length) {
        super.transactionalSetMemory(value, offset, length);
    }

    @Override
    public <T> T transactionalWithRange(long startOffset, long rangeLength, Function<Range, T> op) {
        return super.transactionalWithRange(startOffset, rangeLength, op);
    }

    public void transactionalWithRange(long startOffset, long rangeLength, Consumer<Range> op) {
        super.transactionalWithRange(startOffset, rangeLength, (Range r) -> {
            op.accept((Range)r);
            return null;
        });
    }
}

